/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.hz;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.hazelcast.core.IMap;
import org.onosproject.store.serializers.StoreSerializer;

public final class OptionalCacheLoader<K, V>
extends CacheLoader<K, Optional<V>> {
    private final StoreSerializer serializer;
    private IMap<byte[], byte[]> rawMap;

    public OptionalCacheLoader(StoreSerializer serializer, IMap<byte[], byte[]> rawMap) {
        this.serializer = (StoreSerializer)Preconditions.checkNotNull((Object)serializer);
        this.rawMap = (IMap)Preconditions.checkNotNull(rawMap);
    }

    public Optional<V> load(K key) throws Exception {
        byte[] keyBytes = this.serializer.encode(key);
        byte[] valBytes = (byte[])this.rawMap.get((Object)keyBytes);
        if (valBytes == null) {
            return Optional.absent();
        }
        Object dev = this.serializer.decode(valBytes);
        return Optional.of((Object)dev);
    }
}

