/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.hz;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.FileNotFoundException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.store.hz.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class StoreManager
implements StoreService {
    protected static final String HAZELCAST_XML_FILE = "etc/hazelcast.xml";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected HazelcastInstance instance;

    @Activate
    public void activate() {
        try {
            FileSystemXmlConfig config = new FileSystemXmlConfig(HAZELCAST_XML_FILE);
            this.instance = Hazelcast.newHazelcastInstance((Config)config);
            this.log.info("Started");
        }
        catch (FileNotFoundException e) {
            this.log.error("Unable to configure Hazelcast", (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate() {
        this.instance.shutdown();
        this.log.info("Stopped");
    }

    @Override
    public HazelcastInstance getHazelcastInstance() {
        return this.instance;
    }
}

