/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentStore;
import org.onosproject.net.intent.IntentStoreDelegate;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PartitionService;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.ecmap.EventuallyConsistentMap;
import org.onosproject.store.ecmap.EventuallyConsistentMapEvent;
import org.onosproject.store.ecmap.EventuallyConsistentMapImpl;
import org.onosproject.store.ecmap.EventuallyConsistentMapListener;
import org.onosproject.store.impl.MultiValuedTimestamp;
import org.onosproject.store.impl.WallClockTimestamp;
import org.onosproject.store.intent.impl.IntentDataClockManager;
import org.onosproject.store.intent.impl.IntentDataLogicalClockManager;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=false, enabled=true)
@Service
public class GossipIntentStore
extends AbstractStore<IntentEvent, IntentStoreDelegate>
implements IntentStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private EventuallyConsistentMap<Key, IntentData> currentMap;
    private EventuallyConsistentMap<Key, IntentData> pendingMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PartitionService partitionService;

    @Activate
    public void activate() {
        KryoNamespace.Builder intentSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{IntentData.class}).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{WallClockTimestamp.class});
        this.currentMap = new EventuallyConsistentMapImpl<Key, IntentData>("intent-current", this.clusterService, this.clusterCommunicator, intentSerializer, new IntentDataLogicalClockManager(), (key, intentData) -> this.getPeerNodes((Key)key, (IntentData)intentData));
        this.pendingMap = new EventuallyConsistentMapImpl<Key, IntentData>("intent-pending", this.clusterService, this.clusterCommunicator, intentSerializer, new IntentDataClockManager(), (key, intentData) -> this.getPeerNodes((Key)key, (IntentData)intentData));
        this.currentMap.addListener(new InternalCurrentListener());
        this.pendingMap.addListener(new InternalPendingListener());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.currentMap.destroy();
        this.pendingMap.destroy();
        this.log.info("Stopped");
    }

    public long getIntentCount() {
        return this.currentMap.size();
    }

    public Iterable<Intent> getIntents() {
        return this.currentMap.values().stream().map(IntentData::intent).collect(Collectors.toList());
    }

    public IntentState getIntentState(Key intentKey) {
        IntentData data = this.currentMap.get(intentKey);
        if (data != null) {
            return data.state();
        }
        return null;
    }

    public List<Intent> getInstallableIntents(Key intentKey) {
        IntentData data = this.currentMap.get(intentKey);
        if (data != null) {
            return data.installables();
        }
        return null;
    }

    private IntentData copyData(IntentData original) {
        if (original == null) {
            return null;
        }
        IntentData result = new IntentData(original.intent(), original.state(), original.version());
        if (original.installables() != null) {
            result.setInstallables(original.installables());
        }
        result.setOrigin(original.origin());
        return result;
    }

    private boolean isUpdateAcceptable(IntentData currentData, IntentData newData) {
        if (currentData == null) {
            return true;
        }
        if (currentData.version().compareTo((Object)newData.version()) < 0) {
            return true;
        }
        if (currentData.version().compareTo((Object)newData.version()) > 0) {
            return false;
        }
        IntentState currentState = currentData.state();
        IntentState newState = newData.state();
        switch (newState) {
            case INSTALLING: {
                if (currentState == IntentState.INSTALLING) {
                    return false;
                }
            }
            case INSTALLED: {
                if (currentState == IntentState.INSTALLED) {
                    return false;
                }
                if (currentState == IntentState.WITHDRAWING || currentState == IntentState.WITHDRAWN) {
                    this.log.warn("Invalid state transition from {} to {} for intent {}", new Object[]{currentState, newState, newData.key()});
                    return false;
                }
                return true;
            }
            case WITHDRAWING: {
                if (currentState == IntentState.WITHDRAWING) {
                    return false;
                }
            }
            case WITHDRAWN: {
                if (currentState == IntentState.WITHDRAWN) {
                    return false;
                }
                if (currentState == IntentState.INSTALLING || currentState == IntentState.INSTALLED) {
                    this.log.warn("Invalid state transition from {} to {} for intent {}", new Object[]{currentState, newState, newData.key()});
                    return false;
                }
                return true;
            }
            case FAILED: {
                return currentState != IntentState.FAILED;
            }
            case PURGE_REQ: {
                return true;
            }
        }
        this.log.warn("Invalid state {} for intent {}", (Object)newState, (Object)newData.key());
        return false;
    }

    public void write(IntentData newData) {
        IntentData currentData = this.currentMap.get(newData.key());
        if (this.isUpdateAcceptable(currentData, newData)) {
            if (newData.state() == IntentState.PURGE_REQ) {
                this.currentMap.remove(newData.key(), newData);
            } else {
                this.currentMap.put(newData.key(), this.copyData(newData));
            }
            this.pendingMap.remove(newData.key(), newData);
        } else {
            this.log.debug("not writing update: current {}, new {}", (Object)currentData, (Object)newData);
        }
    }

    private Collection<NodeId> getPeerNodes(Key key, IntentData data) {
        NodeId origin;
        NodeId master = this.partitionService.getLeader(key);
        NodeId nodeId = origin = data != null ? data.origin() : null;
        if (master == null || origin == null) {
            this.log.warn("Intent {} has no home; master = {}, origin = {}", new Object[]{data.key(), master, origin});
        }
        NodeId me = this.clusterService.getLocalNode().id();
        boolean isMaster = Objects.equals(master, me);
        boolean isOrigin = Objects.equals(origin, me);
        if (isMaster && isOrigin) {
            return this.getRandomNode();
        }
        if (isMaster) {
            return origin != null ? ImmutableList.of((Object)origin) : this.getRandomNode();
        }
        if (isOrigin) {
            return master != null ? ImmutableList.of((Object)master) : this.getRandomNode();
        }
        this.log.warn("Not master or origin for intent {}", (Object)data.key());
        return ImmutableList.of((Object)master);
    }

    private List<NodeId> getRandomNode() {
        NodeId me = this.clusterService.getLocalNode().id();
        List nodes = this.clusterService.getNodes().stream().map(ControllerNode::id).filter(node -> !Objects.equals(node, me)).collect(Collectors.toList());
        if (nodes.size() == 0) {
            return null;
        }
        return ImmutableList.of(nodes.get(RandomUtils.nextInt((int)nodes.size())));
    }

    public void batchWrite(Iterable<IntentData> updates) {
        updates.forEach(this::write);
    }

    public Intent getIntent(Key key) {
        IntentData data = this.currentMap.get(key);
        if (data != null) {
            return data.intent();
        }
        return null;
    }

    public IntentData getIntentData(Key key) {
        return this.copyData(this.currentMap.get(key));
    }

    public void addPending(IntentData data) {
        if (data.version() == null) {
            data.setVersion((Timestamp)new WallClockTimestamp());
        }
        data.setOrigin(this.clusterService.getLocalNode().id());
        this.pendingMap.put(data.key(), this.copyData(data));
    }

    public boolean isMaster(Key intentKey) {
        return this.partitionService.isMine(intentKey);
    }

    public Iterable<Intent> getPending() {
        return this.pendingMap.values().stream().map(IntentData::intent).collect(Collectors.toList());
    }

    private void notifyDelegateIfNotNull(IntentEvent event) {
        if (event != null) {
            this.notifyDelegate((Event)event);
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindPartitionService(PartitionService partitionService) {
        this.partitionService = partitionService;
    }

    protected void unbindPartitionService(PartitionService partitionService) {
        if (this.partitionService == partitionService) {
            this.partitionService = null;
        }
    }

    private final class InternalPendingListener
    implements EventuallyConsistentMapListener<Key, IntentData> {
        private InternalPendingListener() {
        }

        @Override
        public void event(EventuallyConsistentMapEvent<Key, IntentData> event) {
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                if (GossipIntentStore.this.isMaster(event.value().intent().key()) && GossipIntentStore.this.delegate != null) {
                    GossipIntentStore.this.log.debug("processing {}", (Object)event.key());
                    ((IntentStoreDelegate)GossipIntentStore.this.delegate).process(GossipIntentStore.this.copyData(event.value()));
                }
                GossipIntentStore.this.notifyDelegateIfNotNull(IntentEvent.getEvent((IntentData)event.value()));
            }
        }
    }

    private final class InternalCurrentListener
    implements EventuallyConsistentMapListener<Key, IntentData> {
        private InternalCurrentListener() {
        }

        @Override
        public void event(EventuallyConsistentMapEvent<Key, IntentData> event) {
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                IntentData intentData = event.value();
                GossipIntentStore.this.notifyDelegateIfNotNull(IntentEvent.getEvent((IntentData)intentData));
            }
        }
    }
}

