/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.link.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNodeToNodeId;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotations;
import org.onosproject.net.AnnotationsUtil;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkStore;
import org.onosproject.net.link.LinkStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.impl.Timestamped;
import org.onosproject.store.link.impl.GossipLinkStoreMessageSubjects;
import org.onosproject.store.link.impl.InternalLinkEvent;
import org.onosproject.store.link.impl.InternalLinkRemovedEvent;
import org.onosproject.store.link.impl.LinkAntiEntropyAdvertisement;
import org.onosproject.store.link.impl.LinkFragmentId;
import org.onosproject.store.link.impl.LinkInjectedEvent;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.impl.DistributedStoreSerializers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class GossipLinkStore
extends AbstractStore<LinkEvent, LinkStoreDelegate>
implements LinkStore {
    private static final int REMOTE_MASTER_TIMEOUT = 1000;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<LinkKey, Map<ProviderId, Timestamped<LinkDescription>>> linkDescs = new ConcurrentHashMap<LinkKey, Map<ProviderId, Timestamped<LinkDescription>>>();
    private final ConcurrentMap<LinkKey, Link> links = new ConcurrentHashMap<LinkKey, Link>();
    private final SetMultimap<DeviceId, LinkKey> srcLinks = GossipLinkStore.createSynchronizedHashMultiMap();
    private final SetMultimap<DeviceId, LinkKey> dstLinks = GossipLinkStore.createSynchronizedHashMultiMap();
    private final Map<LinkKey, Timestamp> removedLinks = new ConcurrentHashMap<LinkKey, Timestamp>();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceClockService deviceClockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    protected static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(DistributedStoreSerializers.STORE_COMMON).nextId(310).register(new Class[]{InternalLinkEvent.class}).register(new Class[]{InternalLinkRemovedEvent.class}).register(new Class[]{LinkAntiEntropyAdvertisement.class}).register(new Class[]{LinkFragmentId.class}).register(new Class[]{LinkInjectedEvent.class}).build();
        }
    };
    private ExecutorService executor;
    private ScheduledExecutorService backgroundExecutors;
    private final Function<LinkKey, Link> lookupLink = new LookupLink();

    @Activate
    public void activate() {
        this.executor = Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/link", (String)"fg-%d"));
        this.backgroundExecutors = Executors.newSingleThreadScheduledExecutor(Tools.minPriority((ThreadFactory)Tools.groupedThreads((String)"onos/link", (String)"bg-%d")));
        this.clusterCommunicator.addSubscriber(GossipLinkStoreMessageSubjects.LINK_UPDATE, (ClusterMessageHandler)new InternalLinkEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipLinkStoreMessageSubjects.LINK_REMOVED, (ClusterMessageHandler)new InternalLinkRemovedEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipLinkStoreMessageSubjects.LINK_ANTI_ENTROPY_ADVERTISEMENT, (ClusterMessageHandler)new InternalLinkAntiEntropyAdvertisementListener(), (ExecutorService)this.backgroundExecutors);
        this.clusterCommunicator.addSubscriber(GossipLinkStoreMessageSubjects.LINK_INJECTED, (ClusterMessageHandler)new LinkInjectedEventListener(), this.executor);
        long initialDelaySec = 5L;
        long periodSec = 5L;
        this.backgroundExecutors.scheduleAtFixedRate(new SendAdvertisementTask(), initialDelaySec, periodSec, TimeUnit.SECONDS);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdownNow();
        this.backgroundExecutors.shutdownNow();
        try {
            if (!this.backgroundExecutors.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.log.error("Timeout during executor shutdown");
            }
        }
        catch (InterruptedException e) {
            this.log.error("Error during executor shutdown", (Throwable)e);
        }
        this.linkDescs.clear();
        this.links.clear();
        this.srcLinks.clear();
        this.dstLinks.clear();
        this.log.info("Stopped");
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public Iterable<Link> getLinks() {
        return Collections.unmodifiableCollection(this.links.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Link> getDeviceEgressLinks(DeviceId deviceId) {
        SetMultimap<DeviceId, LinkKey> setMultimap = this.srcLinks;
        synchronized (setMultimap) {
            return FluentIterable.from((Iterable)this.srcLinks.get((Object)deviceId)).transform(this.lookupLink()).filter(Predicates.notNull()).toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Link> getDeviceIngressLinks(DeviceId deviceId) {
        SetMultimap<DeviceId, LinkKey> setMultimap = this.dstLinks;
        synchronized (setMultimap) {
            return FluentIterable.from((Iterable)this.dstLinks.get((Object)deviceId)).transform(this.lookupLink()).filter(Predicates.notNull()).toSet();
        }
    }

    public Link getLink(ConnectPoint src, ConnectPoint dst) {
        return (Link)this.links.get(LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Link> getEgressLinks(ConnectPoint src) {
        HashSet<Link> egress = new HashSet<Link>();
        SetMultimap<DeviceId, LinkKey> setMultimap = this.srcLinks;
        synchronized (setMultimap) {
            for (LinkKey linkKey : this.srcLinks.get((Object)src.deviceId())) {
                if (!linkKey.src().equals((Object)src)) continue;
                Link link = (Link)this.links.get(linkKey);
                if (link != null) {
                    egress.add(link);
                    continue;
                }
                this.log.debug("Egress link for {} was null, skipped", (Object)linkKey);
            }
        }
        return egress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Link> getIngressLinks(ConnectPoint dst) {
        HashSet<Link> ingress = new HashSet<Link>();
        SetMultimap<DeviceId, LinkKey> setMultimap = this.dstLinks;
        synchronized (setMultimap) {
            for (LinkKey linkKey : this.dstLinks.get((Object)dst.deviceId())) {
                if (!linkKey.dst().equals((Object)dst)) continue;
                Link link = (Link)this.links.get(linkKey);
                if (link != null) {
                    ingress.add(link);
                    continue;
                }
                this.log.debug("Ingress link for {} was null, skipped", (Object)linkKey);
            }
        }
        return ingress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkEvent createOrUpdateLink(ProviderId providerId, LinkDescription linkDescription) {
        DeviceId dstDeviceId = linkDescription.dst().deviceId();
        NodeId localNode = this.clusterService.getLocalNode().id();
        NodeId dstNode = this.mastershipService.getMasterFor(dstDeviceId);
        LinkEvent linkEvent = null;
        if (localNode.equals((Object)dstNode)) {
            Timestamped<LinkDescription> mergedDesc;
            Map<ProviderId, Timestamped<LinkDescription>> map;
            Timestamp newTimestamp = this.deviceClockService.getTimestamp(dstDeviceId);
            Timestamped<LinkDescription> deltaDesc = new Timestamped<LinkDescription>(linkDescription, newTimestamp);
            LinkKey key = LinkKey.linkKey((ConnectPoint)linkDescription.src(), (ConnectPoint)linkDescription.dst());
            Map<ProviderId, Timestamped<LinkDescription>> map2 = map = this.getOrCreateLinkDescriptions(key);
            synchronized (map2) {
                linkEvent = this.createOrUpdateLinkInternal(providerId, deltaDesc);
                mergedDesc = map.get(providerId);
            }
            if (linkEvent != null) {
                this.log.info("Notifying peers of a link update topology event from providerId: {}  between src: {} and dst: {}", new Object[]{providerId, linkDescription.src(), linkDescription.dst()});
                this.notifyPeers(new InternalLinkEvent(providerId, mergedDesc));
            }
        } else {
            if (dstNode == null) {
                return null;
            }
            LinkInjectedEvent linkInjectedEvent = new LinkInjectedEvent(providerId, linkDescription);
            ClusterMessage linkInjectedMessage = new ClusterMessage(localNode, GossipLinkStoreMessageSubjects.LINK_INJECTED, SERIALIZER.encode((Object)linkInjectedEvent));
            this.clusterCommunicator.unicast(linkInjectedMessage, dstNode);
        }
        return linkEvent;
    }

    public LinkEvent removeOrDownLink(ConnectPoint src, ConnectPoint dst) {
        Link link = this.getLink(src, dst);
        if (link == null) {
            return null;
        }
        if (link.isDurable()) {
            return link.state() == Link.State.INACTIVE ? null : this.updateLink(LinkKey.linkKey((ConnectPoint)link.src(), (ConnectPoint)link.dst()), link, (Link)new DefaultLink(link.providerId(), link.src(), link.dst(), link.type(), Link.State.INACTIVE, link.isDurable(), new Annotations[]{link.annotations()}));
        }
        return this.removeLink(src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkEvent createOrUpdateLinkInternal(ProviderId providerId, Timestamped<LinkDescription> linkDescription) {
        Map<ProviderId, Timestamped<LinkDescription>> descs;
        LinkKey key = LinkKey.linkKey((ConnectPoint)linkDescription.value().src(), (ConnectPoint)linkDescription.value().dst());
        Map<ProviderId, Timestamped<LinkDescription>> map = descs = this.getOrCreateLinkDescriptions(key);
        synchronized (map) {
            Timestamp linkRemovedTimestamp = this.removedLinks.get(key);
            if (linkRemovedTimestamp != null) {
                if (linkDescription.isNewerThan(linkRemovedTimestamp)) {
                    this.removedLinks.remove(key);
                } else {
                    this.log.trace("Link {} was already removed ignoring.", (Object)key);
                    return null;
                }
            }
            Link oldLink = (Link)this.links.get(key);
            this.createOrUpdateLinkDescription(descs, providerId, linkDescription);
            Link newLink = this.composeLink(descs);
            if (oldLink == null) {
                return this.createLink(key, newLink);
            }
            return this.updateLink(key, oldLink, newLink);
        }
    }

    private Timestamped<LinkDescription> createOrUpdateLinkDescription(Map<ProviderId, Timestamped<LinkDescription>> descs, ProviderId providerId, Timestamped<LinkDescription> linkDescription) {
        Timestamped<LinkDescription> existingLinkDescription = descs.get(providerId);
        if (existingLinkDescription != null && existingLinkDescription.isNewer(linkDescription)) {
            this.log.trace("local info is more up-to-date, ignoring {}.", linkDescription);
            return null;
        }
        Timestamped<LinkDescription> newLinkDescription = linkDescription;
        if (existingLinkDescription != null) {
            Link.Type newType = existingLinkDescription.value().type() == Link.Type.DIRECT ? Link.Type.DIRECT : linkDescription.value().type();
            SparseAnnotations merged = DefaultAnnotations.union((SparseAnnotations)existingLinkDescription.value().annotations(), (SparseAnnotations)linkDescription.value().annotations());
            newLinkDescription = new Timestamped<DefaultLinkDescription>(new DefaultLinkDescription(linkDescription.value().src(), linkDescription.value().dst(), newType, new SparseAnnotations[]{merged}), linkDescription.timestamp());
        }
        return descs.put(providerId, newLinkDescription);
    }

    private LinkEvent createLink(LinkKey key, Link newLink) {
        this.links.put(key, newLink);
        this.srcLinks.put((Object)newLink.src().deviceId(), (Object)key);
        this.dstLinks.put((Object)newLink.dst().deviceId(), (Object)key);
        return new LinkEvent(LinkEvent.Type.LINK_ADDED, newLink);
    }

    private LinkEvent updateLink(LinkKey key, Link oldLink, Link newLink) {
        if (oldLink.state() != newLink.state() || oldLink.type() == Link.Type.INDIRECT && newLink.type() == Link.Type.DIRECT || !AnnotationsUtil.isEqual((Annotations)oldLink.annotations(), (Annotations)newLink.annotations())) {
            this.links.put(key, newLink);
            this.srcLinks.put((Object)oldLink.src().deviceId(), (Object)key);
            this.dstLinks.put((Object)oldLink.dst().deviceId(), (Object)key);
            return new LinkEvent(LinkEvent.Type.LINK_UPDATED, newLink);
        }
        return null;
    }

    public LinkEvent removeLink(ConnectPoint src, ConnectPoint dst) {
        LinkKey key = LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        DeviceId dstDeviceId = dst.deviceId();
        Timestamp timestamp = null;
        try {
            timestamp = this.deviceClockService.getTimestamp(dstDeviceId);
        }
        catch (IllegalStateException e) {
            this.log.warn("Failed to remove link {}, was not the master", (Object)key);
            return null;
        }
        LinkEvent event = this.removeLinkInternal(key, timestamp);
        if (event != null) {
            this.log.info("Notifying peers of a link removed topology event for a link between src: {} and dst: {}", (Object)src, (Object)dst);
            this.notifyPeers(new InternalLinkRemovedEvent(key, timestamp));
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Timestamped<LinkDescription> getPrimaryDescription(Map<ProviderId, Timestamped<LinkDescription>> linkDescriptions) {
        Map<ProviderId, Timestamped<LinkDescription>> map = linkDescriptions;
        synchronized (map) {
            for (Map.Entry<ProviderId, Timestamped<LinkDescription>> e : linkDescriptions.entrySet()) {
                if (e.getKey().isAncillary()) continue;
                return e.getValue();
            }
        }
        return null;
    }

    private static boolean isMoreRecent(Timestamp timestamp, Timestamped<?> timestamped) {
        Preconditions.checkNotNull((Object)timestamp);
        if (timestamped == null) {
            return true;
        }
        return timestamp.compareTo((Object)timestamped.timestamp()) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkEvent removeLinkInternal(LinkKey key, Timestamp timestamp) {
        Map<ProviderId, Timestamped<LinkDescription>> linkDescriptions;
        Map<ProviderId, Timestamped<LinkDescription>> map = linkDescriptions = this.getOrCreateLinkDescriptions(key);
        synchronized (map) {
            if (linkDescriptions.isEmpty()) {
                this.removedLinks.put(key, timestamp);
                return null;
            }
            Timestamped<LinkDescription> prim = GossipLinkStore.getPrimaryDescription(linkDescriptions);
            if (!GossipLinkStore.isMoreRecent(timestamp, prim)) {
                return null;
            }
            this.removedLinks.put(key, timestamp);
            Link link = (Link)this.links.remove(key);
            linkDescriptions.clear();
            if (link != null) {
                this.srcLinks.remove((Object)link.src().deviceId(), (Object)key);
                this.dstLinks.remove((Object)link.dst().deviceId(), (Object)key);
                return new LinkEvent(LinkEvent.Type.LINK_REMOVED, link);
            }
            return null;
        }
    }

    private static <K, V> SetMultimap<K, V> createSynchronizedHashMultiMap() {
        return Multimaps.synchronizedSetMultimap((SetMultimap)Multimaps.newSetMultimap(new ConcurrentHashMap(), () -> Sets.newConcurrentHashSet()));
    }

    private static ProviderId pickBaseProviderId(Map<ProviderId, Timestamped<LinkDescription>> linkDescriptions) {
        ProviderId fallBackPrimary = null;
        for (Map.Entry<ProviderId, Timestamped<LinkDescription>> e : linkDescriptions.entrySet()) {
            if (!e.getKey().isAncillary()) {
                return e.getKey();
            }
            if (fallBackPrimary != null) continue;
            fallBackPrimary = e.getKey();
        }
        return fallBackPrimary;
    }

    private Link composeLink(Map<ProviderId, Timestamped<LinkDescription>> descs) {
        ProviderId baseProviderId = GossipLinkStore.pickBaseProviderId(descs);
        Timestamped<LinkDescription> base = descs.get(baseProviderId);
        ConnectPoint src = base.value().src();
        ConnectPoint dst = base.value().dst();
        Link.Type type = base.value().type();
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)base.value().annotations());
        for (Map.Entry<ProviderId, Timestamped<LinkDescription>> e : descs.entrySet()) {
            if (baseProviderId.equals((Object)e.getKey())) continue;
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)e.getValue().value().annotations());
        }
        boolean isDurable = Objects.equals(annotations.value("durable"), "true");
        return new DefaultLink(baseProviderId, src, dst, type, Link.State.ACTIVE, isDurable, new Annotations[]{annotations});
    }

    private Map<ProviderId, Timestamped<LinkDescription>> getOrCreateLinkDescriptions(LinkKey key) {
        HashMap<ProviderId, Timestamped<LinkDescription>> r = (HashMap<ProviderId, Timestamped<LinkDescription>>)this.linkDescs.get(key);
        if (r != null) {
            return r;
        }
        r = new HashMap<ProviderId, Timestamped<LinkDescription>>();
        Map concurrentlyAdded = this.linkDescs.putIfAbsent(key, r);
        if (concurrentlyAdded != null) {
            return concurrentlyAdded;
        }
        return r;
    }

    private Function<LinkKey, Link> lookupLink() {
        return this.lookupLink;
    }

    private void notifyDelegateIfNotNull(LinkEvent event) {
        if (event != null) {
            this.notifyDelegate((Event)event);
        }
    }

    private void broadcastMessage(MessageSubject subject, Object event) {
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), subject, SERIALIZER.encode(event));
        this.clusterCommunicator.broadcast(message);
    }

    private void unicastMessage(NodeId recipient, MessageSubject subject, Object event) throws IOException {
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), subject, SERIALIZER.encode(event));
        this.clusterCommunicator.unicast(message, recipient);
    }

    private void notifyPeers(InternalLinkEvent event) {
        this.broadcastMessage(GossipLinkStoreMessageSubjects.LINK_UPDATE, event);
    }

    private void notifyPeers(InternalLinkRemovedEvent event) {
        this.broadcastMessage(GossipLinkStoreMessageSubjects.LINK_REMOVED, event);
    }

    private void notifyPeer(NodeId peer, InternalLinkEvent event) {
        try {
            this.unicastMessage(peer, GossipLinkStoreMessageSubjects.LINK_UPDATE, event);
        }
        catch (IOException e) {
            this.log.debug("Failed to notify peer {} with message {}", (Object)peer, (Object)event);
        }
    }

    private void notifyPeer(NodeId peer, InternalLinkRemovedEvent event) {
        try {
            this.unicastMessage(peer, GossipLinkStoreMessageSubjects.LINK_REMOVED, event);
        }
        catch (IOException e) {
            this.log.debug("Failed to notify peer {} with message {}", (Object)peer, (Object)event);
        }
    }

    private LinkAntiEntropyAdvertisement createAdvertisement() {
        NodeId self = this.clusterService.getLocalNode().id();
        HashMap<LinkFragmentId, Timestamp> linkTimestamps = new HashMap<LinkFragmentId, Timestamp>(this.linkDescs.size());
        HashMap<LinkKey, Timestamp> linkTombstones = new HashMap<LinkKey, Timestamp>(this.removedLinks.size());
        this.linkDescs.forEach((linkKey, linkDesc) -> {
            Map map2 = linkDesc;
            synchronized (map2) {
                for (Map.Entry e : linkDesc.entrySet()) {
                    linkTimestamps.put(new LinkFragmentId((LinkKey)linkKey, (ProviderId)e.getKey()), ((Timestamped)e.getValue()).timestamp());
                }
            }
        });
        linkTombstones.putAll(this.removedLinks);
        return new LinkAntiEntropyAdvertisement(self, linkTimestamps, linkTombstones);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAntiEntropyAdvertisement(LinkAntiEntropyAdvertisement ad) {
        LinkKey key;
        NodeId sender = ad.sender();
        boolean localOutdated = false;
        for (Map.Entry entry : this.linkDescs.entrySet()) {
            Map link;
            key = (LinkKey)entry.getKey();
            Map map = link = (Map)entry.getValue();
            synchronized (map) {
                Timestamp localLatest = this.removedLinks.get(key);
                for (Map.Entry p : link.entrySet()) {
                    ProviderId providerId = (ProviderId)p.getKey();
                    Timestamped pDesc = (Timestamped)p.getValue();
                    LinkFragmentId fragId = new LinkFragmentId(key, providerId);
                    Timestamp remoteTimestamp = ad.linkTimestamps().get(fragId);
                    if (remoteTimestamp == null) {
                        remoteTimestamp = ad.linkTombstones().get(key);
                    }
                    if (remoteTimestamp == null || pDesc.isNewerThan(remoteTimestamp)) {
                        this.notifyPeer(sender, new InternalLinkEvent(providerId, pDesc));
                    } else {
                        Timestamp remoteLive = ad.linkTimestamps().get(fragId);
                        if (remoteLive != null && remoteLive.compareTo((Object)pDesc.timestamp()) > 0) {
                            localOutdated = true;
                        }
                    }
                    if (localLatest != null && !pDesc.isNewerThan(localLatest)) continue;
                    localLatest = pDesc.timestamp();
                }
                Timestamp remoteRemove = ad.linkTombstones().get(key);
                if (remoteRemove != null && localLatest != null && localLatest.compareTo((Object)remoteRemove) < 0) {
                    this.notifyDelegateIfNotNull(this.removeLinkInternal(key, remoteRemove));
                }
            }
        }
        for (Map.Entry<Object, Object> entry : ad.linkTombstones().entrySet()) {
            key = (LinkKey)entry.getKey();
            Timestamp remoteRemove = (Timestamp)entry.getValue();
            this.notifyDelegateIfNotNull(this.removeLinkInternal(key, remoteRemove));
        }
        if (localOutdated) {
            try {
                this.unicastMessage(sender, GossipLinkStoreMessageSubjects.LINK_ANTI_ENTROPY_ADVERTISEMENT, this.createAdvertisement());
            }
            catch (IOException e) {
                this.log.debug("Failed to send back active advertisement");
            }
        }
    }

    protected void bindDeviceClockService(DeviceClockService deviceClockService) {
        this.deviceClockService = deviceClockService;
    }

    protected void unbindDeviceClockService(DeviceClockService deviceClockService) {
        if (this.deviceClockService == deviceClockService) {
            this.deviceClockService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    private final class LinkInjectedEventListener
    implements ClusterMessageHandler {
        private LinkInjectedEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipLinkStore.this.log.trace("Received injected link event from peer: {}", (Object)message.sender());
            LinkInjectedEvent linkInjectedEvent = (LinkInjectedEvent)SERIALIZER.decode(message.payload());
            ProviderId providerId = linkInjectedEvent.providerId();
            LinkDescription linkDescription = linkInjectedEvent.linkDescription();
            DeviceId deviceId = linkDescription.dst().deviceId();
            if (!GossipLinkStore.this.deviceClockService.isTimestampAvailable(deviceId)) {
                GossipLinkStore.this.log.warn("Not ready to accept update. Dropping {}", (Object)linkDescription);
                return;
            }
            try {
                GossipLinkStore.this.createOrUpdateLink(providerId, linkDescription);
            }
            catch (Exception e) {
                GossipLinkStore.this.log.warn("Exception thrown while handling link injected event", (Throwable)e);
            }
        }
    }

    private final class InternalLinkAntiEntropyAdvertisementListener
    implements ClusterMessageHandler {
        private InternalLinkAntiEntropyAdvertisementListener() {
        }

        public void handle(ClusterMessage message) {
            GossipLinkStore.this.log.trace("Received Link Anti-Entropy advertisement from peer: {}", (Object)message.sender());
            LinkAntiEntropyAdvertisement advertisement = (LinkAntiEntropyAdvertisement)SERIALIZER.decode(message.payload());
            try {
                GossipLinkStore.this.handleAntiEntropyAdvertisement(advertisement);
            }
            catch (Exception e) {
                GossipLinkStore.this.log.warn("Exception thrown while handling Link advertisements", (Throwable)e);
                throw e;
            }
        }
    }

    private final class InternalLinkRemovedEventListener
    implements ClusterMessageHandler {
        private InternalLinkRemovedEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipLinkStore.this.log.trace("Received link removed event from peer: {}", (Object)message.sender());
            InternalLinkRemovedEvent event = (InternalLinkRemovedEvent)SERIALIZER.decode(message.payload());
            LinkKey linkKey = event.linkKey();
            Timestamp timestamp = event.timestamp();
            try {
                GossipLinkStore.this.notifyDelegateIfNotNull(GossipLinkStore.this.removeLinkInternal(linkKey, timestamp));
            }
            catch (Exception e) {
                GossipLinkStore.this.log.warn("Exception thrown handling link removed", (Throwable)e);
            }
        }
    }

    private final class InternalLinkEventListener
    implements ClusterMessageHandler {
        private InternalLinkEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipLinkStore.this.log.trace("Received link event from peer: {}", (Object)message.sender());
            InternalLinkEvent event = (InternalLinkEvent)SERIALIZER.decode(message.payload());
            ProviderId providerId = event.providerId();
            Timestamped<LinkDescription> linkDescription = event.linkDescription();
            try {
                GossipLinkStore.this.notifyDelegateIfNotNull(GossipLinkStore.this.createOrUpdateLinkInternal(providerId, linkDescription));
            }
            catch (Exception e) {
                GossipLinkStore.this.log.warn("Exception thrown handling link event", (Throwable)e);
            }
        }
    }

    private final class SendAdvertisementTask
    implements Runnable {
        private SendAdvertisementTask() {
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                GossipLinkStore.this.log.debug("Interrupted, quitting");
                return;
            }
            try {
                int idx;
                NodeId peer;
                NodeId self = GossipLinkStore.this.clusterService.getLocalNode().id();
                Set nodes = GossipLinkStore.this.clusterService.getNodes();
                ImmutableList nodeIds = FluentIterable.from((Iterable)nodes).transform((Function)ControllerNodeToNodeId.toNodeId()).toList();
                if (nodeIds.size() == 1 && ((NodeId)nodeIds.get(0)).equals((Object)self)) {
                    GossipLinkStore.this.log.trace("No other peers in the cluster.");
                    return;
                }
                while ((peer = (NodeId)nodeIds.get(idx = RandomUtils.nextInt((int)0, (int)nodeIds.size()))).equals((Object)self)) {
                }
                LinkAntiEntropyAdvertisement ad = GossipLinkStore.this.createAdvertisement();
                if (Thread.currentThread().isInterrupted()) {
                    GossipLinkStore.this.log.debug("Interrupted, quitting");
                    return;
                }
                try {
                    GossipLinkStore.this.unicastMessage(peer, GossipLinkStoreMessageSubjects.LINK_ANTI_ENTROPY_ADVERTISEMENT, ad);
                }
                catch (IOException e) {
                    GossipLinkStore.this.log.debug("Failed to send anti-entropy advertisement to {}", (Object)peer);
                    return;
                }
            }
            catch (Exception e) {
                GossipLinkStore.this.log.error("Exception thrown while sending advertisement", (Throwable)e);
            }
        }
    }

    private final class LookupLink
    implements Function<LinkKey, Link> {
        private LookupLink() {
        }

        public Link apply(LinkKey input) {
            if (input == null) {
                return null;
            }
            return (Link)GossipLinkStore.this.links.get(input);
        }
    }
}

