/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.mastership.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipStore;
import org.onosproject.mastership.MastershipStoreDelegate;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
@Service
public class ConsistentDeviceMastershipStore
extends AbstractStore<MastershipEvent, MastershipStoreDelegate>
implements MastershipStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    private NodeId localNodeId;
    private final Set<DeviceId> connectedDevices = Sets.newHashSet();
    private static final MessageSubject ROLE_QUERY_SUBJECT = new MessageSubject("mastership-store-device-role-query");
    private static final MessageSubject ROLE_RELINQUISH_SUBJECT = new MessageSubject("mastership-store-device-role-relinquish");
    private static final Pattern DEVICE_MASTERSHIP_TOPIC_PATTERN = Pattern.compile("/devices/(.*)/mastership");
    private static final long PEER_REQUEST_TIMEOUT_MS = 5000L;
    private ExecutorService messageHandlingExecutor;
    private final LeadershipEventListener leadershipEventListener = new InternalDeviceMastershipEventListener();
    private static final String NODE_ID_NULL = "Node ID cannot be null";
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    public static final StoreSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MastershipRole.class}).register(new Class[]{MastershipEvent.class}).build();
        }
    };

    @Activate
    public void activate() {
        this.messageHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/device/mastership", (String)"message-handler"));
        this.clusterCommunicator.addSubscriber(ROLE_QUERY_SUBJECT, (ClusterMessageHandler)new RoleQueryHandler(), this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(ROLE_RELINQUISH_SUBJECT, (ClusterMessageHandler)new RoleRelinquishHandler(), this.messageHandlingExecutor);
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.addListener(this.leadershipEventListener);
        this.log.info("Started.");
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(ROLE_QUERY_SUBJECT);
        this.clusterCommunicator.removeSubscriber(ROLE_RELINQUISH_SUBJECT);
        this.messageHandlingExecutor.shutdown();
        this.leadershipService.removeListener(this.leadershipEventListener);
        this.log.info("Stoppped.");
    }

    public MastershipRole requestRole(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        if (this.connectedDevices.add(deviceId)) {
            this.leadershipService.runForLeadership(leadershipTopic);
            return MastershipRole.STANDBY;
        }
        Leadership leadership = this.leadershipService.getLeadership(leadershipTopic);
        if (leadership != null && leadership.leader().equals((Object)this.localNodeId)) {
            return MastershipRole.MASTER;
        }
        return MastershipRole.STANDBY;
    }

    public MastershipRole getRole(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        Leadership leadership = this.leadershipService.getLeadership(leadershipTopic);
        if (leadership != null && nodeId.equals((Object)leadership.leader())) {
            return MastershipRole.MASTER;
        }
        if (this.localNodeId.equals((Object)nodeId)) {
            if (this.connectedDevices.contains(deviceId)) {
                return MastershipRole.STANDBY;
            }
            return MastershipRole.NONE;
        }
        try {
            MastershipRole role = (MastershipRole)this.complete((Future<byte[]>)this.clusterCommunicator.sendAndReceive(new ClusterMessage(this.localNodeId, ROLE_QUERY_SUBJECT, SERIALIZER.encode((Object)deviceId)), nodeId));
            return role == null ? MastershipRole.NONE : role;
        }
        catch (IOException e) {
            this.log.warn("Failed to query {} for {}'s role. Defaulting to NONE", new Object[]{nodeId, deviceId, e});
            return MastershipRole.NONE;
        }
    }

    public NodeId getMaster(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        Leadership leadership = this.leadershipService.getLeadership(leadershipTopic);
        return leadership != null ? leadership.leader() : null;
    }

    public RoleInfo getNodes(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        HashMap roles = Maps.newHashMap();
        ((Stream)this.clusterService.getNodes().stream().parallel()).forEach(node -> roles.put(node.id(), this.getRole(node.id(), deviceId)));
        NodeId master = null;
        LinkedList standbys = Lists.newLinkedList();
        for (Map.Entry entry : roles.entrySet()) {
            if (entry.getValue() == MastershipRole.MASTER) {
                master = (NodeId)entry.getKey();
                continue;
            }
            if (entry.getValue() != MastershipRole.STANDBY) continue;
            standbys.add(entry.getKey());
        }
        return new RoleInfo(master, (List)standbys);
    }

    public Set<DeviceId> getDevices(NodeId nodeId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        return this.leadershipService.ownedTopics(nodeId).stream().filter(this::isDeviceMastershipTopic).map(this::extractDeviceIdFromTopic).collect(Collectors.toSet());
    }

    public MastershipEvent setMaster(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        throw new UnsupportedOperationException("This operation is not supported in " + ((Object)((Object)this)).getClass().getName());
    }

    public MastershipTerm getTermFor(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        Leadership leadership = this.leadershipService.getLeadership(leadershipTopic);
        return leadership != null ? MastershipTerm.of((NodeId)leadership.leader(), (long)leadership.epoch()) : null;
    }

    public MastershipEvent setStandby(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        throw new UnsupportedOperationException("This operation is not supported in " + ((Object)((Object)this)).getClass().getName());
    }

    public MastershipEvent relinquishRole(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        if (!nodeId.equals((Object)this.localNodeId)) {
            this.log.debug("Forwarding request to relinquish role for device {} to {}", (Object)deviceId, (Object)nodeId);
            try {
                return (MastershipEvent)this.complete((Future<byte[]>)this.clusterCommunicator.sendAndReceive(new ClusterMessage(this.localNodeId, ROLE_RELINQUISH_SUBJECT, SERIALIZER.encode((Object)deviceId)), nodeId));
            }
            catch (IOException e) {
                this.log.warn("Failed to send a request to relinquish role for {} to {}", new Object[]{deviceId, nodeId, e});
                return null;
            }
        }
        if (!this.connectedDevices.contains(deviceId)) {
            return null;
        }
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        Leadership currentLeadership = this.leadershipService.getLeadership(leadershipTopic);
        MastershipEvent.Type eventType = null;
        eventType = currentLeadership != null && currentLeadership.leader().equals((Object)this.localNodeId) ? MastershipEvent.Type.MASTER_CHANGED : MastershipEvent.Type.BACKUPS_CHANGED;
        this.connectedDevices.remove(deviceId);
        this.leadershipService.withdraw(leadershipTopic);
        return new MastershipEvent(eventType, deviceId, this.getNodes(deviceId));
    }

    public void relinquishAllRole(NodeId nodeId) {
    }

    private String createDeviceMastershipTopic(DeviceId deviceId) {
        return "/devices/" + deviceId.toString() + "/mastership";
    }

    private DeviceId extractDeviceIdFromTopic(String topic) {
        Matcher m = DEVICE_MASTERSHIP_TOPIC_PATTERN.matcher(topic);
        if (m.matches()) {
            return DeviceId.deviceId((String)m.group(1));
        }
        throw new IllegalArgumentException("Invalid device mastership topic: " + topic);
    }

    private boolean isDeviceMastershipTopic(String topic) {
        Matcher m = DEVICE_MASTERSHIP_TOPIC_PATTERN.matcher(topic);
        return m.matches();
    }

    private <T> T complete(Future<byte[]> future) {
        try {
            return (T)SERIALIZER.decode(future.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error("Interrupted while waiting for operation to complete.", (Throwable)e);
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            this.log.error("Failed remote operation", (Throwable)e);
            return null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    private class InternalDeviceMastershipEventListener
    implements LeadershipEventListener {
        private InternalDeviceMastershipEventListener() {
        }

        public void event(LeadershipEvent event) {
            Leadership leadership = (Leadership)event.subject();
            if (!ConsistentDeviceMastershipStore.this.isDeviceMastershipTopic(leadership.topic())) {
                return;
            }
            NodeId nodeId = leadership.leader();
            DeviceId deviceId = ConsistentDeviceMastershipStore.this.extractDeviceIdFromTopic(leadership.topic());
            if (Objects.equal((Object)nodeId, (Object)ConsistentDeviceMastershipStore.this.localNodeId) && ConsistentDeviceMastershipStore.this.connectedDevices.contains(deviceId)) {
                switch ((LeadershipEvent.Type)event.type()) {
                    case LEADER_ELECTED: {
                        ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, ConsistentDeviceMastershipStore.this.getNodes(deviceId)));
                        break;
                    }
                    case LEADER_REELECTED: {
                        throw new IllegalStateException("Unexpected event type");
                    }
                    case LEADER_BOOTED: {
                        ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, ConsistentDeviceMastershipStore.this.getNodes(deviceId)));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    private class RoleRelinquishHandler
    implements ClusterMessageHandler {
        private RoleRelinquishHandler() {
        }

        public void handle(ClusterMessage message) {
            DeviceId deviceId = (DeviceId)SERIALIZER.decode(message.payload());
            try {
                message.respond(SERIALIZER.encode((Object)ConsistentDeviceMastershipStore.this.relinquishRole(ConsistentDeviceMastershipStore.this.localNodeId, deviceId)));
            }
            catch (IOException e) {
                ConsistentDeviceMastershipStore.this.log.error("Failed to relinquish role.", (Throwable)e);
            }
        }
    }

    private class RoleQueryHandler
    implements ClusterMessageHandler {
        private RoleQueryHandler() {
        }

        public void handle(ClusterMessage message) {
            DeviceId deviceId = (DeviceId)SERIALIZER.decode(message.payload());
            try {
                message.respond(SERIALIZER.encode((Object)ConsistentDeviceMastershipStore.this.getRole(ConsistentDeviceMastershipStore.this.localNodeId, deviceId)));
            }
            catch (IOException e) {
                ConsistentDeviceMastershipStore.this.log.error("Failed to responsd to role query", (Throwable)e);
            }
        }
    }
}

