/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.PositionalParameterStringFormatter;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.resource.Bandwidth;
import org.onosproject.net.resource.BandwidthResourceAllocation;
import org.onosproject.net.resource.Lambda;
import org.onosproject.net.resource.LambdaResourceAllocation;
import org.onosproject.net.resource.LinkResourceAllocations;
import org.onosproject.net.resource.LinkResourceEvent;
import org.onosproject.net.resource.LinkResourceStore;
import org.onosproject.net.resource.MplsLabel;
import org.onosproject.net.resource.MplsLabelResourceAllocation;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceAllocationException;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.hz.AbstractHazelcastStore;
import org.onosproject.store.hz.STxMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class HazelcastLinkResourceStore
extends AbstractHazelcastStore<LinkResourceEvent, StoreDelegate<LinkResourceEvent>>
implements LinkResourceStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Bandwidth DEFAULT_BANDWIDTH = Bandwidth.mbps((double)1000.0);
    private static final Bandwidth EMPTY_BW = Bandwidth.bps((double)0.0);
    private static final String LINK_RESOURCE_ALLOCATIONS = "LinkResourceAllocations";
    private static final String INTENT_ALLOCATIONS = "IntentAllocations";
    private static int maxAllocateRetries = 5;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    private String bandwidthAnnotation = "bandwidth";
    private String wavesAnnotation = "optical.waves";
    private int maxMplsLabel = 1048575;

    @Override
    @Activate
    public void activate() {
        super.activate();
        Config config = this.theInstance.getConfig();
        MapConfig linkCfg = config.getMapConfig(LINK_RESOURCE_ALLOCATIONS);
        linkCfg.setAsyncBackupCount(6 - linkCfg.getBackupCount());
        MapConfig intentCfg = config.getMapConfig(INTENT_ALLOCATIONS);
        intentCfg.setAsyncBackupCount(6 - intentCfg.getBackupCount());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    private STxMap<IntentId, LinkResourceAllocations> getIntentAllocs(TransactionContext tx) {
        TransactionalMap raw = tx.getMap(INTENT_ALLOCATIONS);
        return new STxMap<IntentId, LinkResourceAllocations>((TransactionalMap<byte[], byte[]>)raw, this.serializer);
    }

    private STxMap<LinkKey, List<LinkResourceAllocations>> getLinkAllocs(TransactionContext tx) {
        TransactionalMap raw = tx.getMap(LINK_RESOURCE_ALLOCATIONS);
        return new STxMap<LinkKey, List<LinkResourceAllocations>>((TransactionalMap<byte[], byte[]>)raw, this.serializer);
    }

    private Set<? extends ResourceAllocation> getResourceCapacity(ResourceType type, Link link) {
        if (type == ResourceType.BANDWIDTH) {
            return ImmutableSet.of((Object)this.getBandwidthResourceCapacity(link));
        }
        if (type == ResourceType.LAMBDA) {
            return this.getLambdaResourceCapacity(link);
        }
        if (type == ResourceType.MPLS_LABEL) {
            return this.getMplsResourceCapacity();
        }
        return null;
    }

    private Set<LambdaResourceAllocation> getLambdaResourceCapacity(Link link) {
        HashSet<LambdaResourceAllocation> allocations = new HashSet<LambdaResourceAllocation>();
        try {
            int waves = Integer.parseInt(link.annotations().value(this.wavesAnnotation));
            for (int i = 1; i <= waves; ++i) {
                allocations.add(new LambdaResourceAllocation(Lambda.valueOf((int)i)));
            }
        }
        catch (NumberFormatException e) {
            this.log.debug("No {} annotation on link %s", (Object)this.wavesAnnotation, (Object)link);
        }
        return allocations;
    }

    private BandwidthResourceAllocation getBandwidthResourceCapacity(Link link) {
        Bandwidth bandwidth = null;
        String strBw = link.annotations().value(this.bandwidthAnnotation);
        if (strBw != null) {
            try {
                bandwidth = Bandwidth.mbps((double)Double.parseDouble(strBw));
            }
            catch (NumberFormatException e) {
                bandwidth = null;
            }
        }
        if (bandwidth == null) {
            bandwidth = DEFAULT_BANDWIDTH;
        }
        return new BandwidthResourceAllocation(bandwidth);
    }

    private Set<MplsLabelResourceAllocation> getMplsResourceCapacity() {
        HashSet<MplsLabelResourceAllocation> allocations = new HashSet<MplsLabelResourceAllocation>();
        for (int i = 16; i <= this.maxMplsLabel; ++i) {
            allocations.add(new MplsLabelResourceAllocation(MplsLabel.valueOf((int)i)));
        }
        return allocations;
    }

    private Map<ResourceType, Set<? extends ResourceAllocation>> getResourceCapacity(Link link) {
        HashMap<ResourceType, Set<? extends ResourceAllocation>> caps = new HashMap<ResourceType, Set<? extends ResourceAllocation>>();
        for (ResourceType type : ResourceType.values()) {
            Set<? extends ResourceAllocation> cap = this.getResourceCapacity(type, link);
            if (cap == null) continue;
            caps.put(type, cap);
        }
        return caps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourceAllocation> getFreeResources(Link link) {
        TransactionOptions opt = new TransactionOptions();
        opt.setTransactionType(TransactionOptions.TransactionType.LOCAL);
        TransactionContext tx = this.theInstance.newTransactionContext(opt);
        tx.beginTransaction();
        try {
            Map<ResourceType, Set<? extends ResourceAllocation>> freeResources = this.getFreeResourcesEx(tx, link);
            HashSet<? extends ResourceAllocation> allFree = new HashSet<ResourceAllocation>();
            for (Set<? extends ResourceAllocation> r : freeResources.values()) {
                allFree.addAll(r);
            }
            HashSet<? extends ResourceAllocation> hashSet = allFree;
            return hashSet;
        }
        finally {
            tx.rollbackTransaction();
        }
    }

    private Map<ResourceType, Set<? extends ResourceAllocation>> getFreeResourcesEx(TransactionContext tx, Link link) {
        Preconditions.checkNotNull((Object)link);
        HashMap<ResourceType, Set<? extends ResourceAllocation>> free = new HashMap<ResourceType, Set<? extends ResourceAllocation>>();
        Map<ResourceType, Set<? extends ResourceAllocation>> caps = this.getResourceCapacity(link);
        Iterable<LinkResourceAllocations> allocations = this.getAllocations(tx, link);
        block5: for (ResourceType type : ResourceType.values()) {
            switch (type) {
                case BANDWIDTH: {
                    HashSet bw = caps.get(ResourceType.BANDWIDTH);
                    if (bw == null || bw.isEmpty()) {
                        bw = Sets.newHashSet((Object[])new BandwidthResourceAllocation[]{new BandwidthResourceAllocation(EMPTY_BW)});
                    }
                    BandwidthResourceAllocation cap = (BandwidthResourceAllocation)bw.iterator().next();
                    double freeBw = cap.bandwidth().toDouble();
                    for (LinkResourceAllocations alloc : allocations) {
                        Set types = alloc.getResourceAllocation(link);
                        for (ResourceAllocation a : types) {
                            if (!(a instanceof BandwidthResourceAllocation)) continue;
                            BandwidthResourceAllocation bwA = (BandwidthResourceAllocation)a;
                            freeBw -= bwA.bandwidth().toDouble();
                        }
                    }
                    free.put(type, Sets.newHashSet((Object[])new BandwidthResourceAllocation[]{new BandwidthResourceAllocation(Bandwidth.bps((double)freeBw))}));
                    continue block5;
                }
                case LAMBDA: {
                    Set types;
                    Set<? extends ResourceAllocation> lmd = caps.get(type);
                    if (lmd == null || lmd.isEmpty()) continue block5;
                    HashSet<LambdaResourceAllocation> freeL = new HashSet<LambdaResourceAllocation>();
                    for (ResourceAllocation resourceAllocation : lmd) {
                        if (!(resourceAllocation instanceof LambdaResourceAllocation)) continue;
                        freeL.add((LambdaResourceAllocation)resourceAllocation);
                    }
                    for (LinkResourceAllocations linkResourceAllocations : allocations) {
                        types = linkResourceAllocations.getResourceAllocation(link);
                        for (ResourceAllocation a : types) {
                            if (!(a instanceof LambdaResourceAllocation)) continue;
                            freeL.remove(a);
                        }
                    }
                    free.put(type, freeL);
                    continue block5;
                }
                case MPLS_LABEL: {
                    Set types;
                    Set<? extends ResourceAllocation> mpls = caps.get(type);
                    if (mpls == null || mpls.isEmpty()) continue block5;
                    HashSet<MplsLabelResourceAllocation> freeLabel = new HashSet<MplsLabelResourceAllocation>();
                    for (ResourceAllocation resourceAllocation : mpls) {
                        if (!(resourceAllocation instanceof MplsLabelResourceAllocation)) continue;
                        freeLabel.add((MplsLabelResourceAllocation)resourceAllocation);
                    }
                    for (LinkResourceAllocations linkResourceAllocations : allocations) {
                        types = linkResourceAllocations.getResourceAllocation(link);
                        for (ResourceAllocation a : types) {
                            if (!(a instanceof MplsLabelResourceAllocation)) continue;
                            freeLabel.remove(a);
                        }
                    }
                    free.put(type, freeLabel);
                    continue block5;
                }
            }
        }
        return free;
    }

    public void allocateResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        for (int i = 0; i < maxAllocateRetries; ++i) {
            TransactionContext tx = this.theInstance.newTransactionContext();
            tx.beginTransaction();
            try {
                STxMap<IntentId, LinkResourceAllocations> intentAllocs = this.getIntentAllocs(tx);
                intentAllocs.put(allocations.intendId(), allocations);
                for (Link link : allocations.links()) {
                    this.allocateLinkResource(tx, link, allocations);
                }
                tx.commitTransaction();
                return;
            }
            catch (TransactionException e) {
                this.log.debug("Failed to commit allocations for {}. [retry={}]", (Object)allocations.intendId(), (Object)i);
                this.log.trace(" details {} ", (Object)allocations, (Object)e);
                continue;
            }
            catch (Exception e) {
                this.log.error("Exception thrown, rolling back", (Throwable)e);
                tx.rollbackTransaction();
                throw e;
            }
        }
    }

    private void allocateLinkResource(TransactionContext tx, Link link, LinkResourceAllocations allocations) {
        ArrayList<LinkResourceAllocations> after;
        Set reqs = allocations.getResourceAllocation(link);
        Map<ResourceType, Set<? extends ResourceAllocation>> available = this.getFreeResourcesEx(tx, link);
        for (ResourceAllocation req : reqs) {
            Set<? extends ResourceAllocation> avail = available.get(req.type());
            if (req instanceof BandwidthResourceAllocation) {
                if (avail.isEmpty()) {
                    Preconditions.checkState((!avail.isEmpty() ? 1 : 0) != 0, (String)"There's no Bandwidth resource on %s?", (Object[])new Object[]{link});
                }
                BandwidthResourceAllocation bw = (BandwidthResourceAllocation)avail.iterator().next();
                double bwLeft = bw.bandwidth().toDouble();
                BandwidthResourceAllocation bwReq = (BandwidthResourceAllocation)req;
                if (!((bwLeft -= bwReq.bandwidth().toDouble()) < 0.0)) continue;
                throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate bandwidth for link {}  requested amount is {} current allocation is {}", (Object[])new Object[]{link, bwReq.bandwidth().toDouble(), bw}));
            }
            if (req instanceof LambdaResourceAllocation) {
                LambdaResourceAllocation lambdaAllocation = (LambdaResourceAllocation)req;
                if (avail.contains(req)) continue;
                throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate lambda for link {} lambda is {}", (Object[])new Object[]{link, lambdaAllocation.lambda().toInt()}));
            }
            if (!(req instanceof MplsLabelResourceAllocation)) continue;
            MplsLabelResourceAllocation mplsAllocation = (MplsLabelResourceAllocation)req;
            if (avail.contains(req)) continue;
            throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate MPLS label for link {} MPLS label is {}", (Object[])new Object[]{link, mplsAllocation.mplsLabel().toString()}));
        }
        LinkKey linkKey = LinkKey.linkKey((Link)link);
        STxMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
        List before = linkAllocs.get(linkKey);
        if (before == null) {
            after = new ArrayList<LinkResourceAllocations>();
            after.add(allocations);
            before = linkAllocs.putIfAbsent(linkKey, after);
            if (before != null) {
                throw new TransactionException("Concurrent Allocation, retry");
            }
        } else {
            after = new ArrayList(before.size() + 1);
            after.addAll(before);
            after.add(allocations);
            linkAllocs.replace(linkKey, before, after);
        }
    }

    public LinkResourceEvent releaseResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        IntentId intendId = allocations.intendId();
        Collection links = allocations.links();
        boolean success = false;
        do {
            TransactionContext tx = this.theInstance.newTransactionContext();
            tx.beginTransaction();
            try {
                STxMap<IntentId, LinkResourceAllocations> intentAllocs = this.getIntentAllocs(tx);
                intentAllocs.remove(intendId);
                STxMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
                for (Link link : links) {
                    LinkKey linkId = LinkKey.linkKey((Link)link);
                    List<LinkResourceAllocations> before = linkAllocs.get(linkId);
                    if (before == null || before.isEmpty()) {
                        this.log.warn("There was no resource left to release on {}", (Object)linkId);
                        continue;
                    }
                    ArrayList<LinkResourceAllocations> after = new ArrayList<LinkResourceAllocations>(before);
                    after.remove(allocations);
                    linkAllocs.replace(linkId, before, after);
                }
                tx.commitTransaction();
                success = true;
            }
            catch (TransactionException e) {
                this.log.debug("Transaction failed, retrying");
            }
            catch (Exception e) {
                this.log.error("Exception thrown during releaseResource {}", (Object)allocations, (Object)e);
                tx.rollbackTransaction();
                throw e;
            }
        } while (!success);
        ImmutableList releasedResources = ImmutableList.of((Object)allocations);
        return new LinkResourceEvent(LinkResourceEvent.Type.ADDITIONAL_RESOURCES_AVAILABLE, (Collection)releasedResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkResourceAllocations getAllocations(IntentId intentId) {
        Preconditions.checkNotNull((Object)intentId);
        TransactionOptions opt = new TransactionOptions();
        opt.setTransactionType(TransactionOptions.TransactionType.LOCAL);
        TransactionContext tx = this.theInstance.newTransactionContext(opt);
        tx.beginTransaction();
        try {
            STxMap<IntentId, LinkResourceAllocations> intentAllocs = this.getIntentAllocs(tx);
            LinkResourceAllocations linkResourceAllocations = intentAllocs.get(intentId);
            return linkResourceAllocations;
        }
        finally {
            tx.rollbackTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LinkResourceAllocations> getAllocations(Link link) {
        Preconditions.checkNotNull((Object)link);
        LinkKey key = LinkKey.linkKey((Link)link);
        TransactionOptions opt = new TransactionOptions();
        opt.setTransactionType(TransactionOptions.TransactionType.LOCAL);
        TransactionContext tx = this.theInstance.newTransactionContext(opt);
        tx.beginTransaction();
        List res = null;
        try {
            STxMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
            res = linkAllocs.get(key);
        }
        finally {
            tx.rollbackTransaction();
        }
        if (res == null) {
            TransactionContext tx2 = this.theInstance.newTransactionContext();
            tx2.beginTransaction();
            try {
                res = this.getLinkAllocs(tx2).putIfAbsent(key, new ArrayList());
                tx2.commitTransaction();
                if (res == null) {
                    return Collections.emptyList();
                }
                return res;
            }
            catch (TransactionException e) {
                return this.getAllocations(link);
            }
            catch (Exception e) {
                tx.rollbackTransaction();
            }
        }
        return res;
    }

    private Iterable<LinkResourceAllocations> getAllocations(TransactionContext tx, Link link) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)link);
        LinkKey key = LinkKey.linkKey((Link)link);
        STxMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
        List res = null;
        res = linkAllocs.get(key);
        if (res == null) {
            res = linkAllocs.putIfAbsent(key, new ArrayList());
            if (res == null) {
                return Collections.emptyList();
            }
            return res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<LinkResourceAllocations> getAllocations() {
        TransactionContext tx = this.theInstance.newTransactionContext();
        tx.beginTransaction();
        try {
            STxMap<IntentId, LinkResourceAllocations> intentAllocs = this.getIntentAllocs(tx);
            Collection<LinkResourceAllocations> collection = intentAllocs.values();
            return collection;
        }
        finally {
            tx.rollbackTransaction();
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }
}

