/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import com.google.common.base.MoreObjects;
import org.onlab.util.ByteArraySizeHashPrinter;
import org.onosproject.core.HybridLogicalTime;
import org.onosproject.store.cluster.messaging.Endpoint;

public final class InternalMessage {
    private final int preamble;
    private final HybridLogicalTime time;
    private final long id;
    private final Endpoint sender;
    private final String type;
    private final byte[] payload;
    private final Status status;

    public InternalMessage(int preamble, HybridLogicalTime time, long id, Endpoint sender, String type, byte[] payload) {
        this(preamble, time, id, sender, type, payload, null);
    }

    public InternalMessage(int preamble, HybridLogicalTime time, long id, Endpoint sender, byte[] payload, Status status) {
        this(preamble, time, id, sender, "", payload, status);
    }

    InternalMessage(int preamble, HybridLogicalTime time, long id, Endpoint sender, String type, byte[] payload, Status status) {
        this.preamble = preamble;
        this.time = time;
        this.id = id;
        this.sender = sender;
        this.type = type;
        this.payload = payload;
        this.status = status;
    }

    public boolean isRequest() {
        return this.status == null;
    }

    public boolean isReply() {
        return this.status != null;
    }

    public HybridLogicalTime time() {
        return this.time;
    }

    public int preamble() {
        return this.preamble;
    }

    public long id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public Endpoint sender() {
        return this.sender;
    }

    public byte[] payload() {
        return this.payload;
    }

    public Status status() {
        return this.status;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)this.time).add("id", this.id).add("type", (Object)this.type).add("sender", (Object)this.sender).add("status", (Object)this.status).add("payload", (Object)ByteArraySizeHashPrinter.of((byte[])this.payload)).toString();
    }

    public static enum Status {
        OK(0),
        ERROR_NO_HANDLER(1),
        ERROR_HANDLER_EXCEPTION(2),
        PROTOCOL_EXCEPTION(3);

        private final int id;

        private Status(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Status forId(int id) {
            switch (id) {
                case 0: {
                    return OK;
                }
                case 1: {
                    return ERROR_NO_HANDLER;
                }
                case 2: {
                    return ERROR_HANDLER_EXCEPTION;
                }
                case 3: {
                    return PROTOCOL_EXCEPTION;
                }
            }
            throw new IllegalArgumentException("Unknown status ID " + id);
        }
    }
}

