/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceEvent;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceStore;
import org.onosproject.net.resource.ResourceStoreDelegate;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.resource.impl.ConsistentContinuousResourceSubStore;
import org.onosproject.store.resource.impl.ConsistentDiscreteResourceSubStore;
import org.onosproject.store.resource.impl.ContinuousResourceAllocation;
import org.onosproject.store.resource.impl.EmptyDiscreteResources;
import org.onosproject.store.resource.impl.EncodableDiscreteResources;
import org.onosproject.store.resource.impl.EncodableDiscreteResourcesSerializer;
import org.onosproject.store.resource.impl.EncodedDiscreteResources;
import org.onosproject.store.resource.impl.EncodedResourcesSerializer;
import org.onosproject.store.resource.impl.GenericDiscreteResources;
import org.onosproject.store.resource.impl.MplsLabelCodec;
import org.onosproject.store.resource.impl.PortNumberCodec;
import org.onosproject.store.resource.impl.TransactionalContinuousResourceSubStore;
import org.onosproject.store.resource.impl.TransactionalDiscreteResourceSubStore;
import org.onosproject.store.resource.impl.UnifiedDiscreteResources;
import org.onosproject.store.resource.impl.VlanIdCodec;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.CommitStatus;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
@Beta
public class ConsistentResourceStore
extends AbstractStore<ResourceEvent, ResourceStoreDelegate>
implements ResourceStore {
    private static final Logger log = LoggerFactory.getLogger(ConsistentResourceStore.class);
    static final org.onosproject.store.service.Serializer SERIALIZER = org.onosproject.store.service.Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{UnifiedDiscreteResources.class}).register((Serializer)new EncodableDiscreteResourcesSerializer(), new Class[]{EncodableDiscreteResources.class}).register(new Class[]{GenericDiscreteResources.class}).register(new Class[]{EmptyDiscreteResources.class}).register((Serializer)new EncodedResourcesSerializer(), new Class[]{EncodedDiscreteResources.class}).register(new Class[]{ContinuousResourceAllocation.class}).register(new Class[]{PortNumberCodec.class}).register(new Class[]{VlanIdCodec.class}).register(new Class[]{MplsLabelCodec.class}).build());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService service;
    private ConsistentDiscreteResourceSubStore discreteStore;
    private ConsistentContinuousResourceSubStore continuousStore;

    @Activate
    public void activate() {
        this.discreteStore = new ConsistentDiscreteResourceSubStore(this.service);
        this.continuousStore = new ConsistentContinuousResourceSubStore(this.service);
        log.info("Started");
    }

    public List<ResourceAllocation> getResourceAllocations(ResourceId id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((id instanceof DiscreteResourceId || id instanceof ContinuousResourceId ? 1 : 0) != 0);
        if (id instanceof DiscreteResourceId) {
            return this.discreteStore.getResourceAllocations((DiscreteResourceId)id);
        }
        return this.continuousStore.getResourceAllocations((ContinuousResourceId)id);
    }

    /*
     * Exception decompiling
     */
    public boolean register(List<? extends Resource> resources) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean unregister(List<? extends ResourceId> ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean allocate(List<? extends Resource> resources, ResourceConsumer consumer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean release(List<ResourceAllocation> allocations) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isAvailable(Resource resource) {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((resource instanceof DiscreteResource || resource instanceof ContinuousResource ? 1 : 0) != 0);
        if (resource instanceof DiscreteResource) {
            return this.discreteStore.isAvailable((DiscreteResource)resource);
        }
        return this.continuousStore.isAvailable((ContinuousResource)resource);
    }

    public Collection<Resource> getResources(ResourceConsumer consumer) {
        Preconditions.checkNotNull((Object)consumer);
        Stream<DiscreteResource> discrete = this.discreteStore.getResources(consumer.consumerId());
        Stream<ContinuousResource> continuous = this.continuousStore.getResources(consumer.consumerId());
        return Stream.concat(discrete, continuous).collect(Collectors.toList());
    }

    public Set<Resource> getChildResources(DiscreteResourceId parent) {
        Preconditions.checkNotNull((Object)parent);
        return ImmutableSet.builder().addAll(this.discreteStore.getChildResources(parent)).addAll(this.continuousStore.getChildResources(parent)).build();
    }

    public <T> Set<Resource> getChildResources(DiscreteResourceId parent, Class<T> cls) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        return ImmutableSet.builder().addAll(this.discreteStore.getChildResources(parent, cls)).addAll(this.continuousStore.getChildResources(parent, cls)).build();
    }

    public <T> Collection<Resource> getAllocatedResources(DiscreteResourceId parent, Class<T> cls) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        Stream<DiscreteResource> discrete = this.discreteStore.getAllocatedResources(parent, cls);
        Stream<ContinuousResource> continuous = this.continuousStore.getAllocatedResources(parent, cls);
        return Stream.concat(discrete, continuous).collect(Collectors.toList());
    }

    private CommitStatus commitTransaction(TransactionContext tx) throws InterruptedException, ExecutionException, TimeoutException {
        return (CommitStatus)tx.commit().get(5000L, TimeUnit.MILLISECONDS);
    }

    private boolean abortTransaction(TransactionContext tx) {
        tx.abort();
        return false;
    }

    private boolean register(TransactionalDiscreteResourceSubStore discreteTxStore, TransactionalContinuousResourceSubStore continuousTxStore, DiscreteResourceId parent, List<Resource> resources) {
        Set discreteResources = resources.stream().filter(x -> x instanceof DiscreteResource).map(x -> (DiscreteResource)x).collect(Collectors.toCollection(LinkedHashSet::new));
        Set continuousResources = resources.stream().filter(x -> x instanceof ContinuousResource).map(x -> (ContinuousResource)x).collect(Collectors.toCollection(LinkedHashSet::new));
        return discreteTxStore.register(parent, discreteResources) && continuousTxStore.register(parent, continuousResources);
    }

    private boolean unregister(TransactionalDiscreteResourceSubStore discreteTxStore, TransactionalContinuousResourceSubStore continuousTxStore, DiscreteResourceId parent, List<Resource> resources) {
        Set discreteResources = resources.stream().filter(x -> x instanceof DiscreteResource).map(x -> (DiscreteResource)x).collect(Collectors.toCollection(LinkedHashSet::new));
        Set continuousResources = resources.stream().filter(x -> x instanceof ContinuousResource).map(x -> (ContinuousResource)x).collect(Collectors.toCollection(LinkedHashSet::new));
        return discreteTxStore.unregister(parent, discreteResources) && continuousTxStore.unregister(parent, continuousResources);
    }

    private static /* synthetic */ String lambda$unregister$10(Map.Entry entry) {
        return String.format("%d %s type resources", entry.getValue(), entry.getKey());
    }

    private static /* synthetic */ ResourceEvent lambda$unregister$9(Resource x) {
        return new ResourceEvent(ResourceEvent.Type.RESOURCE_REMOVED, x);
    }

    private static /* synthetic */ boolean lambda$unregister$8(Resource x) {
        return x.parent().isPresent();
    }

    private static /* synthetic */ DiscreteResourceId lambda$unregister$7(Resource x) {
        return ((DiscreteResource)x.parent().get()).id();
    }

    private static /* synthetic */ Optional lambda$unregister$6(TransactionalContinuousResourceSubStore continuousTxStore, ResourceId x) {
        if (x instanceof DiscreteResourceId) {
            return Optional.of(Resources.discrete((DiscreteResourceId)((DiscreteResourceId)x)).resource());
        }
        return continuousTxStore.lookup((ContinuousResourceId)x);
    }

    private static /* synthetic */ boolean lambda$unregister$5(ResourceId x) {
        return x.parent().isPresent();
    }

    private static /* synthetic */ ResourceEvent lambda$register$4(Resource x) {
        return new ResourceEvent(ResourceEvent.Type.RESOURCE_ADDED, x);
    }

    private static /* synthetic */ boolean lambda$register$3(Resource x) {
        return x.parent().isPresent();
    }

    private static /* synthetic */ DiscreteResource lambda$register$2(Resource x) {
        return (DiscreteResource)x.parent().get();
    }

    private static /* synthetic */ boolean lambda$register$1(Resource x) {
        return x.parent().isPresent();
    }

    private static /* synthetic */ void lambda$register$0(Resource r) {
        log.trace("registering {}", (Object)r);
    }

    protected void bindService(StorageService storageService) {
        this.service = storageService;
    }

    protected void unbindService(StorageService storageService) {
        if (this.service == storageService) {
            this.service = null;
        }
    }
}

