/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.link.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.SharedExecutors;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotations;
import org.onosproject.net.AnnotationsUtil;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkStore;
import org.onosproject.net.link.LinkStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.onosproject.store.link.impl.CoreConfig;
import org.onosproject.store.link.impl.Provided;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.StoreSerializer;
import org.onosproject.store.serializers.custom.DistributedStoreSerializers;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ECLinkStore
extends AbstractStore<LinkEvent, LinkStoreDelegate>
implements LinkStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<LinkKey, Link> links = Maps.newConcurrentMap();
    private final Map<LinkKey, Set<ProviderId>> linkProviders = Maps.newConcurrentMap();
    private EventuallyConsistentMap<Provided<LinkKey>, LinkDescription> linkDescriptions;
    private ApplicationId appId;
    private static final MessageSubject LINK_INJECT_MESSAGE = new MessageSubject("inject-link-request");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceClockService deviceClockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netCfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private EventuallyConsistentMapListener<Provided<LinkKey>, LinkDescription> linkTracker = new InternalLinkTracker();
    private final InternalConfigListener cfgListener = new InternalConfigListener();
    protected LinkDiscoveryMode linkDiscoveryMode = LinkDiscoveryMode.STRICT;
    protected static final StoreSerializer SERIALIZER = StoreSerializer.using((KryoNamespace)KryoNamespace.newBuilder().register(DistributedStoreSerializers.STORE_COMMON).nextId(510).register(new Class[]{Provided.class}).build("ECLink"));
    private final ConfigFactory factory = new ConfigFactory<ApplicationId, CoreConfig>(SubjectFactories.APP_SUBJECT_FACTORY, CoreConfig.class, "core"){

        public CoreConfig createConfig() {
            return new CoreConfig();
        }
    };

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.core");
        this.netCfgService.registerConfigFactory(this.factory);
        this.netCfgService.addListener((EventListener)this.cfgListener);
        this.cfgListener.reconfigure((CoreConfig)this.netCfgService.getConfig((Object)this.appId, CoreConfig.class));
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MastershipBasedTimestamp.class}).register(new Class[]{Provided.class});
        this.linkDescriptions = this.storageService.eventuallyConsistentMapBuilder().withName("onos-link-descriptions").withSerializer(serializer).withTimestampProvider((k, v) -> {
            try {
                return v == null ? null : this.deviceClockService.getTimestamp(v.dst().deviceId());
            }
            catch (IllegalStateException e) {
                return null;
            }
        }).build();
        this.clusterCommunicator.addSubscriber(LINK_INJECT_MESSAGE, arg_0 -> ((StoreSerializer)SERIALIZER).decode(arg_0), this::injectLink, arg_0 -> ((StoreSerializer)SERIALIZER).encode(arg_0), (Executor)SharedExecutors.getPoolThreadExecutor());
        this.linkDescriptions.addListener(this.linkTracker);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.linkDescriptions.removeListener(this.linkTracker);
        this.linkDescriptions.destroy();
        this.linkProviders.clear();
        this.links.clear();
        this.clusterCommunicator.removeSubscriber(LINK_INJECT_MESSAGE);
        this.netCfgService.removeListener((EventListener)this.cfgListener);
        this.netCfgService.unregisterConfigFactory(this.factory);
        this.log.info("Stopped");
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public Iterable<Link> getLinks() {
        return this.links.values();
    }

    public Set<Link> getDeviceEgressLinks(DeviceId deviceId) {
        return this.filter(this.links.values(), link -> deviceId.equals((Object)link.src().deviceId()));
    }

    public Set<Link> getDeviceIngressLinks(DeviceId deviceId) {
        return this.filter(this.links.values(), link -> deviceId.equals((Object)link.dst().deviceId()));
    }

    public Link getLink(ConnectPoint src, ConnectPoint dst) {
        return this.links.get(LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst));
    }

    public Set<Link> getEgressLinks(ConnectPoint src) {
        return this.filter(this.links.values(), link -> src.equals((Object)link.src()));
    }

    public Set<Link> getIngressLinks(ConnectPoint dst) {
        return this.filter(this.links.values(), link -> dst.equals((Object)link.dst()));
    }

    public LinkEvent createOrUpdateLink(ProviderId providerId, LinkDescription linkDescription) {
        DeviceId dstDeviceId = linkDescription.dst().deviceId();
        NodeId dstNodeId = this.mastershipService.getMasterFor(dstDeviceId);
        if (this.clusterService.getLocalNode().id().equals((Object)dstNodeId)) {
            LinkKey linkKey = LinkKey.linkKey((ConnectPoint)linkDescription.src(), (ConnectPoint)linkDescription.dst());
            Provided<LinkKey> internalLinkKey = this.getProvided(linkKey, providerId);
            if (internalLinkKey == null) {
                return null;
            }
            this.linkDescriptions.compute(internalLinkKey, (k, v) -> this.createOrUpdateLinkInternal((LinkDescription)v, linkDescription));
            return this.refreshLinkCache(linkKey);
        }
        if (!"cfg".equals(providerId.scheme()) && !"null".equals(providerId.scheme())) {
            return null;
        }
        if (dstNodeId == null) {
            return null;
        }
        return (LinkEvent)Futures.getUnchecked((Future)this.clusterCommunicator.sendAndReceive(new Provided<LinkDescription>(linkDescription, providerId), LINK_INJECT_MESSAGE, arg_0 -> ((StoreSerializer)SERIALIZER).encode(arg_0), arg_0 -> ((StoreSerializer)SERIALIZER).decode(arg_0), dstNodeId));
    }

    private Provided<LinkKey> getProvided(LinkKey linkKey, ProviderId provId) {
        ProviderId bpid = this.getBaseProviderId(linkKey);
        if (provId == null) {
            return bpid == null ? null : new Provided<LinkKey>(linkKey, bpid);
        }
        return new Provided<LinkKey>(linkKey, provId);
    }

    private LinkDescription createOrUpdateLinkInternal(LinkDescription current, LinkDescription updated) {
        if (current != null) {
            Link.Type type = current.type() == Link.Type.DIRECT && updated.type() == Link.Type.INDIRECT ? Link.Type.DIRECT : updated.type();
            return new DefaultLinkDescription(current.src(), current.dst(), type, current.isExpected(), new SparseAnnotations[]{DefaultAnnotations.union((SparseAnnotations)current.annotations(), (SparseAnnotations)updated.annotations())});
        }
        return updated;
    }

    private Set<ProviderId> createOrUpdateLinkProviders(Set<ProviderId> current, ProviderId providerId) {
        if (current == null) {
            current = Sets.newConcurrentHashSet();
        }
        current.add(providerId);
        return current;
    }

    private LinkEvent refreshLinkCache(LinkKey linkKey) {
        AtomicReference eventType = new AtomicReference();
        Link link = this.links.compute(linkKey, (key, existingLink) -> {
            Link newLink = this.composeLink(linkKey);
            if (newLink == null) {
                return null;
            }
            if (existingLink == null) {
                eventType.set(LinkEvent.Type.LINK_ADDED);
                return newLink;
            }
            if (existingLink.state() != newLink.state() || existingLink.isExpected() != newLink.isExpected() || existingLink.type() != newLink.type() || !AnnotationsUtil.isEqual((Annotations)existingLink.annotations(), (Annotations)newLink.annotations())) {
                eventType.set(LinkEvent.Type.LINK_UPDATED);
                return newLink;
            }
            return existingLink;
        });
        return eventType.get() != null ? new LinkEvent((LinkEvent.Type)eventType.get(), link) : null;
    }

    private Set<ProviderId> getAllProviders(LinkKey linkKey) {
        return this.linkProviders.getOrDefault(linkKey, Sets.newConcurrentHashSet());
    }

    private ProviderId getBaseProviderId(LinkKey linkKey) {
        Set<ProviderId> allProviders = this.getAllProviders(linkKey);
        if (allProviders.size() > 0) {
            return allProviders.stream().filter(p -> !p.isAncillary()).findFirst().orElse((ProviderId)Iterables.getFirst(allProviders, null));
        }
        return null;
    }

    private Link composeLink(LinkKey linkKey) {
        boolean isExpected;
        Link.State initialLinkState;
        ProviderId baseProviderId = this.getBaseProviderId(linkKey);
        if (baseProviderId == null) {
            return null;
        }
        LinkDescription base = (LinkDescription)this.linkDescriptions.get(new Provided<LinkKey>(linkKey, baseProviderId));
        if (base == null) {
            return null;
        }
        ConnectPoint src = base.src();
        ConnectPoint dst = base.dst();
        Link.Type type = base.type();
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.putAll((Annotations)base.annotations());
        this.getAllProviders(linkKey).stream().map(p -> new Provided<LinkKey>(linkKey, (ProviderId)p)).forEach(key -> {
            LinkDescription linkDescription = (LinkDescription)this.linkDescriptions.get(key);
            if (linkDescription != null) {
                builder.putAll((Annotations)linkDescription.annotations());
            }
        });
        DefaultAnnotations annotations = builder.build();
        if (this.linkDiscoveryMode == LinkDiscoveryMode.PERMISSIVE) {
            initialLinkState = Link.State.ACTIVE;
            isExpected = Objects.equals(annotations.value("durable"), "true");
        } else {
            initialLinkState = base.isExpected() ? Link.State.ACTIVE : Link.State.INACTIVE;
            isExpected = base.isExpected();
        }
        return DefaultLink.builder().providerId(baseProviderId).src(src).dst(dst).type(type).state(initialLinkState).isExpected(isExpected).annotations((Annotations)annotations).build();
    }

    private LinkEvent updateLink(LinkKey key, Link oldLink, Link newLink) {
        if (oldLink.state() != newLink.state() || oldLink.type() == Link.Type.INDIRECT && newLink.type() == Link.Type.DIRECT || !AnnotationsUtil.isEqual((Annotations)oldLink.annotations(), (Annotations)newLink.annotations())) {
            this.links.put(key, newLink);
            return new LinkEvent(LinkEvent.Type.LINK_UPDATED, newLink);
        }
        return null;
    }

    public LinkEvent removeOrDownLink(ConnectPoint src, ConnectPoint dst) {
        Link link = this.getLink(src, dst);
        if (link == null) {
            return null;
        }
        if (this.linkDiscoveryMode == LinkDiscoveryMode.PERMISSIVE && link.isExpected()) {
            return link.state() == Link.State.INACTIVE ? null : this.updateLink(LinkKey.linkKey((ConnectPoint)link.src(), (ConnectPoint)link.dst()), link, (Link)DefaultLink.builder().providerId(link.providerId()).src(link.src()).dst(link.dst()).type(link.type()).state(Link.State.INACTIVE).isExpected(link.isExpected()).annotations(link.annotations()).build());
        }
        return this.removeLink(src, dst);
    }

    public LinkEvent removeLink(ConnectPoint src, ConnectPoint dst) {
        LinkKey linkKey = LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        ProviderId primaryProviderId = this.getBaseProviderId(linkKey);
        if (primaryProviderId == null) {
            return null;
        }
        LinkDescription removedLinkDescription = (LinkDescription)this.linkDescriptions.remove(new Provided<LinkKey>(linkKey, primaryProviderId));
        if (removedLinkDescription != null) {
            return this.purgeLinkCache(linkKey);
        }
        return null;
    }

    private LinkEvent purgeLinkCache(LinkKey linkKey) {
        Link removedLink = this.links.remove(linkKey);
        if (removedLink != null) {
            this.getAllProviders(linkKey).forEach(p -> {
                LinkDescription cfr_ignored_0 = (LinkDescription)this.linkDescriptions.remove(new Provided<LinkKey>(linkKey, (ProviderId)p));
            });
            this.linkProviders.remove(linkKey);
            return new LinkEvent(LinkEvent.Type.LINK_REMOVED, removedLink);
        }
        return null;
    }

    private Set<Link> filter(Collection<Link> links, Predicate<Link> predicate) {
        return links.stream().filter(predicate).collect(Collectors.toSet());
    }

    private LinkEvent injectLink(Provided<LinkDescription> linkInjectRequest) {
        this.log.trace("Received request to inject link {}", linkInjectRequest);
        ProviderId providerId = linkInjectRequest.providerId();
        LinkDescription linkDescription = linkInjectRequest.key();
        DeviceId deviceId = linkDescription.dst().deviceId();
        if (!this.deviceClockService.isTimestampAvailable(deviceId)) {
            this.log.warn("Not ready to accept update. Dropping {}", linkInjectRequest);
            return null;
        }
        return this.createOrUpdateLink(providerId, linkDescription);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindDeviceClockService(DeviceClockService deviceClockService) {
        this.deviceClockService = deviceClockService;
    }

    protected void unbindDeviceClockService(DeviceClockService deviceClockService) {
        if (this.deviceClockService == deviceClockService) {
            this.deviceClockService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindNetCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.netCfgService = networkConfigRegistry;
    }

    protected void unbindNetCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netCfgService == networkConfigRegistry) {
            this.netCfgService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        void reconfigure(CoreConfig coreConfig) {
            ECLinkStore.this.linkDiscoveryMode = coreConfig == null ? LinkDiscoveryMode.PERMISSIVE : coreConfig.linkDiscoveryMode();
            if (ECLinkStore.this.linkDiscoveryMode == LinkDiscoveryMode.STRICT) {
                if (ECLinkStore.this.linkDescriptions != null) {
                    ECLinkStore.this.linkDescriptions.clear();
                }
                if (ECLinkStore.this.links != null) {
                    ECLinkStore.this.links.clear();
                }
            }
            ECLinkStore.this.log.debug("config set link discovery mode to {}", (Object)ECLinkStore.this.linkDiscoveryMode.name());
        }

        public void event(NetworkConfigEvent event) {
            if ((event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED) && event.configClass().equals(CoreConfig.class)) {
                CoreConfig cfg = (CoreConfig)ECLinkStore.this.netCfgService.getConfig((Object)ECLinkStore.this.appId, CoreConfig.class);
                this.reconfigure(cfg);
                ECLinkStore.this.log.info("Reconfigured");
            }
        }
    }

    private class InternalLinkTracker
    implements EventuallyConsistentMapListener<Provided<LinkKey>, LinkDescription> {
        private InternalLinkTracker() {
        }

        public void event(EventuallyConsistentMapEvent<Provided<LinkKey>, LinkDescription> event) {
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                ECLinkStore.this.linkProviders.compute(((Provided)event.key()).key(), (k, v) -> ECLinkStore.this.createOrUpdateLinkProviders(v, ((Provided)event.key()).providerId()));
                ECLinkStore.this.notifyDelegate((Event)ECLinkStore.this.refreshLinkCache((LinkKey)((Provided)event.key()).key()));
            } else if (event.type() == EventuallyConsistentMapEvent.Type.REMOVE) {
                ECLinkStore.this.notifyDelegate((Event)ECLinkStore.this.purgeLinkCache((LinkKey)((Provided)event.key()).key()));
                ECLinkStore.this.linkProviders.remove(((Provided)event.key()).key());
            }
        }
    }

    protected static enum LinkDiscoveryMode {
        PERMISSIVE,
        STRICT;

    }
}

