/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.device.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.mastership.MastershipTermService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.store.Timestamp;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DeviceClockManager
implements DeviceClockService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipTermService mastershipTermService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    protected NodeId localNodeId;
    private final AtomicLong ticker = new AtomicLong(0L);
    private final Cache<DeviceId, Long> myLastKnownTerm = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private MastershipListener listener;

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.listener = new InnerMastershipListener();
        this.mastershipService.addListener((EventListener)this.listener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.mastershipService.removeListener((EventListener)this.listener);
        this.log.info("Stopped");
    }

    public Timestamp getTimestamp(DeviceId deviceId) {
        Long termNumber = this.refreshLastKnownTerm(deviceId);
        if (termNumber == null) {
            this.log.warn("Requested timestamp for {} which {}doesn't have known recent mastership term", (Object)deviceId, (Object)this.localNodeId);
            throw new IllegalStateException("Requesting timestamp for " + deviceId + " without mastership");
        }
        return new MastershipBasedTimestamp(termNumber, this.ticker.incrementAndGet());
    }

    public boolean isTimestampAvailable(DeviceId deviceId) {
        return this.myLastKnownTerm.getIfPresent((Object)deviceId) != null || this.refreshLastKnownTerm(deviceId) != null;
    }

    private Long refreshLastKnownTerm(DeviceId deviceId) {
        MastershipTerm term = this.mastershipTermService.getMastershipTerm(deviceId);
        return this.myLastKnownTerm.asMap().compute(deviceId, (key, old) -> {
            if (old == null) {
                return Optional.ofNullable(term).filter(t -> this.localNodeId.equals((Object)t.master())).map(MastershipTerm::termNumber).orElse(null);
            }
            return Optional.ofNullable(term).filter(t -> this.localNodeId.equals((Object)t.master())).map(MastershipTerm::termNumber).map(tn -> Math.max(old, tn)).orElse((Long)old);
        });
    }

    protected void bindMastershipTermService(MastershipTermService mastershipTermService) {
        this.mastershipTermService = mastershipTermService;
    }

    protected void unbindMastershipTermService(MastershipTermService mastershipTermService) {
        if (this.mastershipTermService == mastershipTermService) {
            this.mastershipTermService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private final class InnerMastershipListener
    implements MastershipListener {
        private InnerMastershipListener() {
        }

        public boolean isRelevant(MastershipEvent event) {
            return event.type() == MastershipEvent.Type.MASTER_CHANGED;
        }

        public void event(MastershipEvent event) {
            if (DeviceClockManager.this.localNodeId.equals((Object)event.roleInfo().master())) {
                DeviceClockManager.this.refreshLastKnownTerm((DeviceId)event.subject());
            }
        }
    }
}

