/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.app;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.ApplicationException;
import org.onosproject.app.ApplicationIdStore;
import org.onosproject.app.ApplicationState;
import org.onosproject.app.ApplicationStore;
import org.onosproject.app.ApplicationStoreDelegate;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.common.app.ApplicationArchive;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplication;
import org.onosproject.event.Event;
import org.onosproject.security.Permission;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Topic;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedApplicationStore
extends ApplicationArchive
implements ApplicationStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final MessageSubject APP_BITS_REQUEST = new MessageSubject("app-bits-request");
    private static final int MAX_LOAD_RETRIES = 5;
    private static final int RETRY_DELAY_MS = 2000;
    private static final int FETCH_TIMEOUT_MS = 10000;
    private static final int APP_LOAD_DELAY_MS = 500;
    private static List<String> pendingApps = Lists.newArrayList();
    private ScheduledExecutorService executor;
    private ExecutorService messageHandlingExecutor;
    private ExecutorService activationExecutor;
    private ConsistentMap<ApplicationId, InternalApplicationHolder> apps;
    private Topic<Application> appActivationTopic;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationIdStore idStore;
    private final InternalAppsListener appsListener = new InternalAppsListener();
    private final Consumer<Application> appActivator = new AppActivator();
    private Consumer<DistributedPrimitive.Status> statusChangeListener;
    private final Multimap<ApplicationId, ApplicationId> requiredBy = Multimaps.synchronizedSetMultimap((SetMultimap)Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet));
    private ApplicationId coreAppId;

    @Activate
    public void activate() {
        this.messageHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/app", (String)"message-handler", (Logger)this.log));
        this.clusterCommunicator.addSubscriber(APP_BITS_REQUEST, bytes -> new String((byte[])bytes, Charsets.UTF_8), name -> {
            try {
                this.log.info("Sending bits for application {}", name);
                return ByteStreams.toByteArray((InputStream)this.getApplicationInputStream((String)name));
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }, Function.identity(), (Executor)this.messageHandlingExecutor);
        this.apps = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-apps")).withRelaxedReadConsistency()).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{InternalApplicationHolder.class, InternalState.class}))).build();
        this.appActivationTopic = this.storageService.getTopic("onos-apps-activation-topic", Serializer.using((KryoNamespace)KryoNamespaces.API));
        this.activationExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/app", (String)"app-activation", (Logger)this.log));
        this.appActivationTopic.subscribe(this.appActivator, (Executor)this.activationExecutor);
        this.executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/app", (String)"store", (Logger)this.log));
        this.statusChangeListener = status -> {
            if (status == DistributedPrimitive.Status.ACTIVE) {
                this.executor.execute(this::bootstrapExistingApplications);
            }
        };
        this.apps.addListener((MapEventListener)this.appsListener, (Executor)this.activationExecutor);
        this.apps.addStatusChangeListener(this.statusChangeListener);
        this.coreAppId = this.getId("org.onosproject.core");
        this.activateExistingApplications();
        this.log.info("Started");
    }

    private void activateExistingApplications() {
        this.getApplicationNames().forEach(appName -> {
            InternalApplicationHolder appHolder;
            Application application;
            ApplicationId appId = this.getId((String)appName);
            if (appId != null && (application = this.getApplication(appId)) != null && (appHolder = (InternalApplicationHolder)Versioned.valueOrNull((Versioned)this.apps.get((Object)application.id()))) != null && appHolder.state == InternalState.ACTIVATED && !this.isActive((String)appName)) {
                this.setActive((String)appName);
                this.updateTime((String)appName);
            }
        });
    }

    private void bootstrapExistingApplications() {
        this.apps.asJavaMap().forEach((appId, holder) -> this.setupApplicationAndNotify((ApplicationId)appId, holder.app(), holder.state()));
    }

    private void loadFromDisk() {
        this.getApplicationNames().forEach(appName -> {
            Application app = this.loadFromDisk((String)appName);
            if (app != null && this.isActive(app.id().name())) {
                this.activate(app.id(), false);
            }
        });
    }

    private Application loadFromDisk(String appName) {
        pendingApps.add(appName);
        for (int i = 0; i < 5; ++i) {
            try {
                Application application;
                ApplicationId appId = this.getId(appName);
                if (appId != null && (application = this.getApplication(appId)) != null) {
                    pendingApps.remove(appName);
                    return application;
                }
                ApplicationDescription appDesc = this.getApplicationDescription(appName);
                Optional<String> loop = appDesc.requiredApps().stream().filter(app -> pendingApps.contains(app)).findAny();
                if (loop.isPresent()) {
                    this.log.error("Circular app dependency detected: {} -> {}", pendingApps, (Object)loop.get());
                    pendingApps.remove(appName);
                    return null;
                }
                boolean success = appDesc.requiredApps().stream().noneMatch(requiredApp -> this.loadFromDisk((String)requiredApp) == null);
                pendingApps.remove(appName);
                return success ? this.create(appDesc, false) : null;
            }
            catch (Exception e) {
                this.log.warn("Unable to load application {} from disk; retrying", (Object)appName);
                Tools.randomDelay((int)2000);
                continue;
            }
        }
        pendingApps.remove(appName);
        return null;
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(APP_BITS_REQUEST);
        this.apps.removeStatusChangeListener(this.statusChangeListener);
        this.apps.removeListener((MapEventListener)this.appsListener);
        this.appActivationTopic.unsubscribe(this.appActivator);
        this.messageHandlingExecutor.shutdown();
        this.activationExecutor.shutdown();
        this.executor.shutdown();
        this.log.info("Stopped");
    }

    public void setDelegate(ApplicationStoreDelegate delegate) {
        super.setDelegate((StoreDelegate)delegate);
        this.executor.execute(this::bootstrapExistingApplications);
        this.executor.schedule(this::loadFromDisk, 500L, TimeUnit.MILLISECONDS);
    }

    public Set<Application> getApplications() {
        return ImmutableSet.copyOf((Collection)this.apps.values().stream().map(Versioned::value).map(InternalApplicationHolder::app).collect(Collectors.toSet()));
    }

    public ApplicationId getId(String name) {
        return this.idStore.getAppId(name);
    }

    public Application getApplication(ApplicationId appId) {
        InternalApplicationHolder appHolder = (InternalApplicationHolder)Versioned.valueOrNull((Versioned)this.apps.get((Object)appId));
        return appHolder != null ? appHolder.app() : null;
    }

    public ApplicationState getState(ApplicationId appId) {
        InternalState state;
        InternalApplicationHolder appHolder = (InternalApplicationHolder)Versioned.valueOrNull((Versioned)this.apps.get((Object)appId));
        InternalState internalState = state = appHolder != null ? appHolder.state() : null;
        return state == null ? null : (state == InternalState.ACTIVATED ? ApplicationState.ACTIVE : ApplicationState.INSTALLED);
    }

    public Application create(InputStream appDescStream) {
        ApplicationDescription appDesc = this.saveApplication(appDescStream);
        if (this.hasPrerequisites(appDesc)) {
            return this.create(appDesc, true);
        }
        this.purgeApplication(appDesc.name());
        throw new ApplicationException("Missing dependencies for app " + appDesc.name());
    }

    private boolean hasPrerequisites(ApplicationDescription app) {
        for (String required : app.requiredApps()) {
            ApplicationId id = this.getId(required);
            if (id != null && this.getApplication(id) != null) continue;
            this.log.error("{} required for {} not available", (Object)required, (Object)app.name());
            return false;
        }
        return true;
    }

    private Application create(ApplicationDescription appDesc, boolean updateTime) {
        InternalApplicationHolder previousApp;
        Application app = this.registerApp(appDesc);
        if (updateTime) {
            this.updateTime(app.id().name());
        }
        return (previousApp = (InternalApplicationHolder)Versioned.valueOrNull((Versioned)this.apps.putIfAbsent((Object)app.id(), (Object)new InternalApplicationHolder(app, InternalState.INSTALLED, null)))) != null ? previousApp.app() : app;
    }

    public void remove(ApplicationId appId) {
        this.uninstallDependentApps(appId);
        this.apps.remove((Object)appId);
    }

    private void uninstallDependentApps(ApplicationId appId) {
        this.getApplications().stream().filter(a -> a.requiredApps().contains(appId.name())).forEach(a -> this.remove(a.id()));
    }

    public void activate(ApplicationId appId) {
        this.activate(appId, this.coreAppId);
    }

    private void activate(ApplicationId appId, ApplicationId forAppId) {
        this.requiredBy.put((Object)appId, (Object)forAppId);
        this.activate(appId, true);
    }

    private void activate(ApplicationId appId, boolean updateTime) {
        Versioned vAppHolder = this.apps.get((Object)appId);
        if (vAppHolder != null) {
            if (updateTime) {
                this.updateTime(appId.name());
            }
            this.activateRequiredApps(((InternalApplicationHolder)vAppHolder.value()).app());
            this.apps.computeIf((Object)appId, v -> v != null && v.state() != InternalState.ACTIVATED, (k, v) -> new InternalApplicationHolder(v.app(), InternalState.ACTIVATED, v.permissions()));
            this.appActivationTopic.publish((Object)((InternalApplicationHolder)vAppHolder.value()).app());
            this.appActivationTopic.publish(null);
        }
    }

    private void activateRequiredApps(Application app) {
        app.requiredApps().stream().map(this::getId).forEach(id -> this.activate((ApplicationId)id, app.id()));
    }

    public void deactivate(ApplicationId appId) {
        this.deactivateDependentApps(appId);
        this.deactivate(appId, this.coreAppId);
    }

    private void deactivate(ApplicationId appId, ApplicationId forAppId) {
        this.requiredBy.remove((Object)appId, (Object)forAppId);
        if (this.requiredBy.get((Object)appId).isEmpty()) {
            AtomicBoolean stateChanged = new AtomicBoolean(false);
            this.apps.computeIf((Object)appId, v -> v != null && v.state() != InternalState.DEACTIVATED, (k, v) -> {
                stateChanged.set(true);
                return new InternalApplicationHolder(v.app(), InternalState.DEACTIVATED, v.permissions());
            });
            if (stateChanged.get()) {
                this.updateTime(appId.name());
                this.deactivateRequiredApps(appId);
            }
        }
    }

    private void deactivateDependentApps(ApplicationId appId) {
        this.apps.values().stream().map(Versioned::value).filter(a -> a.state() == InternalState.ACTIVATED).filter(a -> a.app().requiredApps().contains(appId.name())).forEach(a -> this.deactivate(a.app().id()));
    }

    private void deactivateRequiredApps(ApplicationId appId) {
        this.getApplication(appId).requiredApps().stream().map(this::getId).map(arg_0 -> this.apps.get(arg_0)).map(Versioned::value).filter(a -> a.state() == InternalState.ACTIVATED).forEach(a -> this.deactivate(a.app().id(), appId));
    }

    public Set<Permission> getPermissions(ApplicationId appId) {
        InternalApplicationHolder app = (InternalApplicationHolder)Versioned.valueOrNull((Versioned)this.apps.get((Object)appId));
        return app != null ? ImmutableSet.copyOf(app.permissions()) : ImmutableSet.of();
    }

    public void setPermissions(ApplicationId appId, Set<Permission> permissions) {
        AtomicBoolean permissionsChanged = new AtomicBoolean(false);
        Versioned appHolder = this.apps.computeIf((Object)appId, v -> v != null && !Sets.symmetricDifference(v.permissions(), (Set)permissions).isEmpty(), (k, v) -> {
            permissionsChanged.set(true);
            return new InternalApplicationHolder(v.app(), v.state(), (Set)ImmutableSet.copyOf((Collection)permissions));
        });
        if (permissionsChanged.get()) {
            this.notifyDelegate((Event)new ApplicationEvent(ApplicationEvent.Type.APP_PERMISSIONS_CHANGED, ((InternalApplicationHolder)appHolder.value()).app()));
        }
    }

    private void setupApplicationAndNotify(ApplicationId appId, Application app, InternalState state) {
        if (state == InternalState.INSTALLED) {
            this.fetchBitsIfNeeded(app);
            this.notifyDelegate((Event)new ApplicationEvent(ApplicationEvent.Type.APP_INSTALLED, app));
        } else if (state == InternalState.DEACTIVATED) {
            this.clearActive(appId.name());
            this.notifyDelegate((Event)new ApplicationEvent(ApplicationEvent.Type.APP_DEACTIVATED, app));
        }
    }

    private boolean appBitsAvailable(Application app) {
        try {
            ApplicationDescription appDesc = this.getApplicationDescription(app.id().name());
            return appDesc.version().equals((Object)app.version());
        }
        catch (ApplicationException e) {
            return false;
        }
    }

    private void fetchBitsIfNeeded(Application app) {
        if (!this.appBitsAvailable(app)) {
            this.fetchBits(app, false);
        }
    }

    private void installAppIfNeeded(Application app) {
        if (!this.appBitsAvailable(app)) {
            this.fetchBits(app, true);
        }
    }

    private void fetchBits(Application app, boolean delegateInstallation) {
        ControllerNode localNode = this.clusterService.getLocalNode();
        CountDownLatch latch = new CountDownLatch(1);
        this.log.info("Downloading bits for application {}", (Object)app.id().name());
        for (ControllerNode node : this.clusterService.getNodes()) {
            if (latch.getCount() == 0L) break;
            if (node.equals(localNode)) continue;
            this.clusterCommunicator.sendAndReceive((Object)app.id().name(), APP_BITS_REQUEST, s -> s.getBytes(Charsets.UTF_8), Function.identity(), node.id()).whenCompleteAsync((bits, error) -> {
                if (error == null && latch.getCount() > 0L) {
                    this.saveApplication(new ByteArrayInputStream((byte[])bits));
                    this.log.info("Downloaded bits for application {} from node {}", (Object)app.id().name(), (Object)node.id());
                    latch.countDown();
                    if (delegateInstallation) {
                        this.notifyDelegate((Event)new ApplicationEvent(ApplicationEvent.Type.APP_INSTALLED, app));
                    }
                } else if (error != null) {
                    this.log.warn("Unable to fetch bits for application {} from node {}", (Object)app.id().name(), (Object)node.id());
                }
            }, (Executor)this.executor);
        }
        try {
            if (!latch.await(10000L, TimeUnit.MILLISECONDS)) {
                this.log.warn("Unable to fetch bits for application {}", (Object)app.id().name());
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while fetching bits for application {}", (Object)app.id().name());
        }
    }

    private Application registerApp(ApplicationDescription appDesc) {
        ApplicationId appId = this.idStore.registerApplication(appDesc.name());
        return new DefaultApplication(appId, appDesc.version(), appDesc.title(), appDesc.description(), appDesc.origin(), appDesc.category(), appDesc.url(), appDesc.readme(), appDesc.icon(), appDesc.role(), appDesc.permissions(), appDesc.featuresRepo(), appDesc.features(), appDesc.requiredApps());
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindIdStore(ApplicationIdStore applicationIdStore) {
        this.idStore = applicationIdStore;
    }

    protected void unbindIdStore(ApplicationIdStore applicationIdStore) {
        if (this.idStore == applicationIdStore) {
            this.idStore = null;
        }
    }

    private static final class InternalApplicationHolder {
        private final Application app;
        private final InternalState state;
        private final Set<Permission> permissions;

        private InternalApplicationHolder() {
            this.app = null;
            this.state = null;
            this.permissions = null;
        }

        private InternalApplicationHolder(Application app, InternalState state, Set<Permission> permissions) {
            this.app = (Application)Preconditions.checkNotNull((Object)app);
            this.state = state;
            this.permissions = permissions == null ? null : ImmutableSet.copyOf(permissions);
        }

        public Application app() {
            return this.app;
        }

        public InternalState state() {
            return this.state;
        }

        public Set<Permission> permissions() {
            return this.permissions;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("app", (Object)this.app.id()).add("state", (Object)this.state).toString();
        }
    }

    private final class InternalAppsListener
    implements MapEventListener<ApplicationId, InternalApplicationHolder> {
        private InternalAppsListener() {
        }

        public void event(MapEvent<ApplicationId, InternalApplicationHolder> event) {
            InternalApplicationHolder oldApp;
            if (DistributedApplicationStore.this.delegate == null) {
                return;
            }
            ApplicationId appId = (ApplicationId)event.key();
            InternalApplicationHolder newApp = event.newValue() == null ? null : (InternalApplicationHolder)event.newValue().value();
            InternalApplicationHolder internalApplicationHolder = oldApp = event.oldValue() == null ? null : (InternalApplicationHolder)event.oldValue().value();
            if (event.type() == MapEvent.Type.UPDATE && (newApp == null || oldApp == null || newApp.state() == oldApp.state())) {
                DistributedApplicationStore.this.log.warn("Can't update the application {}", event.key());
                return;
            }
            if ((event.type() == MapEvent.Type.INSERT || event.type() == MapEvent.Type.UPDATE) && newApp != null) {
                DistributedApplicationStore.this.setupApplicationAndNotify(appId, newApp.app(), newApp.state());
            } else if (event.type() == MapEvent.Type.REMOVE && oldApp != null) {
                DistributedApplicationStore.this.notifyDelegate((Event)new ApplicationEvent(ApplicationEvent.Type.APP_UNINSTALLED, oldApp.app()));
                DistributedApplicationStore.this.purgeApplication(appId.name());
            } else {
                DistributedApplicationStore.this.log.warn("Can't perform {} on application {}", (Object)event.type(), event.key());
            }
        }
    }

    private class AppActivator
    implements Consumer<Application> {
        private AppActivator() {
        }

        @Override
        public void accept(Application app) {
            if (app != null) {
                String appName = app.id().name();
                DistributedApplicationStore.this.installAppIfNeeded(app);
                DistributedApplicationStore.this.setActive(appName);
                DistributedApplicationStore.this.notifyDelegate((Event)new ApplicationEvent(ApplicationEvent.Type.APP_ACTIVATED, app));
            }
        }
    }

    public static enum InternalState {
        INSTALLED,
        ACTIVATED,
        DEACTIVATED;

    }
}

