/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchEvent;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleBatchRequest;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleStore;
import org.onosproject.net.flow.FlowRuleStoreDelegate;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTree;
import org.onosproject.store.service.DocumentTreeBuilder;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.IllegalDocumentModificationException;
import org.onosproject.store.service.NoSuchDocumentPathException;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedFlowRuleStore
extends AbstractStore<FlowRuleBatchEvent, FlowRuleStoreDelegate>
implements FlowRuleStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final StorageException.ConcurrentModification RETRY = new StorageException.ConcurrentModification();
    private static final int SCHEDULED_THREAD_POOL_SIZE = 8;
    private static final int MESSAGE_HANDLER_THREAD_POOL_SIZE = 8;
    private static final int MAX_RETRY_DELAY_MILLIS = 50;
    private static final String FLOW_TABLE = "onos-flow-table";
    private static final MessageSubject APPLY_BATCH_FLOWS;
    private static final MessageSubject COMPLETE_BATCH;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    protected final Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.API);
    protected final KryoNamespace.Builder serializerBuilder = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MastershipBasedTimestamp.class});
    private EventuallyConsistentMap<DeviceId, List<TableStatisticsEntry>> deviceTableStats;
    private final EventuallyConsistentMapListener<DeviceId, List<TableStatisticsEntry>> tableStatsListener = new InternalTableStatsListener();
    private Set<Long> pendingBatches = Sets.newConcurrentHashSet();
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService messageHandlingExecutor;
    private final Random random = new Random();
    private AsyncDocumentTree<Map<StoredFlowEntry, StoredFlowEntry>> asyncFlows;
    private DocumentTree<Map<StoredFlowEntry, StoredFlowEntry>> flows;
    private IdGenerator idGenerator;
    private NodeId local;

    @Activate
    public void activate() {
        this.idGenerator = this.coreService.getIdGenerator("flow-ops-ids");
        this.local = this.clusterService.getLocalNode().id();
        this.scheduledExecutor = Executors.newScheduledThreadPool(8, Tools.groupedThreads((String)"onos/store/flow", (String)"schedulers", (Logger)this.log));
        this.messageHandlingExecutor = Executors.newFixedThreadPool(8, Tools.groupedThreads((String)"onos/store/flow", (String)"message-handlers", (Logger)this.log));
        this.deviceTableStats = this.storageService.eventuallyConsistentMapBuilder().withName("onos-flow-table-stats").withSerializer(this.serializerBuilder).withAntiEntropyPeriod(5L, TimeUnit.SECONDS).withTimestampProvider((k, v) -> new WallClockTimestamp()).withTombstonesDisabled().build();
        this.deviceTableStats.addListener(this.tableStatsListener);
        this.asyncFlows = ((DocumentTreeBuilder)((DocumentTreeBuilder)this.storageService.documentTreeBuilder().withName(FLOW_TABLE)).withSerializer(this.serializer)).buildDocumentTree();
        this.flows = this.asyncFlows.asDocumentTree();
        this.clusterCommunicator.addSubscriber(APPLY_BATCH_FLOWS, arg_0 -> ((Serializer)this.serializer).decode(arg_0), this::applyBatchFlows, (Executor)this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(COMPLETE_BATCH, arg_0 -> ((Serializer)this.serializer).decode(arg_0), this::completeBatch, (Executor)this.messageHandlingExecutor);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceTableStats.removeListener(this.tableStatsListener);
        this.deviceTableStats.destroy();
        this.clusterCommunicator.removeSubscriber(APPLY_BATCH_FLOWS);
        this.clusterCommunicator.removeSubscriber(COMPLETE_BATCH);
        this.messageHandlingExecutor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.log.info("Stopped");
    }

    private <T> T retryUntilSuccess(Supplier<T> supplier) {
        return Tools.retryable(supplier, StorageException.ConcurrentModification.class, (int)Integer.MAX_VALUE, (int)50).get();
    }

    private <T> CompletableFuture<T> retryAsyncUntilSuccess(Supplier<CompletableFuture<T>> supplier) {
        return this.retryAsyncUntilSuccess(supplier, new CompletableFuture());
    }

    private <T> CompletableFuture<T> retryAsyncUntilSuccess(Supplier<CompletableFuture<T>> supplier, CompletableFuture<T> future) {
        supplier.get().whenComplete((result, error) -> {
            if (error == null) {
                future.complete(result);
            } else {
                Throwable cause;
                Throwable throwable = cause = error.getCause() != null ? error.getCause() : error;
                if (cause instanceof StorageException.ConcurrentModification) {
                    this.scheduledExecutor.schedule(() -> this.lambda$null$1((Supplier)supplier, future), (long)this.random.nextInt(50), TimeUnit.MILLISECONDS);
                } else {
                    future.completeExceptionally((Throwable)error);
                }
            }
        });
        return future;
    }

    private <T> T retry() {
        throw RETRY;
    }

    private void completeBatch(FlowRuleBatchEvent event) {
        if (this.pendingBatches.remove(((FlowRuleBatchRequest)event.subject()).batchId())) {
            this.notifyDelegate((Event)event);
        }
    }

    public int getFlowRuleCount() {
        return ((Stream)Streams.stream((Iterable)this.deviceService.getDevices()).parallel()).mapToInt(device -> this.getFlowRuleCount(device.id())).sum();
    }

    public int getFlowRuleCount(DeviceId deviceId) {
        DocumentPath path = this.getPathFor(deviceId);
        try {
            return this.flows.getChildren(path).values().stream().mapToInt(v -> ((Map)v.value()).values().size()).sum();
        }
        catch (NoSuchDocumentPathException e) {
            return 0;
        }
    }

    private DocumentPath getPathFor(DeviceId deviceId) {
        return DocumentPath.from((String[])new String[]{"root", deviceId.toString()});
    }

    private DocumentPath getPathFor(DeviceId deviceId, FlowId flowId) {
        return DocumentPath.from((String[])new String[]{"root", deviceId.toString(), flowId.toString()});
    }

    public FlowEntry getFlowEntry(FlowRule rule) {
        DocumentPath path = this.getPathFor(rule.deviceId(), rule.id());
        Versioned flowEntries = this.flows.get(path);
        return flowEntries != null ? (FlowEntry)((Map)flowEntries.value()).get(rule) : null;
    }

    public Iterable<FlowEntry> getFlowEntries(DeviceId deviceId) {
        DocumentPath path = this.getPathFor(deviceId);
        try {
            return this.getFlowEntries(path);
        }
        catch (NoSuchDocumentPathException e) {
            return Collections.emptyList();
        }
    }

    private Iterable<FlowEntry> getFlowEntries(DocumentPath path) {
        return this.flows.getChildren(path).values().stream().flatMap(v -> ((Map)v.value()).values().stream()).collect(Collectors.toList());
    }

    public void storeFlowRule(FlowRule rule) {
        this.storeBatch(new FlowRuleBatchOperation(Collections.singletonList(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, rule)), rule.deviceId(), this.idGenerator.getNewId()));
    }

    public void storeBatch(FlowRuleBatchOperation operation) {
        if (operation.getOperations().isEmpty()) {
            this.notifyDelegate((Event)FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), operation.deviceId())));
            return;
        }
        DeviceId deviceId = operation.deviceId();
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        if (master == null) {
            this.log.warn("No master for {} ", (Object)deviceId);
            this.updateStoreInternal(operation).whenComplete((result, error) -> this.notifyDelegate((Event)FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), operation.deviceId()))));
            return;
        }
        this.pendingBatches.add(operation.id());
        if (Objects.equals(this.local, master)) {
            this.applyBatchFlows(operation);
        } else {
            this.log.trace("Forwarding storeBatch to {}, which is the primary (master) for device {}", (Object)master, (Object)deviceId);
            this.clusterCommunicator.unicast((Object)operation, APPLY_BATCH_FLOWS, arg_0 -> ((Serializer)this.serializer).encode(arg_0), master);
        }
    }

    private void applyBatchFlows(FlowRuleBatchOperation operation) {
        this.updateStoreInternal(operation).whenComplete((operations, error) -> {
            if (error == null) {
                if (operations.isEmpty()) {
                    this.batchOperationComplete(FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), operation.deviceId())));
                } else {
                    this.notifyDelegate((Event)FlowRuleBatchEvent.requested((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), operations), (DeviceId)operation.deviceId()));
                }
            }
        });
    }

    private CompletableFuture<Set<FlowRuleBatchEntry>> updateStoreInternal(FlowRuleBatchOperation operation) {
        return Tools.allOf(operation.getOperations().stream().map(op -> {
            switch ((FlowRuleBatchEntry.FlowRuleOperation)op.operator()) {
                case ADD: 
                case MODIFY: {
                    return this.addBatchEntry((FlowRuleBatchEntry)op).thenApply(succeeded -> succeeded != false ? op : null);
                }
                case REMOVE: {
                    return this.removeBatchEntry((FlowRuleBatchEntry)op).thenApply(succeeded -> succeeded != false ? op : null);
                }
            }
            this.log.warn("Unknown flow operation operator: {}", (Object)op.operator());
            return CompletableFuture.completedFuture(null);
        }).collect(Collectors.toList())).thenApply(results -> results.stream().filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    private CompletableFuture<Boolean> addBatchEntry(FlowRuleBatchEntry batchEntry) {
        DefaultFlowEntry entry = new DefaultFlowEntry((FlowRule)batchEntry.target());
        DocumentPath path = this.getPathFor(entry.deviceId(), entry.id());
        return this.retryAsyncUntilSuccess(() -> this.lambda$addBatchEntry$15(path, (StoredFlowEntry)entry));
    }

    private CompletableFuture<Boolean> removeBatchEntry(FlowRuleBatchEntry batchEntry) {
        FlowRule rule = (FlowRule)batchEntry.target();
        DocumentPath path = this.getPathFor(rule.deviceId(), rule.id());
        return this.retryAsyncUntilSuccess(() -> {
            CompletableFuture future = new CompletableFuture();
            this.asyncFlows.get(path).whenComplete((value, getError) -> {
                if (getError == null) {
                    if (value != null) {
                        HashMap entries = Maps.newHashMap((Map)((Map)value.value()));
                        StoredFlowEntry entry = (StoredFlowEntry)entries.get(rule);
                        if (entry != null) {
                            entry.setState(FlowEntry.FlowEntryState.PENDING_REMOVE);
                            this.asyncFlows.replace(path, (Object)entries, value.version()).whenComplete((succeeded, error) -> {
                                if (error == null) {
                                    if (succeeded.booleanValue()) {
                                        this.log.trace("Updated flow rule state to PENDING_REMOVE: {}", (Object)entry);
                                        future.complete(true);
                                    } else {
                                        this.log.trace("Failed to update flow rule state to PENDING_REMOVE: {}", (Object)entry);
                                        future.completeExceptionally((Throwable)RETRY);
                                    }
                                } else {
                                    future.completeExceptionally((Throwable)error);
                                }
                            });
                        } else {
                            future.complete(false);
                        }
                    } else {
                        future.complete(false);
                    }
                } else {
                    future.completeExceptionally((Throwable)getError);
                }
            });
            return future;
        });
    }

    public void batchOperationComplete(FlowRuleBatchEvent event) {
        if (this.pendingBatches.remove(((FlowRuleBatchRequest)event.subject()).batchId())) {
            this.notifyDelegate((Event)event);
        } else {
            this.clusterCommunicator.broadcast((Object)event, COMPLETE_BATCH, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
        }
    }

    public void deleteFlowRule(FlowRule rule) {
        this.storeBatch(new FlowRuleBatchOperation(Collections.singletonList(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.REMOVE, rule)), rule.deviceId(), this.idGenerator.getNewId()));
    }

    public FlowRuleEvent pendingFlowRule(FlowEntry rule) {
        DocumentPath path = this.getPathFor(rule.deviceId(), rule.id());
        return this.retryUntilSuccess(() -> {
            Versioned value = this.flows.get(path);
            if (value != null) {
                HashMap entries = Maps.newHashMap((Map)((Map)value.value()));
                StoredFlowEntry entry = (StoredFlowEntry)entries.get(rule);
                if (entry != null && entry.state() != FlowEntry.FlowEntryState.PENDING_ADD) {
                    entry.setState(FlowEntry.FlowEntryState.PENDING_ADD);
                    if (this.flows.replace(path, (Object)entries, value.version())) {
                        this.log.trace("Updated flow rule state to PENDING_ADD: {}", (Object)entry);
                        return new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
                    }
                    this.log.trace("Failed to update flow rule state to PENDING_ADD: {}", (Object)entry);
                    return (FlowRuleEvent)this.retry();
                }
                return null;
            }
            return null;
        });
    }

    public FlowRuleEvent addOrUpdateFlowRule(FlowEntry rule) {
        DocumentPath path = this.getPathFor(rule.deviceId(), rule.id());
        return this.retryUntilSuccess(() -> {
            Versioned value = this.flows.get(path);
            if (value != null) {
                HashMap entries = Maps.newHashMap((Map)((Map)value.value()));
                StoredFlowEntry entry = (StoredFlowEntry)entries.get(rule);
                if (entry != null) {
                    String message;
                    FlowRuleEvent event;
                    entry.setBytes(rule.bytes());
                    entry.setLife(rule.life(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                    entry.setLiveType(rule.liveType());
                    entry.setPackets(rule.packets());
                    entry.setLastSeen();
                    if (entry.state() == FlowEntry.FlowEntryState.PENDING_ADD) {
                        entry.setState(FlowEntry.FlowEntryState.ADDED);
                        event = new FlowRuleEvent(FlowRuleEvent.Type.RULE_ADDED, (FlowRule)rule);
                        message = "Updated flow rule state to ADDED: {}";
                    } else {
                        event = new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
                        message = "Updated flow rule: {}";
                    }
                    if (this.flows.replace(path, (Object)entries, value.version())) {
                        this.log.trace(message, (Object)entry);
                        return event;
                    }
                    this.log.trace("Failed to update flow rule: {}", (Object)entry);
                    return (FlowRuleEvent)this.retry();
                }
                return null;
            }
            return null;
        });
    }

    public FlowRuleEvent removeFlowRule(FlowEntry rule) {
        DocumentPath path = this.getPathFor(rule.deviceId(), rule.id());
        return this.retryUntilSuccess(() -> {
            Versioned value = this.flows.get(path);
            if (value != null) {
                HashMap entries = Maps.newHashMap((Map)((Map)value.value()));
                StoredFlowEntry entry = (StoredFlowEntry)entries.remove(rule);
                if (entry != null) {
                    if (this.flows.replace(path, (Object)entries, value.version())) {
                        this.log.trace("Removed flow rule: {}", (Object)entry);
                        return new FlowRuleEvent(FlowRuleEvent.Type.RULE_REMOVED, (FlowRule)entry);
                    }
                    this.log.trace("Failed to remove flow rule: {}", (Object)entry);
                    return (FlowRuleEvent)this.retry();
                }
                return null;
            }
            return null;
        });
    }

    public void purgeFlowRule(DeviceId deviceId) {
        DocumentPath path = this.getPathFor(deviceId);
        this.retryUntilSuccess(() -> {
            try {
                for (String flowId : this.flows.getChildren(path).keySet()) {
                    this.flows.removeNode(DocumentPath.from((String[])new String[]{"root", deviceId.toString(), flowId}));
                }
            }
            catch (NoSuchDocumentPathException noSuchDocumentPathException) {
                // empty catch block
            }
            try {
                this.flows.removeNode(path);
            }
            catch (NoSuchDocumentPathException e) {
                return null;
            }
            catch (IllegalDocumentModificationException e) {
                return this.retry();
            }
            return null;
        });
    }

    public void purgeFlowRules() {
        try {
            for (String deviceId : this.flows.getChildren(this.flows.root()).keySet()) {
                this.purgeFlowRule(DeviceId.deviceId((String)deviceId));
            }
        }
        catch (NoSuchDocumentPathException noSuchDocumentPathException) {
            // empty catch block
        }
    }

    public FlowRuleEvent updateTableStatistics(DeviceId deviceId, List<TableStatisticsEntry> tableStats) {
        this.deviceTableStats.put((Object)deviceId, tableStats);
        return null;
    }

    public Iterable<TableStatisticsEntry> getTableStatistics(DeviceId deviceId) {
        List tableStats = (List)this.deviceTableStats.get((Object)deviceId);
        if (tableStats == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Collection)tableStats);
    }

    public long getActiveFlowRuleCount(DeviceId deviceId) {
        return Streams.stream(this.getTableStatistics(deviceId)).mapToLong(TableStatisticsEntry::activeFlowEntries).sum();
    }

    private /* synthetic */ CompletableFuture lambda$addBatchEntry$15(DocumentPath path, StoredFlowEntry entry) {
        CompletableFuture future = new CompletableFuture();
        this.asyncFlows.get(path).whenComplete((value, getError) -> {
            if (getError == null) {
                if (value != null) {
                    HashMap entries = Maps.newHashMap((Map)((Map)value.value()));
                    entries.put(entry, entry);
                    this.asyncFlows.replace(path, (Object)entries, value.version()).whenComplete((succeeded, replaceError) -> {
                        if (replaceError == null) {
                            if (succeeded.booleanValue()) {
                                this.log.trace("Stored new flow rule: {}", (Object)entry);
                                future.complete(true);
                            } else {
                                this.log.trace("Failed to store new flow rule: {}", (Object)entry);
                                future.completeExceptionally((Throwable)RETRY);
                            }
                        } else {
                            future.completeExceptionally((Throwable)replaceError);
                        }
                    });
                } else {
                    HashMap map = Maps.newHashMap();
                    map.put(entry, entry);
                    this.asyncFlows.createRecursive(path, (Object)map).whenComplete((succeeded, createError) -> {
                        if (createError == null) {
                            if (succeeded.booleanValue()) {
                                this.log.trace("Stored new flow rule: {}", (Object)entry);
                                future.complete(true);
                            } else {
                                this.log.trace("Failed to store new flow rule: {}", (Object)entry);
                                future.completeExceptionally((Throwable)RETRY);
                            }
                        } else {
                            future.completeExceptionally((Throwable)createError);
                        }
                    });
                }
            } else {
                future.completeExceptionally((Throwable)getError);
            }
        });
        return future;
    }

    private /* synthetic */ CompletableFuture lambda$null$1(Supplier supplier, CompletableFuture future) throws Exception {
        return this.retryAsyncUntilSuccess(supplier, future);
    }

    static {
        RETRY.setStackTrace(new StackTraceElement[0]);
        APPLY_BATCH_FLOWS = new MessageSubject("onos-flow-apply");
        COMPLETE_BATCH = new MessageSubject("onos-flow-batch-complete");
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalTableStatsListener
    implements EventuallyConsistentMapListener<DeviceId, List<TableStatisticsEntry>> {
        private InternalTableStatsListener() {
        }

        public void event(EventuallyConsistentMapEvent<DeviceId, List<TableStatisticsEntry>> event) {
        }
    }
}

