/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import org.onosproject.core.HybridLogicalTime;

public abstract class InternalMessage {
    private final int preamble;
    private final HybridLogicalTime time;
    private final long id;
    private final byte[] payload;

    protected InternalMessage(int preamble, HybridLogicalTime time, long id, byte[] payload) {
        this.preamble = preamble;
        this.time = time;
        this.id = id;
        this.payload = payload;
    }

    public abstract Type type();

    public boolean isRequest() {
        return this.type() == Type.REQUEST;
    }

    public boolean isReply() {
        return this.type() == Type.REPLY;
    }

    public HybridLogicalTime time() {
        return this.time;
    }

    public int preamble() {
        return this.preamble;
    }

    public long id() {
        return this.id;
    }

    public byte[] payload() {
        return this.payload;
    }

    public static enum Type {
        REQUEST(1),
        REPLY(2);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Type forId(int id) {
            switch (id) {
                case 1: {
                    return REQUEST;
                }
                case 2: {
                    return REPLY;
                }
            }
            throw new IllegalArgumentException("Unknown status ID " + id);
        }
    }
}

