/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.pi.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiPipeconfId;
import org.onosproject.net.pi.runtime.PiPipeconfDeviceMappingEvent;
import org.onosproject.net.pi.runtime.PiPipeconfMappingStore;
import org.onosproject.net.pi.runtime.PiPipeconfMappingStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedDevicePipeconfMappingStore
extends AbstractStore<PiPipeconfDeviceMappingEvent, PiPipeconfMappingStoreDelegate>
implements PiPipeconfMappingStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    protected EventuallyConsistentMap<DeviceId, PiPipeconfId> deviceToPipeconf;
    protected final EventuallyConsistentMapListener<DeviceId, PiPipeconfId> pipeconfListener = new InternalPiPipeconfListener();
    protected ConcurrentMap<PiPipeconfId, Set<DeviceId>> pipeconfToDevices = new ConcurrentHashMap<PiPipeconfId, Set<DeviceId>>();

    @Activate
    public void activate() {
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class});
        this.deviceToPipeconf = this.storageService.eventuallyConsistentMapBuilder().withName("onos-pipeconf-table").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.deviceToPipeconf.addListener(this.pipeconfListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceToPipeconf.removeListener(this.pipeconfListener);
        this.deviceToPipeconf = null;
        this.pipeconfToDevices = null;
        this.log.info("Stopped");
    }

    public PiPipeconfId getPipeconfId(DeviceId deviceId) {
        return (PiPipeconfId)this.deviceToPipeconf.get((Object)deviceId);
    }

    public Set<DeviceId> getDevices(PiPipeconfId pipeconfId) {
        return (Set)this.pipeconfToDevices.get(pipeconfId);
    }

    public void createOrUpdateBinding(DeviceId deviceId, PiPipeconfId pipeconfId) {
        this.deviceToPipeconf.put((Object)deviceId, (Object)pipeconfId);
    }

    public void removeBinding(DeviceId deviceId) {
        this.deviceToPipeconf.remove((Object)deviceId);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalPiPipeconfListener
    implements EventuallyConsistentMapListener<DeviceId, PiPipeconfId> {
        private InternalPiPipeconfListener() {
        }

        public void event(EventuallyConsistentMapEvent<DeviceId, PiPipeconfId> mapEvent) {
            PiPipeconfDeviceMappingEvent.Type type;
            DeviceId deviceId = (DeviceId)mapEvent.key();
            PiPipeconfId pipeconfId = (PiPipeconfId)mapEvent.value();
            switch (mapEvent.type()) {
                case PUT: {
                    type = PiPipeconfDeviceMappingEvent.Type.CREATED;
                    DistributedDevicePipeconfMappingStore.this.pipeconfToDevices.compute(pipeconfId, (pipeconf, devices) -> {
                        if (devices == null) {
                            devices = Sets.newConcurrentHashSet();
                        }
                        devices.add(deviceId);
                        return devices;
                    });
                    break;
                }
                case REMOVE: {
                    type = PiPipeconfDeviceMappingEvent.Type.REMOVED;
                    DistributedDevicePipeconfMappingStore.this.pipeconfToDevices.computeIfPresent(pipeconfId, (pipeconf, devices) -> {
                        devices.remove(deviceId);
                        return devices;
                    });
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong event type " + mapEvent.type());
                }
            }
            DistributedDevicePipeconfMappingStore.this.notifyDelegate((Event)new PiPipeconfDeviceMappingEvent(type, deviceId));
        }
    }
}

