/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.mcast.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.onosproject.net.ConnectPoint;

public final class MulticastData {
    private final AtomicReference<ConnectPoint> source = new AtomicReference();
    private final Map<ConnectPoint, Boolean> sinks;
    private final AtomicBoolean isEmpty = new AtomicBoolean();

    private MulticastData() {
        this.sinks = Maps.newConcurrentMap();
        this.isEmpty.set(true);
    }

    public MulticastData(ConnectPoint source) {
        this.source.set((ConnectPoint)Preconditions.checkNotNull((Object)source, (Object)"Multicast source cannot be null."));
        this.sinks = Maps.newConcurrentMap();
        this.isEmpty.set(false);
    }

    public ConnectPoint source() {
        return this.source.get();
    }

    public Set<ConnectPoint> sinks() {
        return ImmutableSet.copyOf(this.sinks.keySet());
    }

    public void setSource(ConnectPoint source) {
        this.isEmpty.set(false);
        this.source.set(source);
    }

    public void appendSink(ConnectPoint sink) {
        Preconditions.checkNotNull((Object)sink);
        this.sinks.put(sink, true);
    }

    public void removeSink(ConnectPoint sink) {
        Preconditions.checkNotNull((Object)sink);
        this.sinks.remove(sink);
    }

    public boolean isEmpty() {
        return this.isEmpty.get();
    }

    public static MulticastData empty() {
        return new MulticastData();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source, this.sinks, this.isEmpty);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MulticastData)) {
            return false;
        }
        MulticastData other = (MulticastData)obj;
        return super.equals(obj) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sinks(), other.sinks()) && Objects.equals(this.isEmpty, other.isEmpty);
    }
}

