/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.packet.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketEvent;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketRequest;
import org.onosproject.net.packet.PacketStore;
import org.onosproject.net.packet.PacketStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMultimap;
import org.onosproject.store.service.ConsistentMultimapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedPacketStore
extends AbstractStore<PacketEvent, PacketStoreDelegate>
implements PacketStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String FORMAT = "Setting: messageHandlerThreadPoolSize={}";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService communicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private PacketRequestTracker tracker;
    private static final MessageSubject PACKET_OUT_SUBJECT = new MessageSubject("packet-out");
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)KryoNamespaces.API);
    private ExecutorService messageHandlingExecutor;
    private static final int DEFAULT_MESSAGE_HANDLER_THREAD_POOL_SIZE = 4;
    @Property(name="messageHandlerThreadPoolSize", intValue={4}, label="Size of thread pool to assign message handler")
    private static int messageHandlerThreadPoolSize = 4;
    private static final int MAX_BACKOFF = 50;

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.modified(context);
        this.messageHandlingExecutor = Executors.newFixedThreadPool(messageHandlerThreadPoolSize, Tools.groupedThreads((String)"onos/store/packet", (String)"message-handlers", (Logger)this.log));
        this.communicationService.addSubscriber(PACKET_OUT_SUBJECT, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), packet -> this.notifyDelegate((Event)new PacketEvent(PacketEvent.Type.EMIT, packet)), (Executor)this.messageHandlingExecutor);
        this.tracker = new PacketRequestTracker();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.communicationService.removeSubscriber(PACKET_OUT_SUBJECT);
        this.messageHandlingExecutor.shutdown();
        this.tracker = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newMessageHandlerThreadPoolSize;
        Dictionary properties = context != null ? context.getProperties() : new Properties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"messageHandlerThreadPoolSize");
            newMessageHandlerThreadPoolSize = Strings.isNullOrEmpty((String)s) ? messageHandlerThreadPoolSize : Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            this.log.warn(e.getMessage());
            newMessageHandlerThreadPoolSize = messageHandlerThreadPoolSize;
        }
        if (newMessageHandlerThreadPoolSize != messageHandlerThreadPoolSize) {
            this.setMessageHandlerThreadPoolSize(newMessageHandlerThreadPoolSize);
            this.restartMessageHandlerThreadPool();
        }
        this.log.info(FORMAT, (Object)messageHandlerThreadPoolSize);
    }

    public void emit(OutboundPacket packet) {
        NodeId myId = this.clusterService.getLocalNode().id();
        NodeId master = this.mastershipService.getMasterFor(packet.sendThrough());
        if (master == null) {
            return;
        }
        if (myId.equals((Object)master)) {
            this.notifyDelegate((Event)new PacketEvent(PacketEvent.Type.EMIT, packet));
            return;
        }
        this.communicationService.unicast((Object)packet, PACKET_OUT_SUBJECT, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), master).whenComplete((r, error) -> {
            if (error != null) {
                this.log.warn("Failed to send packet-out to {}", (Object)master, error);
            }
        });
    }

    public void requestPackets(PacketRequest request) {
        this.tracker.add(request);
    }

    public void cancelPackets(PacketRequest request) {
        this.tracker.remove(request);
    }

    public List<PacketRequest> existingRequests() {
        return this.tracker.requests();
    }

    private static RequestKey key(PacketRequest request) {
        return new RequestKey(request.selector(), request.priority());
    }

    private void setMessageHandlerThreadPoolSize(int poolSize) {
        Preconditions.checkArgument((poolSize >= 0 ? 1 : 0) != 0, (Object)"Message handler pool size must be 0 or more");
        messageHandlerThreadPoolSize = poolSize;
    }

    private void restartMessageHandlerThreadPool() {
        ExecutorService prevExecutor = this.messageHandlingExecutor;
        this.messageHandlingExecutor = Executors.newFixedThreadPool(this.getMessageHandlerThreadPoolSize(), Tools.groupedThreads((String)"DistPktStore", (String)"messageHandling-%d", (Logger)this.log));
        prevExecutor.shutdown();
    }

    private int getMessageHandlerThreadPoolSize() {
        return messageHandlerThreadPoolSize;
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        this.communicationService = clusterCommunicationService;
    }

    protected void unbindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        if (this.communicationService == clusterCommunicationService) {
            this.communicationService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private static final class RequestKey {
        private final TrafficSelector selector;
        private final PacketPriority priority;

        private RequestKey(TrafficSelector selector, PacketPriority priority) {
            this.selector = selector;
            this.priority = priority;
        }

        public int hashCode() {
            return Objects.hash(this.selector, this.priority);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof RequestKey)) {
                return false;
            }
            RequestKey that = (RequestKey)other;
            return Objects.equals(this.selector, that.selector) && Objects.equals(this.priority, that.priority);
        }
    }

    private final class PacketRequestTracker {
        private ConsistentMultimap<RequestKey, PacketRequest> requests;

        private PacketRequestTracker() {
            this.requests = (ConsistentMultimap)((ConsistentMultimapBuilder)((ConsistentMultimapBuilder)DistributedPacketStore.this.storageService.consistentMultimapBuilder().withName("onos-packet-requests")).withSerializer(Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{RequestKey.class}).build()))).build();
        }

        private void add(PacketRequest request) {
            boolean firstRequest = this.addInternal(request);
            if (firstRequest && DistributedPacketStore.this.delegate != null) {
                ((PacketStoreDelegate)DistributedPacketStore.this.delegate).requestPackets(request);
            }
        }

        private boolean addInternal(PacketRequest request) {
            Collection values = (Collection)Versioned.valueOrNull((Versioned)this.requests.putAndGet((Object)DistributedPacketStore.key(request), (Object)request));
            return values.size() == 1;
        }

        private void remove(PacketRequest request) {
            boolean removedLast = this.removeInternal(request);
            if (removedLast && DistributedPacketStore.this.delegate != null) {
                ((PacketStoreDelegate)DistributedPacketStore.this.delegate).cancelPackets(request);
            }
        }

        private boolean removeInternal(PacketRequest request) {
            Collection values = (Collection)Versioned.valueOrNull((Versioned)this.requests.removeAndGet((Object)DistributedPacketStore.key(request), (Object)request));
            return values == null || values.isEmpty();
        }

        private List<PacketRequest> requests() {
            ArrayList list = Lists.newArrayList();
            this.requests.values().forEach(v -> list.add(v));
            list.sort((o1, o2) -> o1.priority().priorityValue() - o2.priority().priorityValue());
            return list;
        }
    }
}

