/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.pi.impl;

import com.google.common.base.Preconditions;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.event.Event;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.service.PiTranslatable;
import org.onosproject.net.pi.service.PiTranslatedEntity;
import org.onosproject.net.pi.service.PiTranslationEvent;
import org.onosproject.net.pi.service.PiTranslationStore;
import org.onosproject.net.pi.service.PiTranslationStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public abstract class AbstractDistributedPiTranslationStore<T extends PiTranslatable, E extends PiEntity>
extends AbstractStore<PiTranslationEvent<T, E>, PiTranslationStoreDelegate<T, E>>
implements PiTranslationStore<T, E> {
    private static final String MAP_NAME_TEMPLATE = "onos-pi-translated-%s-map";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private EventuallyConsistentMap<PiHandle<E>, PiTranslatedEntity<T, E>> translatedEntities;
    private final EventuallyConsistentMapListener<PiHandle<E>, PiTranslatedEntity<T, E>> entityMapListener = new InternalEntityMapListener();

    protected abstract String mapSimpleName();

    @Activate
    public void activate() {
        String fullMapName = String.format(MAP_NAME_TEMPLATE, this.mapSimpleName());
        this.translatedEntities = this.storageService.eventuallyConsistentMapBuilder().withName(fullMapName).withSerializer(KryoNamespaces.API).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.translatedEntities.addListener(this.entityMapListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.translatedEntities.removeListener(this.entityMapListener);
        this.translatedEntities = null;
        this.log.info("Stopped");
    }

    public void addOrUpdate(PiHandle<E> handle, PiTranslatedEntity<T, E> entity) {
        Preconditions.checkNotNull(handle);
        Preconditions.checkNotNull(entity);
        Preconditions.checkArgument((boolean)handle.entityType().equals((Object)entity.entityType()), (Object)"Entity type must be the same for handle and translated entity");
        this.translatedEntities.put(handle, entity);
    }

    public void remove(PiHandle<E> handle) {
        Preconditions.checkNotNull(handle);
        this.translatedEntities.remove(handle);
    }

    public PiTranslatedEntity<T, E> get(PiHandle<E> handle) {
        Preconditions.checkNotNull(handle);
        return (PiTranslatedEntity)this.translatedEntities.get(handle);
    }

    public Iterable<PiTranslatedEntity<T, E>> getAll() {
        return this.translatedEntities.values();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalEntityMapListener
    implements EventuallyConsistentMapListener<PiHandle<E>, PiTranslatedEntity<T, E>> {
        private InternalEntityMapListener() {
        }

        public void event(EventuallyConsistentMapEvent<PiHandle<E>, PiTranslatedEntity<T, E>> event) {
            PiTranslationEvent.Type type;
            switch (event.type()) {
                case PUT: {
                    type = PiTranslationEvent.Type.LEARNED;
                    break;
                }
                case REMOVE: {
                    type = PiTranslationEvent.Type.FORGOT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown event type " + event.type().name());
                }
            }
            AbstractDistributedPiTranslationStore.this.notifyDelegate((Event)new PiTranslationEvent(type, (PiTranslatedEntity)event.value()));
        }
    }
}

