/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.Codecs;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.EmptyDiscreteResources;
import org.onosproject.store.resource.impl.EncodableDiscreteResources;
import org.onosproject.store.resource.impl.GenericDiscreteResources;

final class UnifiedDiscreteResources
implements DiscreteResources {
    private final DiscreteResources generics;
    private final DiscreteResources encodables;
    private static final Codecs CODECS = Codecs.getInstance();

    static DiscreteResources of(Set<DiscreteResource> resources) {
        if (resources.isEmpty()) {
            return DiscreteResources.empty();
        }
        Map<Boolean, Set> partitioned = resources.stream().collect(Collectors.partitioningBy(CODECS::isEncodable, Collectors.toCollection(LinkedHashSet::new)));
        return new UnifiedDiscreteResources(GenericDiscreteResources.of(partitioned.get(false)), EncodableDiscreteResources.of(partitioned.get(true)));
    }

    private UnifiedDiscreteResources(DiscreteResources generics, DiscreteResources encodables) {
        this.generics = generics;
        this.encodables = encodables;
    }

    @Override
    public Optional<DiscreteResource> lookup(DiscreteResourceId id) {
        if (CODECS.isEncodable(Resources.discrete((DiscreteResourceId)id).resource())) {
            return this.encodables.lookup(id);
        }
        return this.generics.lookup(id);
    }

    @Override
    public DiscreteResources difference(DiscreteResources other) {
        if (other instanceof UnifiedDiscreteResources) {
            UnifiedDiscreteResources cast = (UnifiedDiscreteResources)other;
            return new UnifiedDiscreteResources(this.generics.difference(cast.generics), this.encodables.difference(cast.encodables));
        }
        if (other instanceof EmptyDiscreteResources) {
            return this;
        }
        return UnifiedDiscreteResources.of((Set<DiscreteResource>)Sets.difference(this.values(), other.values()));
    }

    @Override
    public boolean isEmpty() {
        return this.generics.isEmpty() && this.encodables.isEmpty();
    }

    @Override
    public boolean containsAny(Set<DiscreteResource> other) {
        Map<Boolean, Set> partitioned = other.stream().collect(Collectors.partitioningBy(CODECS::isEncodable, Collectors.toCollection(LinkedHashSet::new)));
        return this.generics.containsAny(partitioned.get(false)) || this.encodables.containsAny(partitioned.get(true));
    }

    @Override
    public DiscreteResources add(DiscreteResources other) {
        if (other instanceof UnifiedDiscreteResources) {
            UnifiedDiscreteResources cast = (UnifiedDiscreteResources)other;
            return new UnifiedDiscreteResources(this.generics.add(cast.generics), this.encodables.add(cast.encodables));
        }
        if (other instanceof EmptyDiscreteResources) {
            return this;
        }
        return UnifiedDiscreteResources.of((Set<DiscreteResource>)Sets.union(this.values(), other.values()));
    }

    @Override
    public Set<DiscreteResource> values() {
        return Stream.concat(this.encodables.values().stream(), this.generics.values().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public <T> Set<DiscreteResource> valuesOf(Class<T> cls) {
        return Stream.concat(this.encodables.valuesOf(cls).stream(), this.generics.valuesOf(cls).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public int hashCode() {
        return Objects.hash(this.generics, this.encodables);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnifiedDiscreteResources other = (UnifiedDiscreteResources)obj;
        return Objects.equals(this.generics, other.generics) && Objects.equals(this.encodables, other.encodables);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values()).toString();
    }
}

