/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.onosproject.cluster.NodeId;

public class PhiAccrualFailureDetector {
    private final Map<NodeId, NodeFailureDetector> nodes = Maps.newConcurrentMap();
    private static final int DEFAULT_WINDOW_SIZE = 250;
    private static final int DEFAULT_MIN_SAMPLES = 25;
    private static final long DEFAULT_MIN_STANDARD_DEVIATION_MILLIS = 50L;
    private static final double DEFAULT_BOOTSTRAP_PHI_VALUE = 100.0;
    private final int minSamples;
    private final long minStandardDeviationMillis;
    private final double bootstrapPhiValue = 100.0;

    public PhiAccrualFailureDetector() {
        this(25, 50L);
    }

    public PhiAccrualFailureDetector(long minStandardDeviationMillis) {
        this(25, minStandardDeviationMillis);
    }

    public PhiAccrualFailureDetector(int minSamples, long minStandardDeviationMillis) {
        Preconditions.checkArgument((minSamples > 0 ? 1 : 0) != 0, (Object)"minSamples must be positive");
        Preconditions.checkArgument((minStandardDeviationMillis > 0L ? 1 : 0) != 0, (Object)"minStandardDeviationMillis must be positive");
        this.minSamples = minSamples;
        this.minStandardDeviationMillis = minStandardDeviationMillis;
    }

    public Long getLastHeartbeatTime(NodeId nodeId) {
        NodeFailureDetector node = this.nodes.get(nodeId);
        return node != null ? Long.valueOf(node.lastHeartbeatTime()) : null;
    }

    public void report(NodeId nodeId) {
        this.report(nodeId, System.currentTimeMillis());
    }

    public void report(NodeId nodeId, long arrivalTime) {
        Preconditions.checkNotNull((Object)nodeId, (Object)"NodeId must not be null");
        Preconditions.checkArgument((arrivalTime >= 0L ? 1 : 0) != 0, (Object)"arrivalTime must not be negative");
        NodeFailureDetector node = this.nodes.get(nodeId);
        if (node == null) {
            this.nodes.computeIfAbsent(nodeId, key -> new NodeFailureDetector());
        } else {
            node.setLastHeartbeatTime(arrivalTime);
        }
    }

    public void reset(NodeId nodeId) {
        this.nodes.remove(nodeId);
    }

    public double phi(NodeId nodeId) {
        return this.phi(nodeId, System.currentTimeMillis());
    }

    public double phi(NodeId nodeId, long currentTime) {
        Preconditions.checkNotNull((Object)nodeId, (Object)"NodeId must not be null");
        NodeFailureDetector node = this.nodes.get(nodeId);
        if (node == null) {
            return 100.0;
        }
        return node.computePhi(currentTime);
    }

    private class NodeFailureDetector {
        private final DescriptiveStatistics samples = new DescriptiveStatistics(250);
        private volatile long lastHeartbeatTime = System.currentTimeMillis();

        private NodeFailureDetector() {
        }

        long lastHeartbeatTime() {
            return this.lastHeartbeatTime;
        }

        synchronized void setLastHeartbeatTime(long heartbeatTime) {
            this.samples.addValue((double)(heartbeatTime - this.lastHeartbeatTime));
            this.lastHeartbeatTime = heartbeatTime;
        }

        synchronized double computePhi(long currentTime) {
            if (this.samples.getN() < (long)PhiAccrualFailureDetector.this.minSamples) {
                return 0.0;
            }
            long elapsedTime = currentTime - this.lastHeartbeatTime;
            double meanMillis = this.samples.getMean();
            double standardDeviation = this.samples.getStandardDeviation();
            double y = ((double)elapsedTime - meanMillis) / Math.max(standardDeviation, (double)PhiAccrualFailureDetector.this.minStandardDeviationMillis);
            double e = Math.exp(-y * (1.5976 + 0.070566 * y * y));
            if ((double)elapsedTime > meanMillis) {
                return -Math.log10(e / (1.0 + e));
            }
            return -Math.log10(1.0 - 1.0 / (1.0 + e));
        }
    }
}

