/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cfg;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cfg.ComponentConfigEvent;
import org.onosproject.cfg.ComponentConfigStore;
import org.onosproject.cfg.ComponentConfigStoreDelegate;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedComponentConfigStore
extends AbstractStore<ComponentConfigEvent, ComponentConfigStoreDelegate>
implements ComponentConfigStore {
    private static final String SEP = "#";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ConsistentMap<String, String> properties;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private InternalPropertiesListener propertiesListener = new InternalPropertiesListener();

    @Activate
    public void activate() {
        this.properties = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-component-cfg")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).withRelaxedReadConsistency()).build();
        this.properties.addListener((MapEventListener)this.propertiesListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.properties.removeListener((MapEventListener)this.propertiesListener);
        this.log.info("Stopped");
    }

    public void setProperty(String componentName, String name, String value) {
        this.properties.put((Object)this.key(componentName, name), (Object)value);
    }

    public void unsetProperty(String componentName, String name) {
        this.properties.remove((Object)this.key(componentName, name));
    }

    public Set<String> getProperties(String componentName) {
        ImmutableSet.Builder names = ImmutableSet.builder();
        this.properties.keySet().stream().filter(k -> Objects.equals(componentName, k.substring(0, k.indexOf(SEP)))).map(k -> k.substring(k.indexOf(SEP) + 1)).forEach(arg_0 -> ((ImmutableSet.Builder)names).add(arg_0));
        return names.build();
    }

    public String getProperty(String componentName, String name) {
        Versioned v = this.properties.get((Object)this.key(componentName, name));
        return v != null ? (String)v.value() : null;
    }

    private String key(String componentName, String name) {
        return componentName + SEP + name;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private final class InternalPropertiesListener
    implements MapEventListener<String, String> {
        private InternalPropertiesListener() {
        }

        public void event(MapEvent<String, String> event) {
            String[] keys = ((String)event.key()).split(DistributedComponentConfigStore.SEP);
            if (event.type() == MapEvent.Type.INSERT || event.type() == MapEvent.Type.UPDATE) {
                String value = (String)event.newValue().value();
                DistributedComponentConfigStore.this.notifyDelegate((Event)new ComponentConfigEvent(ComponentConfigEvent.Type.PROPERTY_SET, keys[0], keys[1], value));
            } else if (event.type() == MapEvent.Type.REMOVE) {
                DistributedComponentConfigStore.this.notifyDelegate((Event)new ComponentConfigEvent(ComponentConfigEvent.Type.PROPERTY_UNSET, keys[0], keys[1], null));
            }
        }
    }
}

