/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import org.onlab.packet.IpAddress;
import org.onosproject.core.HybridLogicalTime;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.impl.DecoderState;
import org.onosproject.store.cluster.messaging.impl.InternalMessage;
import org.onosproject.store.cluster.messaging.impl.InternalReply;
import org.onosproject.store.cluster.messaging.impl.InternalRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDecoder
extends ReplayingDecoder<DecoderState> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IpAddress.Version ipVersion;
    private IpAddress senderIp;
    private int senderPort;
    private InternalMessage.Type type;
    private int preamble;
    private long logicalTime;
    private long logicalCounter;
    private long messageId;
    private int contentLength;
    private byte[] content;
    private int subjectLength;
    private String subject;
    private InternalReply.Status status;

    public MessageDecoder() {
        super((Object)DecoderState.READ_SENDER_IP_VERSION);
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> out) throws Exception {
        block0 : switch ((DecoderState)((Object)this.state())) {
            case READ_SENDER_IP_VERSION: {
                this.ipVersion = buffer.readByte() == 0 ? IpAddress.Version.INET : IpAddress.Version.INET6;
                this.checkpoint((Object)DecoderState.READ_SENDER_IP);
            }
            case READ_SENDER_IP: {
                byte[] octets = new byte[IpAddress.byteLength((IpAddress.Version)this.ipVersion)];
                buffer.readBytes(octets);
                this.senderIp = IpAddress.valueOf((IpAddress.Version)this.ipVersion, (byte[])octets);
                this.checkpoint((Object)DecoderState.READ_SENDER_PORT);
            }
            case READ_SENDER_PORT: {
                this.senderPort = buffer.readInt();
                this.checkpoint((Object)DecoderState.READ_TYPE);
            }
            case READ_TYPE: {
                this.type = InternalMessage.Type.forId(buffer.readByte());
                this.checkpoint((Object)DecoderState.READ_PREAMBLE);
            }
            case READ_PREAMBLE: {
                this.preamble = buffer.readInt();
                this.checkpoint((Object)DecoderState.READ_LOGICAL_TIME);
            }
            case READ_LOGICAL_TIME: {
                this.logicalTime = buffer.readLong();
                this.checkpoint((Object)DecoderState.READ_LOGICAL_COUNTER);
            }
            case READ_LOGICAL_COUNTER: {
                this.logicalCounter = buffer.readLong();
                this.checkpoint((Object)DecoderState.READ_MESSAGE_ID);
            }
            case READ_MESSAGE_ID: {
                this.messageId = buffer.readLong();
                this.checkpoint((Object)DecoderState.READ_CONTENT_LENGTH);
            }
            case READ_CONTENT_LENGTH: {
                this.contentLength = buffer.readInt();
                this.checkpoint((Object)DecoderState.READ_CONTENT);
            }
            case READ_CONTENT: {
                if (this.contentLength > 0) {
                    this.content = new byte[this.contentLength];
                    buffer.readBytes(this.content);
                } else {
                    this.content = new byte[0];
                }
                switch (this.type) {
                    case REQUEST: {
                        this.checkpoint((Object)DecoderState.READ_SUBJECT_LENGTH);
                        break block0;
                    }
                    case REPLY: {
                        this.checkpoint((Object)DecoderState.READ_STATUS);
                        break block0;
                    }
                }
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
                break;
            }
        }
        block16 : switch (this.type) {
            case REQUEST: {
                switch ((DecoderState)((Object)this.state())) {
                    case READ_SUBJECT_LENGTH: {
                        this.subjectLength = buffer.readShort();
                        this.checkpoint((Object)DecoderState.READ_SUBJECT);
                    }
                    case READ_SUBJECT: {
                        byte[] messageTypeBytes = new byte[this.subjectLength];
                        buffer.readBytes(messageTypeBytes);
                        this.subject = new String(messageTypeBytes, Charsets.UTF_8);
                        InternalRequest message = new InternalRequest(this.preamble, new HybridLogicalTime(this.logicalTime, this.logicalCounter), this.messageId, new Endpoint(this.senderIp, this.senderPort), this.subject, this.content);
                        out.add(message);
                        this.checkpoint((Object)DecoderState.READ_TYPE);
                        break block16;
                    }
                }
                break;
            }
            case REPLY: {
                switch ((DecoderState)((Object)this.state())) {
                    case READ_STATUS: {
                        this.status = InternalReply.Status.forId(buffer.readByte());
                        InternalReply message = new InternalReply(this.preamble, new HybridLogicalTime(this.logicalTime, this.logicalCounter), this.messageId, this.content, this.status);
                        out.add(message);
                        this.checkpoint((Object)DecoderState.READ_TYPE);
                        break block16;
                    }
                }
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        this.log.error("Exception inside channel handling pipeline.", cause);
        context.close();
    }
}

