/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.onosproject.store.LogicalTimestamp;
import org.onosproject.store.flow.impl.Timestamped;

public final class LogicalClock {
    private final AtomicLong timestamp = new AtomicLong();

    public void tick(LogicalTimestamp timestamp) {
        this.timestamp.accumulateAndGet(timestamp.value(), (x, y) -> Math.max(x, y) + 1L);
    }

    public <T> Timestamped<T> timestamp(T value) {
        return new Timestamped<T>(value, this.getTimestamp());
    }

    public LogicalTimestamp getTimestamp() {
        return new LogicalTimestamp(this.timestamp.incrementAndGet());
    }
}

