/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.host.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.Host;
import org.onosproject.net.host.HostProbe;
import org.onosproject.net.host.ProbeMode;

class DefaultHostProbe
extends DefaultHost
implements HostProbe {
    private ConnectPoint connectPoint;
    private int retry;
    private ProbeMode mode;
    private MacAddress probeMac;

    DefaultHostProbe(Host host, ConnectPoint connectPoint, ProbeMode mode, MacAddress probeMac, int retry) {
        super(host.providerId(), host.id(), host.mac(), host.vlan(), host.locations(), host.ipAddresses(), host.configured(), new Annotations[0]);
        this.connectPoint = connectPoint;
        this.mode = mode;
        this.probeMac = probeMac;
        this.retry = retry;
    }

    public ConnectPoint connectPoint() {
        return this.connectPoint;
    }

    public int retry() {
        return this.retry;
    }

    public void decreaseRetry() {
        --this.retry;
    }

    public ProbeMode mode() {
        return this.mode;
    }

    public MacAddress probeMac() {
        return this.probeMac;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultHostProbe)) {
            return false;
        }
        DefaultHostProbe that = (DefaultHostProbe)((Object)o);
        return super.equals(o) && Objects.equals(this.connectPoint, that.connectPoint) && Objects.equals(this.retry, that.retry) && Objects.equals(this.mode, that.mode) && Objects.equals(this.probeMac, that.probeMac);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connectPoint, this.retry, this.mode, this.probeMac);
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("host", (Object)super.toString()).add("location", (Object)this.connectPoint).add("retry", this.retry).add("mode", (Object)this.mode).add("probeMac", (Object)this.probeMac).toString();
    }
}

