/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.codec.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.pi.model.PiPipeconf;

/**
 * Codec for PiPipeconf.
 */
public class PiPipeconfCodec extends JsonCodec<PiPipeconf> {

    private static final String ID = "id";
    private static final String BEHAVIORS = "behaviors";
    private static final String EXTENSIONS = "extensions";

    @Override
    public ObjectNode encode(PiPipeconf pipeconf, CodecContext context) {
        ObjectNode result = context.mapper().createObjectNode();
        result.put(ID, pipeconf.id().id());
        ArrayNode behaviors = result.putArray(BEHAVIORS);
        pipeconf.behaviours().forEach(behavior -> {
            behaviors.add(behavior.getSimpleName());
        });
        ArrayNode extensions = result.putArray(EXTENSIONS);
        Lists.newArrayList(PiPipeconf.ExtensionType.values()).forEach(extension -> {
            if (pipeconf.extension(extension).isPresent()) {
                extensions.add(extension.toString());
            }
        });
        return result;
    }
}
