/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.mastership.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipAdminService;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipInfo;
import org.onosproject.mastership.MastershipStore;
import org.onosproject.mastership.MastershipStoreDelegate;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ConsistentDeviceMastershipStore
extends AbstractStore<MastershipEvent, MastershipStoreDelegate>
implements MastershipStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipAdminService leadershipAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    private NodeId localNodeId;
    private static final MessageSubject ROLE_RELINQUISH_SUBJECT = new MessageSubject("mastership-store-device-role-relinquish");
    private static final Pattern DEVICE_MASTERSHIP_TOPIC_PATTERN = Pattern.compile("device:(.*)");
    private ExecutorService eventHandler;
    private ExecutorService messageHandlingExecutor;
    private ScheduledExecutorService transferExecutor;
    private final LeadershipEventListener leadershipEventListener = new InternalDeviceMastershipEventListener();
    private static final String NODE_ID_NULL = "Node ID cannot be null";
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final int WAIT_BEFORE_MASTERSHIP_HANDOFF_MILLIS = 3000;
    public static final Serializer SERIALIZER = Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MastershipRole.class}).register(new Class[]{MastershipEvent.class}).register(new Class[]{MastershipEvent.Type.class}).build("MastershipStore"));

    @Activate
    public void activate() {
        this.eventHandler = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/device/mastership", (String)"event-handler", (Logger)this.log));
        this.messageHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/device/mastership", (String)"message-handler", (Logger)this.log));
        this.transferExecutor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/store/device/mastership", (String)"mastership-transfer-executor", (Logger)this.log));
        this.clusterCommunicator.addSubscriber(ROLE_RELINQUISH_SUBJECT, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), this::relinquishLocalRole, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), (Executor)this.messageHandlingExecutor);
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.addListener((EventListener)this.leadershipEventListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(ROLE_RELINQUISH_SUBJECT);
        this.leadershipService.removeListener((EventListener)this.leadershipEventListener);
        this.messageHandlingExecutor.shutdown();
        this.transferExecutor.shutdown();
        this.eventHandler.shutdown();
        this.log.info("Stopped");
    }

    public CompletableFuture<MastershipRole> requestRole(DeviceId deviceId) {
        ImmutableList candidates;
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        Leadership leadership = this.leadershipService.runForLeadership(leadershipTopic);
        NodeId leader = leadership == null ? null : leadership.leaderNodeId();
        ImmutableList immutableList = candidates = leadership == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)leadership.candidates());
        MastershipRole role = Objects.equals(this.localNodeId, leader) ? MastershipRole.MASTER : (candidates.contains(this.localNodeId) ? MastershipRole.STANDBY : MastershipRole.NONE);
        return CompletableFuture.completedFuture(role);
    }

    public MastershipRole getRole(NodeId nodeId, DeviceId deviceId) {
        ImmutableList candidates;
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        Leadership leadership = this.leadershipService.getLeadership(leadershipTopic);
        NodeId leader = leadership == null ? null : leadership.leaderNodeId();
        ImmutableList immutableList = candidates = leadership == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)leadership.candidates());
        return Objects.equals(nodeId, leader) ? MastershipRole.MASTER : (candidates.contains(nodeId) ? MastershipRole.STANDBY : MastershipRole.NONE);
    }

    public NodeId getMaster(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        return this.leadershipService.getLeader(this.createDeviceMastershipTopic(deviceId));
    }

    public RoleInfo getNodes(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        Leadership leadership = this.leadershipService.getLeadership(this.createDeviceMastershipTopic(deviceId));
        return new RoleInfo(leadership.leaderNodeId(), leadership.candidates());
    }

    public MastershipInfo getMastership(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        Leadership leadership = this.leadershipService.getLeadership(this.createDeviceMastershipTopic(deviceId));
        return this.buildMastershipFromLeadership(leadership);
    }

    public Set<DeviceId> getDevices(NodeId nodeId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        return this.leadershipService.ownedTopics(nodeId).stream().filter(this::isDeviceMastershipTopic).map(this::extractDeviceIdFromTopic).collect(Collectors.toSet());
    }

    public CompletableFuture<MastershipEvent> setMaster(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        if (this.leadershipAdminService.promoteToTopOfCandidateList(leadershipTopic, nodeId)) {
            this.transferExecutor.schedule(() -> this.leadershipAdminService.transferLeadership(leadershipTopic, nodeId), 3000L, TimeUnit.MILLISECONDS);
        }
        return CompletableFuture.completedFuture(null);
    }

    public MastershipTerm getTermFor(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        Leadership leadership = this.leadershipService.getLeadership(leadershipTopic);
        return leadership != null && leadership.leaderNodeId() != null ? MastershipTerm.of((NodeId)leadership.leaderNodeId(), (long)leadership.leader().term()) : null;
    }

    public CompletableFuture<MastershipEvent> setStandby(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        NodeId currentMaster = this.getMaster(deviceId);
        if (!nodeId.equals((Object)currentMaster)) {
            return CompletableFuture.completedFuture(null);
        }
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        List candidates = this.leadershipService.getCandidates(leadershipTopic);
        NodeId newMaster = candidates.stream().filter(candidate -> !Objects.equals(nodeId, candidate)).findFirst().orElse(null);
        this.log.info("Transitioning to role {} for {}. Next master: {}", new Object[]{newMaster != null ? MastershipRole.STANDBY : MastershipRole.NONE, deviceId, newMaster});
        if (newMaster != null) {
            return this.setMaster(newMaster, deviceId);
        }
        return this.relinquishRole(nodeId, deviceId);
    }

    public CompletableFuture<MastershipEvent> relinquishRole(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        if (nodeId.equals((Object)this.localNodeId)) {
            return this.relinquishLocalRole(deviceId);
        }
        this.log.debug("Forwarding request to relinquish role for device {} to {}", (Object)deviceId, (Object)nodeId);
        return this.clusterCommunicator.sendAndReceive((Object)deviceId, ROLE_RELINQUISH_SUBJECT, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), nodeId);
    }

    private CompletableFuture<MastershipEvent> relinquishLocalRole(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        if (!this.leadershipService.getCandidates(leadershipTopic).contains(this.localNodeId)) {
            return CompletableFuture.completedFuture(null);
        }
        MastershipEvent.Type eventType = this.localNodeId.equals((Object)this.leadershipService.getLeader(leadershipTopic)) ? MastershipEvent.Type.MASTER_CHANGED : MastershipEvent.Type.BACKUPS_CHANGED;
        this.leadershipService.withdraw(leadershipTopic);
        return CompletableFuture.completedFuture(new MastershipEvent(eventType, deviceId, this.getMastership(deviceId)));
    }

    public void relinquishAllRole(NodeId nodeId) {
    }

    private MastershipInfo buildMastershipFromLeadership(Leadership leadership) {
        HashMap<NodeId, MastershipRole> roles = new HashMap<NodeId, MastershipRole>();
        if (leadership.leaderNodeId() != null) {
            roles.put(leadership.leaderNodeId(), MastershipRole.MASTER);
        }
        leadership.candidates().stream().filter(nodeId -> !Objects.equals(leadership.leaderNodeId(), nodeId)).forEach(nodeId -> roles.putIfAbsent((NodeId)nodeId, MastershipRole.STANDBY));
        this.clusterService.getNodes().stream().filter(node -> !Objects.equals(leadership.leaderNodeId(), node.id())).filter(node -> !leadership.candidates().contains(node.id())).forEach(node -> roles.putIfAbsent(node.id(), MastershipRole.NONE));
        return new MastershipInfo(leadership.leader() != null ? leadership.leader().term() : 0L, leadership.leader() != null ? Optional.of(leadership.leader().nodeId()) : Optional.empty(), ImmutableMap.copyOf(roles));
    }

    private String createDeviceMastershipTopic(DeviceId deviceId) {
        return String.format("device:%s", deviceId.toString());
    }

    private DeviceId extractDeviceIdFromTopic(String topic) {
        Matcher m = DEVICE_MASTERSHIP_TOPIC_PATTERN.matcher(topic);
        if (m.matches()) {
            return DeviceId.deviceId((String)m.group(1));
        }
        throw new IllegalArgumentException("Invalid device mastership topic: " + topic);
    }

    private boolean isDeviceMastershipTopic(String topic) {
        Matcher m = DEVICE_MASTERSHIP_TOPIC_PATTERN.matcher(topic);
        return m.matches();
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindLeadershipAdminService(LeadershipAdminService leadershipAdminService) {
        this.leadershipAdminService = leadershipAdminService;
    }

    protected void unbindLeadershipAdminService(LeadershipAdminService leadershipAdminService) {
        if (this.leadershipAdminService == leadershipAdminService) {
            this.leadershipAdminService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    private class InternalDeviceMastershipEventListener
    implements LeadershipEventListener {
        private InternalDeviceMastershipEventListener() {
        }

        public boolean isRelevant(LeadershipEvent event) {
            Leadership leadership = (Leadership)event.subject();
            return ConsistentDeviceMastershipStore.this.isDeviceMastershipTopic(leadership.topic());
        }

        public void event(LeadershipEvent event) {
            ConsistentDeviceMastershipStore.this.eventHandler.execute(() -> this.handleEvent(event));
        }

        private void handleEvent(LeadershipEvent event) {
            Leadership leadership = (Leadership)event.subject();
            DeviceId deviceId = ConsistentDeviceMastershipStore.this.extractDeviceIdFromTopic(leadership.topic());
            MastershipInfo mastershipInfo = event.type() != LeadershipEvent.Type.SERVICE_DISRUPTED ? ConsistentDeviceMastershipStore.this.buildMastershipFromLeadership((Leadership)event.subject()) : new MastershipInfo();
            switch ((LeadershipEvent.Type)event.type()) {
                case LEADER_AND_CANDIDATES_CHANGED: {
                    ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, mastershipInfo));
                    ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, mastershipInfo));
                    break;
                }
                case LEADER_CHANGED: {
                    ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, mastershipInfo));
                    break;
                }
                case CANDIDATES_CHANGED: {
                    ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, mastershipInfo));
                    break;
                }
                case SERVICE_DISRUPTED: {
                    ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.SUSPENDED, deviceId, mastershipInfo));
                    break;
                }
                case SERVICE_RESTORED: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }
}

