/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import org.onlab.packet.IpAddress;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.impl.InternalMessage;
import org.onosproject.store.cluster.messaging.impl.InternalReply;
import org.onosproject.store.cluster.messaging.impl.InternalRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEncoder
extends MessageToByteEncoder<Object> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Endpoint endpoint;
    private final int preamble;
    private boolean endpointWritten;

    public MessageEncoder(Endpoint endpoint, int preamble) {
        this.endpoint = endpoint;
        this.preamble = preamble;
    }

    protected void encode(ChannelHandlerContext context, Object rawMessage, ByteBuf out) throws Exception {
        if (rawMessage instanceof InternalRequest) {
            this.encodeRequest((InternalRequest)rawMessage, out);
        } else if (rawMessage instanceof InternalReply) {
            this.encodeReply((InternalReply)rawMessage, out);
        }
    }

    private void encodeMessage(InternalMessage message, ByteBuf out) {
        if (!this.endpointWritten) {
            IpAddress senderIp = this.endpoint.host();
            if (senderIp.version() == IpAddress.Version.INET) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
            }
            out.writeBytes(senderIp.toOctets());
            out.writeInt(this.endpoint.port());
            this.endpointWritten = true;
        }
        out.writeByte(message.type().id());
        out.writeInt(this.preamble);
        out.writeLong(message.time().logicalTime());
        out.writeLong(message.time().logicalCounter());
        out.writeLong(message.id());
        byte[] payload = message.payload();
        out.writeInt(payload.length);
        out.writeBytes(payload);
    }

    private void encodeRequest(InternalRequest request, ByteBuf out) {
        this.encodeMessage(request, out);
        byte[] messageTypeBytes = request.subject().getBytes(Charsets.UTF_8);
        out.writeShort(messageTypeBytes.length);
        out.writeBytes(messageTypeBytes);
    }

    private void encodeReply(InternalReply reply, ByteBuf out) {
        this.encodeMessage(reply, out);
        out.writeByte(reply.status().id());
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        if (cause instanceof IOException) {
            this.log.debug("IOException inside channel handling pipeline.", cause);
        } else {
            this.log.error("non-IOException inside channel handling pipeline.", cause);
        }
        context.close();
    }

    public final boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof InternalMessage;
    }
}

