/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.host.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.MacAddress;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.event.Event;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.host.HostProbe;
import org.onosproject.net.host.HostProbeStore;
import org.onosproject.net.host.HostProbingEvent;
import org.onosproject.net.host.HostProbingStoreDelegate;
import org.onosproject.net.host.ProbeMode;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.host.impl.DefaultHostProbe;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.AtomicCounterBuilder;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultHostProbeStore
extends AbstractStore<HostProbingEvent, HostProbingStoreDelegate>
implements HostProbeStore {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int PROBE_TIMEOUT_MS = 3000;
    private AtomicCounter hostProbeIndex;
    private Cache<MacAddress, HostProbe> probingHostsCache;
    private ConsistentMap<MacAddress, HostProbe> probingHostsConsistentMap;
    private Map<MacAddress, HostProbe> probingHosts;
    private MapEventListener<MacAddress, HostProbe> probingHostListener = new ProbingHostListener();
    private ScheduledExecutorService cacheCleaner;
    private ScheduledExecutorService locationRemover;

    @Activate
    public void activate() {
        KryoNamespace.Builder pendingHostSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{DefaultHostProbe.class}).register(new Class[]{ProbeMode.class});
        this.probingHostsConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-hosts-pending")).withRelaxedReadConsistency()).withSerializer(Serializer.using((KryoNamespace)pendingHostSerializer.build()))).build();
        this.probingHostsConsistentMap.addListener(this.probingHostListener);
        this.probingHosts = this.probingHostsConsistentMap.asJavaMap();
        this.hostProbeIndex = ((AsyncAtomicCounter)((AtomicCounterBuilder)this.storageService.atomicCounterBuilder().withName("onos-hosts-probe-index")).build()).asAtomicCounter();
        this.probingHostsCache = CacheBuilder.newBuilder().expireAfterWrite(3000L, TimeUnit.MILLISECONDS).removalListener(notification -> {
            MacAddress probeMac = (MacAddress)notification.getKey();
            switch (notification.getCause()) {
                case EXPIRED: 
                case REPLACED: {
                    this.probingHosts.computeIfPresent(probeMac, (k, v) -> {
                        v.decreaseRetry();
                        return v;
                    });
                    break;
                }
                case EXPLICIT: {
                    break;
                }
                default: {
                    this.log.warn("Remove {} from pendingHostLocations for unexpected reason {}", notification.getKey(), (Object)notification.getCause());
                }
            }
        }).build();
        this.cacheCleaner = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/host/hostprobestore", (String)"cache-cleaner", (Logger)this.log));
        this.cacheCleaner.scheduleAtFixedRate(() -> this.probingHostsCache.cleanUp(), 0L, 3000L, TimeUnit.MILLISECONDS);
        this.locationRemover = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/host/hostprobestore", (String)"loc-remover", (Logger)this.log));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cacheCleaner.shutdown();
        this.locationRemover.shutdown();
        this.probingHostsCache.cleanUp();
        this.log.info("Stopped");
    }

    public MacAddress addProbingHost(Host host, ConnectPoint connectPoint, ProbeMode probeMode, MacAddress probeMac, int retry) {
        if (probeMac == null) {
            probeMac = this.generateProbeMac();
        }
        DefaultHostProbe probingHost = new DefaultHostProbe(host, connectPoint, probeMode, probeMac, retry);
        this.probingHostsCache.put((Object)probeMac, (Object)probingHost);
        this.probingHosts.put(probeMac, probingHost);
        return probeMac;
    }

    public void removeProbingHost(MacAddress probeMac) {
        this.probingHostsCache.invalidate((Object)probeMac);
        this.probingHosts.remove(probeMac);
    }

    private MacAddress generateProbeMac() {
        long nextIndex = this.hostProbeIndex.incrementAndGet();
        return MacAddress.valueOf((long)(MacAddress.NONE.toLong() + nextIndex));
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class ProbingHostListener
    implements MapEventListener<MacAddress, HostProbe> {
        private ProbingHostListener() {
        }

        public void event(MapEvent<MacAddress, HostProbe> event) {
            HostProbe newValue = (HostProbe)Versioned.valueOrNull((Versioned)event.newValue());
            HostProbe oldValue = (HostProbe)Versioned.valueOrNull((Versioned)event.oldValue());
            switch (event.type()) {
                case INSERT: {
                    HostProbingEvent hostProbingEvent = new HostProbingEvent(HostProbingEvent.Type.PROBE_REQUESTED, newValue);
                    DefaultHostProbeStore.this.notifyDelegate((Event)hostProbingEvent);
                    break;
                }
                case UPDATE: {
                    if (newValue.retry() > 0) {
                        if (newValue.mode() == ProbeMode.DISCOVER) {
                            HostProbingEvent hostProbingEvent = new HostProbingEvent(HostProbingEvent.Type.PROBE_TIMEOUT, newValue, oldValue);
                            DefaultHostProbeStore.this.notifyDelegate((Event)hostProbingEvent);
                            break;
                        }
                        HostProbingEvent hostProbingEvent = new HostProbingEvent(HostProbingEvent.Type.PROBE_FAIL, newValue, oldValue);
                        DefaultHostProbeStore.this.notifyDelegate((Event)hostProbingEvent);
                        break;
                    }
                    DefaultHostProbeStore.this.locationRemover.execute(() -> {
                        HostProbe cfr_ignored_0 = (HostProbe)DefaultHostProbeStore.this.probingHosts.remove(event.key());
                    });
                    break;
                }
                case REMOVE: {
                    if (oldValue.retry() > 0) {
                        HostProbingEvent hostProbingEvent = new HostProbingEvent(HostProbingEvent.Type.PROBE_COMPLETED, oldValue);
                        DefaultHostProbeStore.this.notifyDelegate((Event)hostProbingEvent);
                        break;
                    }
                    HostProbingEvent hostProbingEvent = new HostProbingEvent(HostProbingEvent.Type.PROBE_FAIL, oldValue);
                    DefaultHostProbeStore.this.notifyDelegate((Event)hostProbingEvent);
                    break;
                }
                default: {
                    DefaultHostProbeStore.this.log.warn("Unknown map event type: {}", (Object)event.type());
                }
            }
        }
    }
}

