/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.onlab.util.Tools;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumerId;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.ConsistentResourceStore;
import org.onosproject.store.resource.impl.ConsistentResourceSubStore;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.TransactionalDiscreteResourceSubStore;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.Versioned;

class ConsistentDiscreteResourceSubStore
implements ConsistentResourceSubStore<DiscreteResourceId, DiscreteResource, TransactionalDiscreteResourceSubStore> {
    private ConsistentMap<DiscreteResourceId, ResourceConsumerId> consumers;
    private ConsistentMap<DiscreteResourceId, DiscreteResources> childMap;

    ConsistentDiscreteResourceSubStore(StorageService service) {
        this.consumers = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)service.consistentMapBuilder().withName("onos-discrete-consumers")).withSerializer(ConsistentResourceStore.SERIALIZER)).build();
        this.childMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)service.consistentMapBuilder().withName("onos-resource-discrete-children")).withSerializer(ConsistentResourceStore.SERIALIZER)).build();
        Tools.retryable(() -> this.childMap.putIfAbsent((Object)Resource.ROOT.id(), (Object)DiscreteResources.empty()), StorageException.ConcurrentModification.class, (int)Integer.MAX_VALUE, (int)50).get();
    }

    @Override
    public TransactionalDiscreteResourceSubStore transactional(TransactionContext tx) {
        return new TransactionalDiscreteResourceSubStore(tx);
    }

    @Override
    public List<ResourceAllocation> getResourceAllocations(DiscreteResourceId resource) {
        Versioned consumerId = this.consumers.get((Object)resource);
        if (consumerId == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)new ResourceAllocation((Resource)Resources.discrete((DiscreteResourceId)resource).resource(), (ResourceConsumerId)consumerId.value()));
    }

    @Override
    public Set<DiscreteResource> getChildResources(DiscreteResourceId parent) {
        Versioned children = this.childMap.get((Object)parent);
        if (children == null) {
            return ImmutableSet.of();
        }
        return ((DiscreteResources)children.value()).values();
    }

    @Override
    public Set<DiscreteResource> getChildResources(DiscreteResourceId parent, Class<?> cls) {
        Versioned children = this.childMap.get((Object)parent);
        if (children == null) {
            return ImmutableSet.of();
        }
        return ((DiscreteResources)children.value()).valuesOf(cls);
    }

    @Override
    public boolean isAvailable(DiscreteResource resource) {
        return this.getResourceAllocations(resource.id()).isEmpty();
    }

    @Override
    public Stream<DiscreteResource> getAllocatedResources(DiscreteResourceId parent, Class<?> cls) {
        Set<DiscreteResource> children = this.getChildResources(parent);
        if (children.isEmpty()) {
            return Stream.of(new DiscreteResource[0]);
        }
        return children.stream().filter(x -> x.isTypeOf(cls)).filter(x -> this.consumers.containsKey((Object)x.id()));
    }

    @Override
    public Stream<DiscreteResource> getResources(ResourceConsumerId consumerId) {
        return this.consumers.entrySet().stream().filter(x -> ((ResourceConsumerId)((Versioned)x.getValue()).value()).equals((Object)consumerId)).map(Map.Entry::getKey).map(x -> Resources.discrete((DiscreteResourceId)x).resource());
    }
}

