/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipStore;
import org.onosproject.cluster.LeadershipStoreDelegate;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.Version;
import org.onosproject.core.VersionService;
import org.onosproject.event.Change;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.CoordinationService;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.LeaderElector;
import org.onosproject.store.service.LeaderElectorBuilder;
import org.onosproject.upgrade.UpgradeEvent;
import org.onosproject.upgrade.UpgradeEventListener;
import org.onosproject.upgrade.UpgradeService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class DistributedLeadershipStore
extends AbstractStore<LeadershipEvent, LeadershipStoreDelegate>
implements LeadershipStore {
    private static final char VERSION_SEP = '|';
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoordinationService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VersionService versionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected UpgradeService upgradeService;
    private static final long DEFAULT_ELECTION_TIMEOUT_MILLIS = 2500L;
    @Property(name="electionTimeoutMillis", longValue={2500L}, label="the leader election timeout in milliseconds")
    private long electionTimeoutMillis = 2500L;
    private ExecutorService statusChangeHandler;
    private NodeId localNodeId;
    private LeaderElector leaderElector;
    private final Map<String, Leadership> localLeaderCache = Maps.newConcurrentMap();
    private final UpgradeEventListener upgradeListener = new InternalUpgradeEventListener();
    private final Consumer<Change<Leadership>> leadershipChangeListener = change -> {
        Leadership oldValue = (Leadership)change.oldValue();
        Leadership newValue = (Leadership)change.newValue();
        if (!this.isLocalTopic(newValue.topic())) {
            return;
        }
        boolean leaderChanged = !Objects.equals(oldValue.leader(), newValue.leader());
        boolean candidatesChanged = !Objects.equals(oldValue.candidates(), newValue.candidates());
        LeadershipEvent.Type eventType = null;
        if (leaderChanged && candidatesChanged) {
            eventType = LeadershipEvent.Type.LEADER_AND_CANDIDATES_CHANGED;
        }
        if (leaderChanged && !candidatesChanged) {
            eventType = LeadershipEvent.Type.LEADER_CHANGED;
        }
        if (!leaderChanged && candidatesChanged) {
            eventType = LeadershipEvent.Type.CANDIDATES_CHANGED;
        }
        this.notifyDelegate((Event)new LeadershipEvent(eventType, new Leadership(this.parseTopic(((Leadership)change.newValue()).topic()), ((Leadership)change.newValue()).leader(), ((Leadership)change.newValue()).candidates())));
        if (Objects.equals(newValue.leaderNodeId(), this.localNodeId)) {
            this.localLeaderCache.put(newValue.topic(), newValue);
        } else {
            this.localLeaderCache.remove(newValue.topic());
        }
    };
    private final Consumer<DistributedPrimitive.Status> clientStatusListener = status -> this.statusChangeHandler.execute(() -> this.handleStatusChange((DistributedPrimitive.Status)status));

    private void handleStatusChange(DistributedPrimitive.Status status) {
        if (status == DistributedPrimitive.Status.ACTIVE) {
            this.localLeaderCache.forEach((topic, leadership) -> this.leaderElector.run(topic, this.localNodeId));
            this.leaderElector.getLeaderships().forEach((topic, leadership) -> this.notifyDelegate((Event)new LeadershipEvent(LeadershipEvent.Type.SERVICE_RESTORED, new Leadership(this.parseTopic(leadership.topic()), leadership.leader(), leadership.candidates()))));
        } else if (status == DistributedPrimitive.Status.SUSPENDED) {
            this.localLeaderCache.forEach((topic, leadership) -> this.notifyDelegate((Event)new LeadershipEvent(LeadershipEvent.Type.SERVICE_DISRUPTED, new Leadership(this.parseTopic(leadership.topic()), leadership.leader(), leadership.candidates()))));
        } else {
            return;
        }
    }

    @Activate
    public void activate() {
        this.configService.registerProperties(((Object)((Object)this)).getClass());
        this.statusChangeHandler = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/dist/cluster/leadership", (String)"status-change-handler", (Logger)this.log));
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leaderElector = ((AsyncLeaderElector)((LeaderElectorBuilder)((LeaderElectorBuilder)((LeaderElectorBuilder)this.storageService.leaderElectorBuilder().withName("onos-leadership-elections")).withElectionTimeout(this.electionTimeoutMillis)).withRelaxedReadConsistency()).build()).asLeaderElector();
        this.leaderElector.addChangeListener(this.leadershipChangeListener);
        this.leaderElector.addStatusChangeListener(this.clientStatusListener);
        this.upgradeService.addListener((EventListener)this.upgradeListener);
        this.log.info("Started");
    }

    @Modified
    public void modified(ComponentContext context) {
        long newElectionTimeoutMillis;
        if (context == null) {
            return;
        }
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"electionTimeoutMillis");
            newElectionTimeoutMillis = Strings.isNullOrEmpty((String)s) ? this.electionTimeoutMillis : Long.parseLong(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            this.log.warn("Malformed configuration detected; using defaults", (Throwable)e);
            newElectionTimeoutMillis = 2500L;
        }
        if (newElectionTimeoutMillis != this.electionTimeoutMillis) {
            this.electionTimeoutMillis = newElectionTimeoutMillis;
            this.leaderElector = ((AsyncLeaderElector)((LeaderElectorBuilder)((LeaderElectorBuilder)((LeaderElectorBuilder)this.storageService.leaderElectorBuilder().withName("onos-leadership-elections")).withElectionTimeout(this.electionTimeoutMillis)).withRelaxedReadConsistency()).build()).asLeaderElector();
        }
    }

    @Deactivate
    public void deactivate() {
        this.leaderElector.removeChangeListener(this.leadershipChangeListener);
        this.leaderElector.removeStatusChangeListener(this.clientStatusListener);
        this.upgradeService.removeListener((EventListener)this.upgradeListener);
        this.statusChangeHandler.shutdown();
        this.configService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.log.info("Stopped");
    }

    public Leadership addRegistration(String topic) {
        this.leaderElector.run(this.getLocalTopic(topic), this.localNodeId);
        return this.getLeadership(topic);
    }

    public void removeRegistration(String topic) {
        this.leaderElector.withdraw(this.getLocalTopic(topic));
    }

    public void removeRegistration(NodeId nodeId) {
        this.leaderElector.evict(nodeId);
    }

    public boolean moveLeadership(String topic, NodeId toNodeId) {
        return this.leaderElector.anoint(this.getTopicFor(topic, toNodeId), toNodeId);
    }

    public boolean makeTopCandidate(String topic, NodeId nodeId) {
        return this.leaderElector.promote(this.getTopicFor(topic, nodeId), nodeId);
    }

    public Leadership getLeadership(String topic) {
        Leadership leadership = this.leaderElector.getLeadership(this.getActiveTopic(topic));
        return leadership != null ? new Leadership(this.parseTopic(leadership.topic()), leadership.leader(), leadership.candidates()) : null;
    }

    public Map<String, Leadership> getLeaderships() {
        Map leaderships = this.leaderElector.getLeaderships();
        return leaderships.entrySet().stream().filter(e -> this.isActiveTopic((String)e.getKey())).collect(Collectors.toMap(e -> this.parseTopic((String)e.getKey()), e -> new Leadership(this.parseTopic((String)e.getKey()), ((Leadership)e.getValue()).leader(), ((Leadership)e.getValue()).candidates())));
    }

    private String getLocalTopic(String topic) {
        return topic + '|' + this.versionService.version();
    }

    private String getActiveTopic(String topic) {
        return topic + '|' + this.upgradeService.getVersion();
    }

    private boolean isLocalTopic(String topic) {
        return topic.endsWith(this.versionService.version().toString());
    }

    private boolean isActiveTopic(String topic) {
        return topic.endsWith('|' + this.upgradeService.getVersion().toString());
    }

    private String parseTopic(String topic) {
        return topic.substring(0, topic.lastIndexOf(124));
    }

    private String getTopicFor(String topic, NodeId nodeId) {
        Version nodeVersion = this.clusterService.getVersion(nodeId);
        return nodeVersion != null ? topic + '|' + nodeVersion : topic + '|' + this.versionService.version();
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(CoordinationService coordinationService) {
        this.storageService = coordinationService;
    }

    protected void unbindStorageService(CoordinationService coordinationService) {
        if (this.storageService == coordinationService) {
            this.storageService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    protected void bindVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    protected void unbindVersionService(VersionService versionService) {
        if (this.versionService == versionService) {
            this.versionService = null;
        }
    }

    protected void bindUpgradeService(UpgradeService upgradeService) {
        this.upgradeService = upgradeService;
    }

    protected void unbindUpgradeService(UpgradeService upgradeService) {
        if (this.upgradeService == upgradeService) {
            this.upgradeService = null;
        }
    }

    private class InternalUpgradeEventListener
    implements UpgradeEventListener {
        private InternalUpgradeEventListener() {
        }

        public void event(UpgradeEvent event) {
            if (event.type() == UpgradeEvent.Type.UPGRADED || event.type() == UpgradeEvent.Type.ROLLED_BACK) {
                for (Leadership leadership : DistributedLeadershipStore.this.getLeaderships().values()) {
                    DistributedLeadershipStore.this.notifyDelegate((Event)new LeadershipEvent(LeadershipEvent.Type.LEADER_AND_CANDIDATES_CHANGED, leadership));
                }
            }
        }
    }
}

