/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import com.google.common.base.MoreObjects;
import org.onlab.util.ByteArraySizeHashPrinter;
import org.onosproject.core.HybridLogicalTime;
import org.onosproject.store.cluster.messaging.impl.InternalMessage;

public final class InternalReply
extends InternalMessage {
    private final Status status;

    public InternalReply(int preamble, HybridLogicalTime time, long id, Status status) {
        this(preamble, time, id, new byte[0], status);
    }

    public InternalReply(int preamble, HybridLogicalTime time, long id, byte[] payload, Status status) {
        super(preamble, time, id, payload);
        this.status = status;
    }

    @Override
    public InternalMessage.Type type() {
        return InternalMessage.Type.REPLY;
    }

    public Status status() {
        return this.status;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)this.time()).add("id", this.id()).add("status", (Object)this.status()).add("payload", (Object)ByteArraySizeHashPrinter.of((byte[])this.payload())).toString();
    }

    public static enum Status {
        OK(0),
        ERROR_NO_HANDLER(1),
        ERROR_HANDLER_EXCEPTION(2),
        PROTOCOL_EXCEPTION(3);

        private final int id;

        private Status(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Status forId(int id) {
            switch (id) {
                case 0: {
                    return OK;
                }
                case 1: {
                    return ERROR_NO_HANDLER;
                }
                case 2: {
                    return ERROR_HANDLER_EXCEPTION;
                }
                case 3: {
                    return PROTOCOL_EXCEPTION;
                }
            }
            throw new IllegalArgumentException("Unknown status ID " + id);
        }
    }
}

