/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.config.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.InvalidConfigException;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigStore;
import org.onosproject.net.config.NetworkConfigStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedNetworkConfigStore
extends AbstractStore<NetworkConfigEvent, NetworkConfigStoreDelegate>
implements NetworkConfigStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String INVALID_CONFIG_JSON = "JSON node does not contain valid configuration";
    private static final String INVALID_JSON_LIST = "JSON node is not a list for list type config";
    private static final String INVALID_JSON_OBJECT = "JSON node is not an object for object type config";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<ConfigKey, JsonNode> configs;
    private final Map<String, ConfigFactory> factoriesByConfig = Maps.newConcurrentMap();
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigApplyDelegate applyDelegate = new InternalApplyDelegate();
    private final MapEventListener<ConfigKey, JsonNode> listener = new InternalMapListener();

    @Activate
    public void activate() {
        KryoNamespace.Builder kryoBuilder = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{ConfigKey.class, ObjectNode.class, ArrayNode.class, JsonNodeFactory.class, LinkedHashMap.class, TextNode.class, BooleanNode.class, LongNode.class, DoubleNode.class, ShortNode.class, IntNode.class, NullNode.class});
        this.configs = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)kryoBuilder.build()))).withName("onos-network-configs")).withRelaxedReadConsistency()).build();
        this.configs.addListener(this.listener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.configs.removeListener(this.listener);
        this.log.info("Stopped");
    }

    public void addConfigFactory(ConfigFactory configFactory) {
        this.factoriesByConfig.put(configFactory.configClass().getName(), configFactory);
        this.processPendingConfigs(configFactory);
        this.notifyDelegate((Event)new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_REGISTERED, (Object)configFactory.configKey(), configFactory.configClass()));
    }

    private void processPendingConfigs(ConfigFactory configFactory) {
        this.configs.keySet().forEach(k -> {
            Versioned versioned;
            if (Objects.equals(k.configKey, configFactory.configKey()) && this.isAssignableFrom(configFactory, (ConfigKey)k) && (versioned = this.configs.remove(k)) != null) {
                this.validateConfig((ConfigKey)k, configFactory, (JsonNode)versioned.value());
            }
        });
    }

    private boolean isAssignableFrom(ConfigFactory configFactory, ConfigKey k) {
        return configFactory.subjectFactory().subjectClass().isAssignableFrom(k.subject.getClass());
    }

    private void validateConfig(ConfigKey key, ConfigFactory configFactory, JsonNode json) {
        Object subject = key.subject instanceof String ? configFactory.subjectFactory().createSubject((String)key.subject) : key.subject;
        Object config = this.createConfig(subject, configFactory.configClass(), json);
        try {
            Preconditions.checkArgument((boolean)config.isValid(), (Object)INVALID_CONFIG_JSON);
            this.configs.putAndGet((Object)DistributedNetworkConfigStore.key(subject, configFactory.configClass()), (Object)json);
        }
        catch (Exception e) {
            this.log.warn("Failed to validate pending {} configuration for {}: {}", new Object[]{key.configKey, key.subject, json});
        }
    }

    public void removeConfigFactory(ConfigFactory configFactory) {
        this.factoriesByConfig.remove(configFactory.configClass().getName());
        this.processExistingConfigs(configFactory);
        this.notifyDelegate((Event)new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_UNREGISTERED, (Object)configFactory.configKey(), configFactory.configClass()));
    }

    private void processExistingConfigs(ConfigFactory configFactory) {
        this.configs.keySet().forEach(k -> {
            Versioned remove;
            if (Objects.equals(configFactory.configClass().getName(), k.configClass) && (remove = this.configs.remove(k)) != null) {
                JsonNode json = (JsonNode)remove.value();
                this.configs.put((Object)DistributedNetworkConfigStore.key(k.subject, configFactory.configKey()), (Object)json);
                this.log.debug("Set config pending: {}, {}", k.subject, (Object)k.configClass);
            }
        });
    }

    public <S, C extends Config<S>> ConfigFactory<S, C> getConfigFactory(Class<C> configClass) {
        return this.factoriesByConfig.get(configClass.getName());
    }

    public <S> Set<S> getSubjects(Class<S> subjectClass) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.configs.keySet().forEach(k -> {
            if (subjectClass.isInstance(k.subject)) {
                builder.add(k.subject);
            }
        });
        return builder.build();
    }

    public <S, C extends Config<S>> Set<S> getSubjects(Class<S> subjectClass, Class<C> configClass) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        String cName = configClass.getName();
        this.configs.keySet().forEach(k -> {
            if (subjectClass.isInstance(k.subject) && Objects.equals(cName, k.configClass)) {
                builder.add(k.subject);
            }
        });
        return builder.build();
    }

    public <S> Set<Class<? extends Config<S>>> getConfigClasses(S subject) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.configs.keySet().forEach(k -> {
            if (Objects.equals(subject, k.subject) && k.configClass != null && this.delegate != null) {
                ConfigFactory configFactory = this.factoriesByConfig.get(k.configClass);
                if (configFactory == null) {
                    this.log.warn("Found config but no config factory: subject={}, configClass={}", subject, (Object)k.configClass);
                } else {
                    builder.add((Object)configFactory.configClass());
                }
            }
        });
        return builder.build();
    }

    public <S, T extends Config<S>> T getConfig(S subject, Class<T> configClass) {
        Versioned json = this.configs.get((Object)DistributedNetworkConfigStore.key(subject, configClass));
        return json != null ? (T)this.createConfig(subject, configClass, (JsonNode)json.value()) : null;
    }

    public <S, C extends Config<S>> C createConfig(S subject, Class<C> configClass) {
        ConfigFactory factory = this.getConfigFactory(configClass);
        Versioned json = this.configs.computeIfAbsent((Object)DistributedNetworkConfigStore.key(subject, configClass), k -> factory.isList() ? this.mapper.createArrayNode() : this.mapper.createObjectNode());
        return this.createConfig(subject, configClass, (JsonNode)json.value());
    }

    public <S, C extends Config<S>> C applyConfig(S subject, Class<C> configClass, JsonNode json) {
        C config = this.createConfig(subject, configClass, json);
        try {
            Preconditions.checkArgument((boolean)config.isValid(), (Object)INVALID_CONFIG_JSON);
        }
        catch (RuntimeException e) {
            ConfigFactory<S, C> configFactory = this.getConfigFactory(configClass);
            String subjectKey = configFactory.subjectFactory().subjectClassKey();
            String subjectString = configFactory.subjectFactory().subjectKey(config.subject());
            String configKey = config.key();
            throw new InvalidConfigException(subjectKey, subjectString, configKey, (Throwable)e);
        }
        Versioned versioned = this.configs.putAndGet((Object)DistributedNetworkConfigStore.key(subject, configClass), (Object)json);
        return versioned.value() == json ? config : this.createConfig(subject, configClass, (JsonNode)versioned.value());
    }

    public <S> void queueConfig(S subject, String configKey, JsonNode json) {
        this.configs.put((Object)DistributedNetworkConfigStore.key(subject, configKey), (Object)json);
    }

    public <S, C extends Config<S>> void clearConfig(S subject, Class<C> configClass) {
        this.configs.remove((Object)DistributedNetworkConfigStore.key(subject, configClass));
    }

    public <S> void clearQueuedConfig(S subject, String configKey) {
        this.configs.remove((Object)DistributedNetworkConfigStore.key(subject, configKey));
    }

    public <S> void clearConfig(S subject) {
        this.configs.keySet().forEach(k -> {
            if (Objects.equals(subject, k.subject) && this.delegate != null) {
                this.configs.remove(k);
            }
        });
    }

    public <S> void clearConfig() {
        this.configs.keySet().forEach(k -> {
            if (this.delegate != null) {
                this.configs.remove(k);
            }
        });
    }

    private <S, C extends Config<S>> C createConfig(S subject, Class<C> configClass, JsonNode json) {
        return this.createConfig(subject, configClass, json, false);
    }

    private <S, C extends Config<S>> C createConfig(S subject, Class<C> configClass, JsonNode json, boolean detached) {
        ConfigFactory factory;
        if (json != null && (factory = this.factoriesByConfig.get(configClass.getName())) != null) {
            this.validateJsonType(json, factory);
            Config config = factory.createConfig();
            config.init(subject, factory.configKey(), json, this.mapper, detached ? null : this.applyDelegate);
            return (C)config;
        }
        return null;
    }

    private <S, C extends Config<S>> boolean validateJsonType(JsonNode json, ConfigFactory<S, C> factory) {
        if (factory.isList() && !(json instanceof ArrayNode)) {
            throw new IllegalArgumentException(INVALID_JSON_LIST);
        }
        if (!factory.isList() && !(json instanceof ObjectNode)) {
            throw new IllegalArgumentException(INVALID_JSON_OBJECT);
        }
        return true;
    }

    private static ConfigKey key(Object subject, Class<?> configClass) {
        return new ConfigKey(subject, configClass);
    }

    private static ConfigKey key(Object subject, String configKey) {
        return new ConfigKey(subject, configKey);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalMapListener
    implements MapEventListener<ConfigKey, JsonNode> {
        private InternalMapListener() {
        }

        public void event(MapEvent<ConfigKey, JsonNode> event) {
            if (((ConfigKey)event.key()).configClass == null) {
                return;
            }
            ConfigFactory factory = (ConfigFactory)DistributedNetworkConfigStore.this.factoriesByConfig.get(((ConfigKey)event.key()).configClass);
            if (factory != null) {
                NetworkConfigEvent.Type type;
                Object subject = ((ConfigKey)event.key()).subject;
                Class configClass = factory.configClass();
                Versioned newValue = event.newValue();
                Versioned oldValue = event.oldValue();
                Config config = newValue != null ? DistributedNetworkConfigStore.this.createConfig(subject, configClass, (JsonNode)newValue.value(), true) : null;
                Config prevConfig = oldValue != null ? DistributedNetworkConfigStore.this.createConfig(subject, configClass, (JsonNode)oldValue.value(), true) : null;
                switch (event.type()) {
                    case INSERT: {
                        type = NetworkConfigEvent.Type.CONFIG_ADDED;
                        break;
                    }
                    case UPDATE: {
                        type = NetworkConfigEvent.Type.CONFIG_UPDATED;
                        break;
                    }
                    default: {
                        type = NetworkConfigEvent.Type.CONFIG_REMOVED;
                    }
                }
                DistributedNetworkConfigStore.this.notifyDelegate((Event)new NetworkConfigEvent(type, ((ConfigKey)event.key()).subject, config, prevConfig, factory.configClass()));
            }
        }
    }

    private static final class ConfigKey {
        final Object subject;
        final String configKey;
        final String configClass;

        private ConfigKey(Object subject, String configKey) {
            this.subject = subject;
            this.configKey = configKey;
            this.configClass = null;
        }

        private ConfigKey(Object subject, Class<?> configClass) {
            this.subject = subject;
            this.configKey = null;
            this.configClass = configClass.getName();
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.configKey, this.configClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConfigKey) {
                ConfigKey other = (ConfigKey)obj;
                return Objects.equals(this.subject, other.subject) && Objects.equals(this.configKey, other.configKey) && Objects.equals(this.configClass, other.configClass);
            }
            return false;
        }
    }

    private class InternalApplyDelegate
    implements ConfigApplyDelegate {
        private InternalApplyDelegate() {
        }

        public void onApply(Config config) {
            DistributedNetworkConfigStore.this.configs.put((Object)DistributedNetworkConfigStore.key(config.subject(), config.getClass()), (Object)config.node());
        }
    }
}

