/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.onosproject.cluster.NodeId;

public class DeviceReplicaInfo {
    private final long term;
    private final NodeId master;
    private final List<NodeId> backups;

    public DeviceReplicaInfo(long term, NodeId master, List<NodeId> backups) {
        this.term = term;
        this.master = master;
        this.backups = backups;
    }

    public long term() {
        return this.term;
    }

    public NodeId master() {
        return this.master;
    }

    public boolean isMaster(NodeId nodeId) {
        return Objects.equals(this.master, nodeId);
    }

    public List<NodeId> backups() {
        return this.backups;
    }

    public boolean isBackup(NodeId nodeId) {
        return this.backups.contains(nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.term, this.master, this.backups);
    }

    public boolean equals(Object object) {
        if (object instanceof DeviceReplicaInfo) {
            DeviceReplicaInfo that = (DeviceReplicaInfo)object;
            return this.term == that.term && Objects.equals(this.master, that.master) && Objects.equals(this.backups, that.backups);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term()).add("master", (Object)this.master()).add("backups", this.backups()).toString();
    }
}

