/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import java.util.Objects;
import org.onosproject.store.LogicalTimestamp;
import org.onosproject.store.Timestamp;

public class FlowBucketDigest {
    private final int bucket;
    private final long term;
    private final LogicalTimestamp timestamp;

    FlowBucketDigest(int bucket, long term, LogicalTimestamp timestamp) {
        this.bucket = bucket;
        this.term = term;
        this.timestamp = timestamp;
    }

    public int bucket() {
        return this.bucket;
    }

    public long term() {
        return this.term;
    }

    public LogicalTimestamp timestamp() {
        return this.timestamp;
    }

    public boolean isNewerThan(FlowBucketDigest digest) {
        return digest == null || this.term() > digest.term() || this.timestamp().isNewerThan((Timestamp)digest.timestamp());
    }

    public int hashCode() {
        return Objects.hash(this.bucket);
    }

    public boolean equals(Object object) {
        return object instanceof FlowBucketDigest && ((FlowBucketDigest)object).bucket == this.bucket;
    }
}

