/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.group.impl;

import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.GroupId;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupStore;
import org.onosproject.net.group.GroupStoreDelegate;
import org.onosproject.net.group.StoredGroupBucketEntry;
import org.onosproject.net.group.StoredGroupEntry;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.group.impl.GroupStoreMessage;
import org.onosproject.store.group.impl.GroupStoreMessageSubjects;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Topic;
import org.onosproject.store.service.Versioned;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedGroupStore
extends AbstractStore<GroupEvent, GroupStoreDelegate>
implements GroupStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final boolean GARBAGE_COLLECT = false;
    private static final int GC_THRESH = 6;
    private static final boolean ALLOW_EXTRANEOUS_GROUPS = true;
    private static final int MAX_FAILED_ATTEMPTS = 3;
    private final int dummyId = -1;
    private final GroupId dummyGroupId = new GroupId(-1);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    private ScheduledExecutorService executor;
    private Consumer<DistributedPrimitive.Status> statusChangeListener;
    private ConsistentMap<GroupStoreKeyMapKey, StoredGroupEntry> groupStoreEntriesByKey = null;
    private final ConcurrentMap<DeviceId, ConcurrentMap<GroupId, StoredGroupEntry>> groupEntriesById = new ConcurrentHashMap<DeviceId, ConcurrentMap<GroupId, StoredGroupEntry>>();
    private ConsistentMap<GroupStoreKeyMapKey, StoredGroupEntry> auditPendingReqQueue = null;
    private MapEventListener<GroupStoreKeyMapKey, StoredGroupEntry> mapListener = new GroupStoreKeyMapListener();
    private final ConcurrentMap<DeviceId, ConcurrentMap<GroupId, Group>> extraneousGroupEntriesById = new ConcurrentHashMap<DeviceId, ConcurrentMap<GroupId, Group>>();
    private ExecutorService messageHandlingExecutor;
    private static final int MESSAGE_HANDLER_THREAD_POOL_SIZE = 1;
    private final HashMap<DeviceId, Boolean> deviceAuditStatus = new HashMap();
    private final AtomicInteger groupIdGen = new AtomicInteger();
    private KryoNamespace clusterMsgSerializer;
    private static Topic<GroupStoreMessage> groupTopic;
    @Property(name="garbageCollect", boolValue={false}, label="Enable group garbage collection")
    private boolean garbageCollect = false;
    @Property(name="gcThresh", intValue={6}, label="Number of rounds for group garbage collection")
    private int gcThresh = 6;
    @Property(name="allowExtraneousGroups", boolValue={true}, label="Allow groups in switches not installed by ONOS")
    private boolean allowExtraneousGroups = true;

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.modified(context);
        KryoNamespace.Builder kryoBuilder = new KryoNamespace.Builder().register(KryoNamespaces.API).nextId(500).register(new Class[]{DefaultGroup.class, DefaultGroupBucket.class, DefaultGroupDescription.class, DefaultGroupKey.class, GroupDescription.Type.class, Group.GroupState.class, GroupBuckets.class, GroupStoreMessage.class, GroupStoreMessage.Type.class, GroupStore.UpdateType.class, GroupStoreMessageSubjects.class, MultiValuedTimestamp.class, GroupStoreKeyMapKey.class, GroupStoreIdMapKey.class, GroupStoreMapKey.class});
        this.clusterMsgSerializer = kryoBuilder.build("GroupStore");
        Serializer serializer = Serializer.using((KryoNamespace)this.clusterMsgSerializer);
        this.messageHandlingExecutor = Executors.newFixedThreadPool(1, Tools.groupedThreads((String)"onos/store/group", (String)"message-handlers", (Logger)this.log));
        this.clusterCommunicator.addSubscriber(GroupStoreMessageSubjects.REMOTE_GROUP_OP_REQUEST, arg_0 -> ((KryoNamespace)this.clusterMsgSerializer).deserialize(arg_0), this::process, (Executor)this.messageHandlingExecutor);
        this.log.debug("Creating Consistent map onos-group-store-keymap");
        this.groupStoreEntriesByKey = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-group-store-keymap")).withSerializer(serializer)).build();
        this.groupStoreEntriesByKey.addListener(this.mapListener);
        this.log.debug("Current size of groupstorekeymap:{}", (Object)this.groupStoreEntriesByKey.size());
        this.synchronizeGroupStoreEntries();
        this.log.debug("Creating GroupStoreId Map From GroupStoreKey Map");
        this.matchGroupEntries();
        this.executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/group", (String)"store", (Logger)this.log));
        this.statusChangeListener = status -> {
            if (status == DistributedPrimitive.Status.ACTIVE) {
                this.executor.execute(this::matchGroupEntries);
            }
        };
        this.groupStoreEntriesByKey.addStatusChangeListener(this.statusChangeListener);
        this.log.debug("Creating Consistent map pendinggroupkeymap");
        this.auditPendingReqQueue = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pending-group-keymap")).withSerializer(serializer)).build();
        this.log.debug("Current size of pendinggroupkeymap:{}", (Object)this.auditPendingReqQueue.size());
        groupTopic = this.getOrCreateGroupTopic(serializer);
        groupTopic.subscribe(this::processGroupMessage);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.groupStoreEntriesByKey.removeListener(this.mapListener);
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.clusterCommunicator.removeSubscriber(GroupStoreMessageSubjects.REMOTE_GROUP_OP_REQUEST);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        Dictionary properties = context != null ? context.getProperties() : new Properties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"garbageCollect");
            this.garbageCollect = Strings.isNullOrEmpty((String)s) ? false : Boolean.parseBoolean(s.trim());
            s = Tools.get((Dictionary)properties, (String)"gcThresh");
            this.gcThresh = Strings.isNullOrEmpty((String)s) ? 6 : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"allowExtraneousGroups");
            this.allowExtraneousGroups = Strings.isNullOrEmpty((String)s) ? true : Boolean.parseBoolean(s.trim());
        }
        catch (Exception e) {
            this.gcThresh = 6;
            this.garbageCollect = false;
            this.allowExtraneousGroups = true;
        }
    }

    private Topic<GroupStoreMessage> getOrCreateGroupTopic(Serializer serializer) {
        if (groupTopic == null) {
            return this.storageService.getTopic("group-failover-notif", serializer);
        }
        return groupTopic;
    }

    private void matchGroupEntries() {
        for (Map.Entry entry : this.groupStoreEntriesByKey.asJavaMap().entrySet()) {
            StoredGroupEntry group = (StoredGroupEntry)entry.getValue();
            this.getGroupIdTable(((GroupStoreKeyMapKey)entry.getKey()).deviceId()).put(group.id(), group);
        }
    }

    private void synchronizeGroupStoreEntries() {
        Map groupEntryMap = this.groupStoreEntriesByKey.asJavaMap();
        for (Map.Entry entry : groupEntryMap.entrySet()) {
            StoredGroupEntry value = (StoredGroupEntry)entry.getValue();
            ConcurrentMap<GroupId, StoredGroupEntry> groupIdTable = this.getGroupIdTable(value.deviceId());
            groupIdTable.put(value.id(), value);
        }
    }

    private Map<GroupStoreKeyMapKey, StoredGroupEntry> getGroupStoreKeyMap() {
        return this.groupStoreEntriesByKey.asJavaMap();
    }

    private ConcurrentMap<GroupId, StoredGroupEntry> getGroupIdTable(DeviceId deviceId) {
        return this.groupEntriesById.computeIfAbsent(deviceId, k -> new ConcurrentHashMap());
    }

    private Map<GroupStoreKeyMapKey, StoredGroupEntry> getPendingGroupKeyTable() {
        return this.auditPendingReqQueue.asJavaMap();
    }

    private ConcurrentMap<GroupId, Group> getExtraneousGroupIdTable(DeviceId deviceId) {
        return this.extraneousGroupEntriesById.computeIfAbsent(deviceId, k -> new ConcurrentHashMap());
    }

    public int getGroupCount(DeviceId deviceId) {
        return this.getGroups(deviceId) != null ? Iterables.size(this.getGroups(deviceId)) : 0;
    }

    public Iterable<Group> getGroups(DeviceId deviceId) {
        return ImmutableSet.copyOf(this.getStoredGroups(deviceId));
    }

    private Iterable<StoredGroupEntry> getStoredGroups(DeviceId deviceId) {
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        if (master == null) {
            this.log.debug("Failed to getGroups: No master for {}", (Object)deviceId);
            return Collections.emptySet();
        }
        Set storedGroups = this.getGroupStoreKeyMap().values().stream().filter(input -> input.deviceId().equals((Object)deviceId)).collect(Collectors.toSet());
        return ImmutableSet.copyOf(storedGroups);
    }

    public Group getGroup(DeviceId deviceId, GroupKey appCookie) {
        return this.getStoredGroupEntry(deviceId, appCookie);
    }

    private StoredGroupEntry getStoredGroupEntry(DeviceId deviceId, GroupKey appCookie) {
        return this.getGroupStoreKeyMap().get(new GroupStoreKeyMapKey(deviceId, appCookie));
    }

    public Group getGroup(DeviceId deviceId, GroupId groupId) {
        return this.getStoredGroupEntry(deviceId, groupId);
    }

    private StoredGroupEntry getStoredGroupEntry(DeviceId deviceId, GroupId groupId) {
        return (StoredGroupEntry)this.getGroupIdTable(deviceId).get(groupId);
    }

    private int getFreeGroupIdValue(DeviceId deviceId) {
        int freeId = this.groupIdGen.incrementAndGet();
        while (true) {
            Group existing;
            if ((existing = this.getGroup(deviceId, new GroupId(freeId))) == null) {
                Group group = existing = this.extraneousGroupEntriesById.get(deviceId) != null ? (Group)((ConcurrentMap)this.extraneousGroupEntriesById.get(deviceId)).get(new GroupId(freeId)) : null;
            }
            if (existing == null) break;
            freeId = this.groupIdGen.incrementAndGet();
        }
        this.log.debug("getFreeGroupIdValue: Next Free ID is {}", (Object)freeId);
        return freeId;
    }

    public void storeGroupDescription(GroupDescription groupDesc) {
        this.log.debug("In storeGroupDescription");
        Group existingGroup = this.getGroup(groupDesc.deviceId(), groupDesc.appCookie());
        if (existingGroup != null) {
            this.log.debug("Group already exists with the same key {} in dev:{} with id:0x{}", new Object[]{groupDesc.appCookie(), groupDesc.deviceId(), Integer.toHexString((Integer)existingGroup.id().id())});
            return;
        }
        if (this.mastershipService.getLocalRole(groupDesc.deviceId()) != MastershipRole.MASTER) {
            this.log.debug("storeGroupDescription: Device {} local role is not MASTER", (Object)groupDesc.deviceId());
            if (this.mastershipService.getMasterFor(groupDesc.deviceId()) == null) {
                this.log.debug("No Master for device {}...Queuing Group ADD request", (Object)groupDesc.deviceId());
                this.addToPendingAudit(groupDesc);
                return;
            }
            GroupStoreMessage groupOp = GroupStoreMessage.createGroupAddRequestMsg(groupDesc.deviceId(), groupDesc);
            this.clusterCommunicator.unicast((Object)groupOp, GroupStoreMessageSubjects.REMOTE_GROUP_OP_REQUEST, arg_0 -> ((KryoNamespace)this.clusterMsgSerializer).serialize(arg_0), this.mastershipService.getMasterFor(groupDesc.deviceId())).whenComplete((result, error) -> {
                if (error != null) {
                    this.log.warn("Failed to send request to master: {} to {}", (Object)groupOp, (Object)this.mastershipService.getMasterFor(groupDesc.deviceId()));
                } else {
                    this.log.debug("Sent Group operation request for device {} to remote MASTER {}", (Object)groupDesc.deviceId(), (Object)this.mastershipService.getMasterFor(groupDesc.deviceId()));
                }
            });
            return;
        }
        this.log.debug("Store group for device {} is getting handled locally", (Object)groupDesc.deviceId());
        this.storeGroupDescriptionInternal(groupDesc);
    }

    private void addToPendingAudit(GroupDescription groupDesc) {
        Integer groupIdVal = groupDesc.givenGroupId();
        GroupId groupId = groupIdVal != null ? new GroupId(groupIdVal.intValue()) : this.dummyGroupId;
        this.addToPendingKeyTable((StoredGroupEntry)new DefaultGroup(groupId, groupDesc));
    }

    private void addToPendingKeyTable(StoredGroupEntry group) {
        group.setState(Group.GroupState.WAITING_AUDIT_COMPLETE);
        Map<GroupStoreKeyMapKey, StoredGroupEntry> pendingKeyTable = this.getPendingGroupKeyTable();
        pendingKeyTable.put(new GroupStoreKeyMapKey(group.deviceId(), group.appCookie()), group);
    }

    private Group getMatchingExtraneousGroupbyId(DeviceId deviceId, Integer groupId) {
        ConcurrentMap extraneousMap = (ConcurrentMap)this.extraneousGroupEntriesById.get(deviceId);
        if (extraneousMap == null) {
            return null;
        }
        return (Group)extraneousMap.get(new GroupId(groupId.intValue()));
    }

    private Group getMatchingExtraneousGroupbyBuckets(DeviceId deviceId, GroupBuckets buckets) {
        ConcurrentMap extraneousMap = (ConcurrentMap)this.extraneousGroupEntriesById.get(deviceId);
        if (extraneousMap == null) {
            return null;
        }
        for (Group extraneousGroup : extraneousMap.values()) {
            if (!extraneousGroup.buckets().equals((Object)buckets)) continue;
            return extraneousGroup;
        }
        return null;
    }

    private void storeGroupDescriptionInternal(GroupDescription groupDesc) {
        if (this.getGroup(groupDesc.deviceId(), groupDesc.appCookie()) != null) {
            return;
        }
        if (this.deviceAuditStatus.get(groupDesc.deviceId()) == null) {
            this.log.debug("storeGroupDescriptionInternal: Device {} AUDIT pending...Queuing Group ADD request", (Object)groupDesc.deviceId());
            DefaultGroup group = new DefaultGroup(this.dummyGroupId, groupDesc);
            group.setState(Group.GroupState.WAITING_AUDIT_COMPLETE);
            Map<GroupStoreKeyMapKey, StoredGroupEntry> pendingKeyTable = this.getPendingGroupKeyTable();
            pendingKeyTable.put(new GroupStoreKeyMapKey(groupDesc.deviceId(), groupDesc.appCookie()), (StoredGroupEntry)group);
            return;
        }
        Group matchingExtraneousGroup = null;
        if (groupDesc.givenGroupId() != null) {
            matchingExtraneousGroup = this.getMatchingExtraneousGroupbyId(groupDesc.deviceId(), groupDesc.givenGroupId());
            if (matchingExtraneousGroup != null) {
                this.log.debug("storeGroupDescriptionInternal: Matching extraneous group found in Device {} for group id 0x{}", (Object)groupDesc.deviceId(), (Object)Integer.toHexString(groupDesc.givenGroupId()));
                if (matchingExtraneousGroup.buckets().equals((Object)groupDesc.buckets())) {
                    this.log.debug("storeGroupDescriptionInternal: Buckets also matching in Device {} for group id 0x{}", (Object)groupDesc.deviceId(), (Object)Integer.toHexString(groupDesc.givenGroupId()));
                    DefaultGroup group = new DefaultGroup(matchingExtraneousGroup.id(), groupDesc);
                    this.getGroupStoreKeyMap().put(new GroupStoreKeyMapKey(groupDesc.deviceId(), groupDesc.appCookie()), (StoredGroupEntry)group);
                    this.getGroupIdTable(groupDesc.deviceId()).put(matchingExtraneousGroup.id(), (StoredGroupEntry)group);
                    this.addOrUpdateGroupEntry(matchingExtraneousGroup);
                    this.removeExtraneousGroupEntry(matchingExtraneousGroup);
                    return;
                }
                this.log.debug("storeGroupDescriptionInternal: Buckets are not matching in Device {} for group id 0x{}", (Object)groupDesc.deviceId(), (Object)Integer.toHexString(groupDesc.givenGroupId()));
                DefaultGroup modifiedGroup = new DefaultGroup(matchingExtraneousGroup.id(), groupDesc);
                modifiedGroup.setState(Group.GroupState.PENDING_UPDATE);
                this.getGroupStoreKeyMap().put(new GroupStoreKeyMapKey(groupDesc.deviceId(), groupDesc.appCookie()), (StoredGroupEntry)modifiedGroup);
                this.getGroupIdTable(groupDesc.deviceId()).put(matchingExtraneousGroup.id(), (StoredGroupEntry)modifiedGroup);
                this.removeExtraneousGroupEntry(matchingExtraneousGroup);
                this.log.debug("storeGroupDescriptionInternal: Triggering Group UPDATE request for {} in device {}", (Object)matchingExtraneousGroup.id(), (Object)groupDesc.deviceId());
                this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_UPDATE_REQUESTED, (Group)modifiedGroup));
                return;
            }
        } else {
            matchingExtraneousGroup = this.getMatchingExtraneousGroupbyBuckets(groupDesc.deviceId(), groupDesc.buckets());
            if (matchingExtraneousGroup != null) {
                this.log.debug("storeGroupDescriptionInternal: Matching extraneous group found in Device {}", (Object)groupDesc.deviceId());
                DefaultGroup group = new DefaultGroup(matchingExtraneousGroup.id(), groupDesc);
                this.getGroupStoreKeyMap().put(new GroupStoreKeyMapKey(groupDesc.deviceId(), groupDesc.appCookie()), (StoredGroupEntry)group);
                this.getGroupIdTable(groupDesc.deviceId()).put(matchingExtraneousGroup.id(), (StoredGroupEntry)group);
                this.addOrUpdateGroupEntry(matchingExtraneousGroup);
                this.removeExtraneousGroupEntry(matchingExtraneousGroup);
                return;
            }
            this.log.debug("storeGroupDescriptionInternal: No matching extraneous groups found in Device {}", (Object)groupDesc.deviceId());
        }
        GroupId id = null;
        if (groupDesc.givenGroupId() == null) {
            id = new GroupId(this.getFreeGroupIdValue(groupDesc.deviceId()));
        } else {
            Group existing = this.getGroup(groupDesc.deviceId(), new GroupId(groupDesc.givenGroupId().intValue()));
            if (existing != null) {
                this.log.warn("Group already exists with the same id: 0x{} in dev:{} but with different key: {} (request gkey: {})", new Object[]{Integer.toHexString(groupDesc.givenGroupId()), groupDesc.deviceId(), existing.appCookie(), groupDesc.appCookie()});
                return;
            }
            id = new GroupId(groupDesc.givenGroupId().intValue());
        }
        DefaultGroup group = new DefaultGroup(id, groupDesc);
        this.getGroupStoreKeyMap().put(new GroupStoreKeyMapKey(groupDesc.deviceId(), groupDesc.appCookie()), (StoredGroupEntry)group);
        this.getGroupIdTable(groupDesc.deviceId()).put(id, (StoredGroupEntry)group);
        this.log.debug("storeGroupDescriptionInternal: Processing Group ADD request for Id {} in device {}", (Object)id, (Object)groupDesc.deviceId());
        this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_ADD_REQUESTED, (Group)group));
    }

    public void updateGroupDescription(DeviceId deviceId, GroupKey oldAppCookie, GroupStore.UpdateType type, GroupBuckets newBuckets, GroupKey newAppCookie) {
        if (this.mastershipService.getMasterFor(deviceId) != null && this.mastershipService.getLocalRole(deviceId) != MastershipRole.MASTER) {
            this.log.debug("updateGroupDescription: Device {} local role is not MASTER", (Object)deviceId);
            if (this.mastershipService.getMasterFor(deviceId) == null) {
                this.log.error("No Master for device {}...Can not perform update group operation", (Object)deviceId);
                return;
            }
            GroupStoreMessage groupOp = GroupStoreMessage.createGroupUpdateRequestMsg(deviceId, oldAppCookie, type, newBuckets, newAppCookie);
            this.clusterCommunicator.unicast((Object)groupOp, GroupStoreMessageSubjects.REMOTE_GROUP_OP_REQUEST, arg_0 -> ((KryoNamespace)this.clusterMsgSerializer).serialize(arg_0), this.mastershipService.getMasterFor(deviceId)).whenComplete((result, error) -> {
                if (error != null) {
                    this.log.warn("Failed to send request to master: {} to {}", new Object[]{groupOp, this.mastershipService.getMasterFor(deviceId), error});
                }
            });
            return;
        }
        this.log.debug("updateGroupDescription for device {} is getting handled locally", (Object)deviceId);
        this.updateGroupDescriptionInternal(deviceId, oldAppCookie, type, newBuckets, newAppCookie);
    }

    private void updateGroupDescriptionInternal(DeviceId deviceId, GroupKey oldAppCookie, GroupStore.UpdateType type, GroupBuckets newBuckets, GroupKey newAppCookie) {
        Group oldGroup = this.getGroup(deviceId, oldAppCookie);
        if (oldGroup == null) {
            this.log.warn("updateGroupDescriptionInternal: Group not found...strange. GroupKey:{} DeviceId:{}", (Object)oldAppCookie, (Object)deviceId);
            return;
        }
        List<GroupBucket> newBucketList = this.getUpdatedBucketList(oldGroup, type, newBuckets);
        if (newBucketList != null) {
            GroupBuckets updatedBuckets = new GroupBuckets(newBucketList);
            GroupKey newCookie = newAppCookie != null ? newAppCookie : oldAppCookie;
            DefaultGroupDescription updatedGroupDesc = new DefaultGroupDescription(oldGroup.deviceId(), oldGroup.type(), updatedBuckets, newCookie, oldGroup.givenGroupId(), oldGroup.appId());
            DefaultGroup newGroup = new DefaultGroup(oldGroup.id(), (GroupDescription)updatedGroupDesc);
            this.log.debug("updateGroupDescriptionInternal: group entry {} in device {} moving from {} to PENDING_UPDATE", new Object[]{oldGroup.id(), oldGroup.deviceId(), oldGroup.state()});
            newGroup.setState(Group.GroupState.PENDING_UPDATE);
            newGroup.setLife(oldGroup.life());
            newGroup.setPackets(oldGroup.packets());
            newGroup.setBytes(oldGroup.bytes());
            this.log.debug("updateGroupDescriptionInternal with type {}: Group updated with buckets", (Object)type);
            this.getGroupStoreKeyMap().put(new GroupStoreKeyMapKey(newGroup.deviceId(), newGroup.appCookie()), (StoredGroupEntry)newGroup);
            this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_UPDATE_REQUESTED, (Group)newGroup));
        } else {
            this.log.warn("updateGroupDescriptionInternal with type {}: No change in the buckets in update", (Object)type);
        }
    }

    private List<GroupBucket> getUpdatedBucketList(Group oldGroup, GroupStore.UpdateType type, GroupBuckets buckets) {
        if (type == GroupStore.UpdateType.SET) {
            return buckets.buckets();
        }
        List oldBuckets = oldGroup.buckets().buckets();
        ArrayList<GroupBucket> updatedBucketList = new ArrayList<GroupBucket>();
        boolean groupDescUpdated = false;
        if (type == GroupStore.UpdateType.ADD) {
            List newBuckets = buckets.buckets();
            for (GroupBucket oldBucket : oldBuckets) {
                int newBucketIndex = newBuckets.indexOf(oldBucket);
                if (newBucketIndex != -1) {
                    GroupBucket newBucket = (GroupBucket)newBuckets.get(newBucketIndex);
                    if (newBucket.hasSameParameters(oldBucket)) continue;
                    groupDescUpdated = true;
                    continue;
                }
                updatedBucketList.add(oldBucket);
            }
            updatedBucketList.addAll(newBuckets);
            if (!oldBuckets.containsAll(newBuckets)) {
                groupDescUpdated = true;
            }
        } else if (type == GroupStore.UpdateType.REMOVE) {
            List bucketsToRemove = buckets.buckets();
            for (GroupBucket oldBucket : oldBuckets) {
                if (!bucketsToRemove.contains(oldBucket)) {
                    updatedBucketList.add(oldBucket);
                    continue;
                }
                groupDescUpdated = true;
            }
        }
        if (groupDescUpdated) {
            return updatedBucketList;
        }
        return null;
    }

    public void deleteGroupDescription(DeviceId deviceId, GroupKey appCookie) {
        if (this.mastershipService.getLocalRole(deviceId) != MastershipRole.MASTER) {
            this.log.debug("deleteGroupDescription: Device {} local role is not MASTER", (Object)deviceId);
            if (this.mastershipService.getMasterFor(deviceId) == null) {
                this.log.error("No Master for device {}...Can not perform delete group operation", (Object)deviceId);
                return;
            }
            GroupStoreMessage groupOp = GroupStoreMessage.createGroupDeleteRequestMsg(deviceId, appCookie);
            this.clusterCommunicator.unicast((Object)groupOp, GroupStoreMessageSubjects.REMOTE_GROUP_OP_REQUEST, arg_0 -> ((KryoNamespace)this.clusterMsgSerializer).serialize(arg_0), this.mastershipService.getMasterFor(deviceId)).whenComplete((result, error) -> {
                if (error != null) {
                    this.log.warn("Failed to send request to master: {} to {}", new Object[]{groupOp, this.mastershipService.getMasterFor(deviceId), error});
                }
            });
            return;
        }
        this.log.debug("deleteGroupDescription in device {} is getting handled locally", (Object)deviceId);
        this.deleteGroupDescriptionInternal(deviceId, appCookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteGroupDescriptionInternal(DeviceId deviceId, GroupKey appCookie) {
        StoredGroupEntry existing = this.getStoredGroupEntry(deviceId, appCookie);
        if (existing == null) {
            return;
        }
        this.log.debug("deleteGroupDescriptionInternal: group entry {} in device {} moving from {} to PENDING_DELETE", new Object[]{existing.id(), existing.deviceId(), existing.state()});
        StoredGroupEntry storedGroupEntry = existing;
        synchronized (storedGroupEntry) {
            existing.setState(Group.GroupState.PENDING_DELETE);
            this.getGroupStoreKeyMap().put(new GroupStoreKeyMapKey(existing.deviceId(), existing.appCookie()), existing);
        }
        this.log.debug("deleteGroupDescriptionInternal: in device {} issuing GROUP_REMOVE_REQUESTED", (Object)deviceId);
        this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_REMOVE_REQUESTED, (Group)existing));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateGroupEntry(Group group) {
        StoredGroupEntry existing = this.getStoredGroupEntry(group.deviceId(), group.id());
        GroupEvent event = null;
        if (existing != null) {
            this.log.trace("addOrUpdateGroupEntry: updating group entry {} in device {}", (Object)group.id(), (Object)group.deviceId());
            StoredGroupEntry storedGroupEntry = existing;
            synchronized (storedGroupEntry) {
                for (GroupBucket bucket : group.buckets().buckets()) {
                    Optional<GroupBucket> matchingBucket = existing.buckets().buckets().stream().filter(existingBucket -> existingBucket.equals(bucket)).findFirst();
                    if (matchingBucket.isPresent()) {
                        ((StoredGroupBucketEntry)matchingBucket.get()).setPackets(bucket.packets());
                        ((StoredGroupBucketEntry)matchingBucket.get()).setBytes(bucket.bytes());
                        continue;
                    }
                    this.log.warn("addOrUpdateGroupEntry: No matching buckets to update stats");
                }
                existing.setLife(group.life());
                existing.setPackets(group.packets());
                existing.setBytes(group.bytes());
                existing.setReferenceCount(group.referenceCount());
                existing.setFailedRetryCount(0);
                if (existing.state() == Group.GroupState.PENDING_ADD || existing.state() == Group.GroupState.PENDING_ADD_RETRY) {
                    this.log.trace("addOrUpdateGroupEntry: group entry {} in device {} moving from {} to ADDED", new Object[]{existing.id(), existing.deviceId(), existing.state()});
                    existing.setState(Group.GroupState.ADDED);
                    existing.setIsGroupStateAddedFirstTime(true);
                    event = new GroupEvent(GroupEvent.Type.GROUP_ADDED, (Group)existing);
                } else {
                    this.log.trace("addOrUpdateGroupEntry: group entry {} in device {} moving from {} to ADDED", new Object[]{existing.id(), existing.deviceId(), Group.GroupState.PENDING_UPDATE});
                    existing.setState(Group.GroupState.ADDED);
                    existing.setIsGroupStateAddedFirstTime(false);
                    event = new GroupEvent(GroupEvent.Type.GROUP_UPDATED, (Group)existing);
                }
                this.getGroupStoreKeyMap().put(new GroupStoreKeyMapKey(existing.deviceId(), existing.appCookie()), existing);
            }
        } else {
            this.log.warn("addOrUpdateGroupEntry: Group update happening for a non-existing entry in the map");
        }
        if (event != null) {
            this.notifyDelegate((Event)event);
        }
    }

    public void removeGroupEntry(Group group) {
        StoredGroupEntry existing = this.getStoredGroupEntry(group.deviceId(), group.id());
        if (existing != null) {
            this.log.debug("removeGroupEntry: removing group entry {} in device {}", (Object)group.id(), (Object)group.deviceId());
            this.getGroupStoreKeyMap().remove(new GroupStoreKeyMapKey(existing.deviceId(), existing.appCookie()));
            this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_REMOVED, (Group)existing));
        } else {
            this.log.warn("removeGroupEntry for {} in device{} is not existing in our maps", (Object)group.id(), (Object)group.deviceId());
        }
    }

    private void purgeGroupEntries(Set<Map.Entry<GroupStoreKeyMapKey, StoredGroupEntry>> entries) {
        entries.forEach(entry -> this.groupStoreEntriesByKey.remove((Object)((GroupStoreKeyMapKey)entry.getKey())));
    }

    public void purgeGroupEntry(DeviceId deviceId) {
        HashSet<Map.Entry<GroupStoreKeyMapKey, StoredGroupEntry>> entriesPendingRemove = new HashSet<Map.Entry<GroupStoreKeyMapKey, StoredGroupEntry>>();
        this.getGroupStoreKeyMap().entrySet().stream().filter(entry -> ((GroupStoreKeyMapKey)entry.getKey()).deviceId().equals((Object)deviceId)).forEach(entriesPendingRemove::add);
        this.purgeGroupEntries(entriesPendingRemove);
    }

    public void purgeGroupEntries() {
        this.purgeGroupEntries(this.getGroupStoreKeyMap().entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceInitialAuditCompleted(DeviceId deviceId, boolean completed) {
        HashMap<DeviceId, Boolean> hashMap = this.deviceAuditStatus;
        synchronized (hashMap) {
            if (completed) {
                this.log.debug("AUDIT completed for device {}", (Object)deviceId);
                this.deviceAuditStatus.put(deviceId, true);
                List pendingGroupRequests = this.getPendingGroupKeyTable().values().stream().filter(g -> g.deviceId().equals((Object)deviceId)).collect(Collectors.toList());
                this.log.debug("processing pending group add requests for device {} and number of pending requests {}", (Object)deviceId, (Object)pendingGroupRequests.size());
                for (Group group : pendingGroupRequests) {
                    DefaultGroupDescription tmp = new DefaultGroupDescription(group.deviceId(), group.type(), group.buckets(), group.appCookie(), group.givenGroupId(), group.appId());
                    this.storeGroupDescriptionInternal((GroupDescription)tmp);
                    this.getPendingGroupKeyTable().remove(new GroupStoreKeyMapKey(deviceId, group.appCookie()));
                }
            } else {
                Boolean audited = this.deviceAuditStatus.get(deviceId);
                if (audited != null && audited.booleanValue()) {
                    this.log.debug("Clearing AUDIT status for device {}", (Object)deviceId);
                    this.deviceAuditStatus.put(deviceId, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deviceInitialAuditStatus(DeviceId deviceId) {
        HashMap<DeviceId, Boolean> hashMap = this.deviceAuditStatus;
        synchronized (hashMap) {
            Boolean audited = this.deviceAuditStatus.get(deviceId);
            return audited != null && audited != false;
        }
    }

    public void groupOperationFailed(DeviceId deviceId, GroupOperation operation) {
        StoredGroupEntry existing = this.getStoredGroupEntry(deviceId, operation.groupId());
        if (existing == null) {
            this.log.warn("No group entry with ID {} found ", (Object)operation.groupId());
            return;
        }
        this.log.warn("groupOperationFailed: group operation {} failed in state {} for group {} in device {} with code {}", new Object[]{operation.opType(), existing.state(), existing.id(), existing.deviceId(), operation.failureCode()});
        if (operation.failureCode() == GroupOperation.GroupMsgErrorCode.GROUP_EXISTS) {
            if (operation.buckets().equals((Object)existing.buckets())) {
                if (existing.state() == Group.GroupState.PENDING_ADD || existing.state() == Group.GroupState.PENDING_ADD_RETRY) {
                    this.log.info("GROUP_EXISTS: GroupID and Buckets match for group in pending add state - moving to ADDED for group {} in device {}", (Object)existing.id(), (Object)deviceId);
                    this.addOrUpdateGroupEntry((Group)existing);
                    return;
                }
                this.log.warn("GROUP_EXISTS: GroupId and Buckets match but existinggroup in state: {}", (Object)existing.state());
            } else {
                this.log.warn("GROUP EXISTS: Group ID matched but buckets did not. Operation: {} Existing: {}", (Object)operation.buckets(), (Object)existing.buckets());
            }
        }
        if (operation.failureCode() == GroupOperation.GroupMsgErrorCode.INVALID_GROUP) {
            existing.incrFailedRetryCount();
            if (existing.failedRetryCount() < 3) {
                this.log.warn("Group {} programming failed {} of {} times in dev {}, retrying ..", new Object[]{existing.id(), existing.failedRetryCount(), 3, deviceId});
                return;
            }
            this.log.warn("Group {} programming failed {} of {} times in dev {}, removing group from store", new Object[]{existing.id(), existing.failedRetryCount(), 3, deviceId});
        }
        switch (operation.opType()) {
            case ADD: {
                if (existing.state() != Group.GroupState.PENDING_ADD && existing.state() != Group.GroupState.PENDING_ADD_RETRY) break;
                this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_ADD_FAILED, (Group)existing));
                this.log.warn("groupOperationFailed: cleaningup group {} from store in device {}....", (Object)existing.id(), (Object)existing.deviceId());
                this.getGroupStoreKeyMap().remove(new GroupStoreKeyMapKey(existing.deviceId(), existing.appCookie()));
                break;
            }
            case MODIFY: {
                this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_UPDATE_FAILED, (Group)existing));
                break;
            }
            case DELETE: {
                this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_REMOVE_FAILED, (Group)existing));
                break;
            }
            default: {
                this.log.warn("Unknown group operation type {}", (Object)operation.opType());
            }
        }
    }

    public void addOrUpdateExtraneousGroupEntry(Group group) {
        this.log.debug("add/update extraneous group entry {} in device {}", (Object)group.id(), (Object)group.deviceId());
        ConcurrentMap<GroupId, Group> extraneousIdTable = this.getExtraneousGroupIdTable(group.deviceId());
        extraneousIdTable.put(group.id(), group);
    }

    public void removeExtraneousGroupEntry(Group group) {
        this.log.debug("remove extraneous group entry {} of device {} from store", (Object)group.id(), (Object)group.deviceId());
        ConcurrentMap<GroupId, Group> extraneousIdTable = this.getExtraneousGroupIdTable(group.deviceId());
        extraneousIdTable.remove(group.id());
    }

    public Iterable<Group> getExtraneousGroups(DeviceId deviceId) {
        return FluentIterable.from(this.getExtraneousGroupIdTable(deviceId).values());
    }

    private void processGroupMessage(GroupStoreMessage message) {
        if (message.type() == GroupStoreMessage.Type.FAILOVER) {
            this.getGroupIdTable(message.deviceId()).values().stream().filter(storedGroup -> storedGroup.appCookie().equals(message.appCookie())).findFirst().ifPresent(group -> this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_BUCKET_FAILOVER, (Group)group)));
        }
    }

    private void process(GroupStoreMessage groupOp) {
        this.log.debug("Received remote group operation {} request for device {}", (Object)groupOp.type(), (Object)groupOp.deviceId());
        if (!this.mastershipService.isLocalMaster(groupOp.deviceId())) {
            this.log.warn("This node is not MASTER for device {}", (Object)groupOp.deviceId());
            return;
        }
        if (groupOp.type() == GroupStoreMessage.Type.ADD) {
            this.storeGroupDescriptionInternal(groupOp.groupDesc());
        } else if (groupOp.type() == GroupStoreMessage.Type.UPDATE) {
            this.updateGroupDescriptionInternal(groupOp.deviceId(), groupOp.appCookie(), groupOp.updateType(), groupOp.updateBuckets(), groupOp.newAppCookie());
        } else if (groupOp.type() == GroupStoreMessage.Type.DELETE) {
            this.deleteGroupDescriptionInternal(groupOp.deviceId(), groupOp.appCookie());
        }
    }

    public void pushGroupMetrics(DeviceId deviceId, Collection<Group> groupEntries) {
        boolean deviceInitialAuditStatus = this.deviceInitialAuditStatus(deviceId);
        HashSet southboundGroupEntries = Sets.newHashSet(groupEntries);
        HashSet storedGroupEntries = Sets.newHashSet(this.getStoredGroups(deviceId));
        HashSet extraneousStoredEntries = Sets.newHashSet(this.getExtraneousGroups(deviceId));
        if (this.log.isTraceEnabled()) {
            this.log.trace("pushGroupMetrics: Displaying all ({}) southboundGroupEntries for device {}", (Object)southboundGroupEntries.size(), (Object)deviceId);
            for (Group group : southboundGroupEntries) {
                this.log.trace("Group {} in device {}", (Object)group, (Object)deviceId);
            }
            this.log.trace("Displaying all ({}) stored group entries for device {}", (Object)storedGroupEntries.size(), (Object)deviceId);
            for (Group group : storedGroupEntries) {
                this.log.trace("Stored Group {} for device {}", (Object)group, (Object)deviceId);
            }
        }
        this.garbageCollect(deviceId, southboundGroupEntries, storedGroupEntries);
        Iterator it2 = southboundGroupEntries.iterator();
        while (it2.hasNext()) {
            Group group;
            group = (Group)it2.next();
            if (!storedGroupEntries.remove(group)) continue;
            this.log.trace("Group AUDIT: group {} exists in both planes for device {}", (Object)group.id(), (Object)deviceId);
            this.groupAdded(group);
            it2.remove();
        }
        for (Group group : southboundGroupEntries) {
            if (this.getGroup(group.deviceId(), group.id()) != null) {
                if (storedGroupEntries.remove(this.getGroup(group.deviceId(), group.id()))) continue;
                this.log.warn("Group AUDIT: Inconsistent state:Group exists in ID based table while not present in key based table");
                continue;
            }
            this.log.debug("Group AUDIT: extraneous group {} exists in data plane for device {}", (Object)group.id(), (Object)deviceId);
            extraneousStoredEntries.remove(group);
            if (this.allowExtraneousGroups) {
                this.extraneousGroup(group);
                continue;
            }
            this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_REMOVE_REQUESTED, group));
        }
        for (Group group : storedGroupEntries) {
            this.log.debug("Group AUDIT: group {} missing in data plane for device {}", (Object)group.id(), (Object)deviceId);
            this.groupMissing((StoredGroupEntry)group);
        }
        for (Group group : extraneousStoredEntries) {
            this.log.debug("Group AUDIT: clearing extraneous group {} from store for device {}", (Object)group.id(), (Object)deviceId);
            this.removeExtraneousGroupEntry(group);
        }
        if (!deviceInitialAuditStatus) {
            this.log.info("Group AUDIT: Setting device {} initial AUDIT completed", (Object)deviceId);
            this.deviceInitialAuditCompleted(deviceId, true);
        }
    }

    public void notifyOfFailovers(Collection<Group> failoverGroups) {
        failoverGroups.forEach(group -> {
            if (group.type() == GroupDescription.Type.FAILOVER) {
                groupTopic.publish((Object)GroupStoreMessage.createGroupFailoverMsg(group.deviceId(), (GroupDescription)group));
            }
        });
    }

    private void garbageCollect(DeviceId deviceId, Set<Group> southboundGroupEntries, Set<StoredGroupEntry> storedGroupEntries) {
        if (!this.garbageCollect) {
            return;
        }
        Iterator<StoredGroupEntry> it = storedGroupEntries.iterator();
        while (it.hasNext()) {
            StoredGroupEntry group = it.next();
            if (group.state() == Group.GroupState.PENDING_DELETE || !this.checkGroupRefCount((Group)group)) continue;
            this.log.debug("Garbage collecting group {} on {}", (Object)group, (Object)deviceId);
            this.deleteGroupDescription(deviceId, group.appCookie());
            southboundGroupEntries.remove(group);
            it.remove();
        }
    }

    private boolean checkGroupRefCount(Group group) {
        return group.referenceCount() == 0L && group.age() >= this.gcThresh;
    }

    private void groupMissing(StoredGroupEntry group) {
        switch (group.state()) {
            case PENDING_DELETE: {
                this.log.debug("Group {} delete confirmation from device {}", (Object)group, (Object)group.deviceId());
                this.removeGroupEntry((Group)group);
                break;
            }
            case ADDED: 
            case PENDING_ADD: 
            case PENDING_ADD_RETRY: 
            case PENDING_UPDATE: {
                this.log.debug("groupMissing: group entry {} in device {} moving from {} to PENDING_ADD_RETRY", new Object[]{group.id(), group.deviceId(), group.state()});
                group.setState(Group.GroupState.PENDING_ADD_RETRY);
                this.getGroupStoreKeyMap().put(new GroupStoreKeyMapKey(group.deviceId(), group.appCookie()), group);
                this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_ADD_REQUESTED, (Group)group));
                break;
            }
            default: {
                this.log.debug("Group {} has not been installed.", (Object)group);
            }
        }
    }

    private void extraneousGroup(Group group) {
        this.log.trace("Group {} is on device {} but not in store.", (Object)group, (Object)group.deviceId());
        this.addOrUpdateExtraneousGroupEntry(group);
    }

    private void groupAdded(Group group) {
        this.log.trace("Group {} Added or Updated in device {}", (Object)group, (Object)group.deviceId());
        this.addOrUpdateGroupEntry(group);
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected static class GroupStoreIdMapKey
    extends GroupStoreMapKey {
        private final GroupId groupId;

        public GroupStoreIdMapKey(DeviceId deviceId, GroupId groupId) {
            super(deviceId);
            this.groupId = groupId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GroupStoreIdMapKey)) {
                return false;
            }
            GroupStoreIdMapKey that = (GroupStoreIdMapKey)o;
            return super.equals(that) && this.groupId.equals((Object)that.groupId);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 31 * result + super.hashCode() + Objects.hash(this.groupId);
            return result;
        }
    }

    protected static class GroupStoreKeyMapKey
    extends GroupStoreMapKey {
        private final GroupKey appCookie;

        public GroupStoreKeyMapKey(DeviceId deviceId, GroupKey appCookie) {
            super(deviceId);
            this.appCookie = appCookie;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GroupStoreKeyMapKey)) {
                return false;
            }
            GroupStoreKeyMapKey that = (GroupStoreKeyMapKey)o;
            return super.equals(that) && this.appCookie.equals(that.appCookie);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 31 * result + super.hashCode() + Objects.hash(this.appCookie);
            return result;
        }
    }

    protected static class GroupStoreMapKey {
        private final DeviceId deviceId;

        public GroupStoreMapKey(DeviceId deviceId) {
            this.deviceId = deviceId;
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GroupStoreMapKey)) {
                return false;
            }
            GroupStoreMapKey that = (GroupStoreMapKey)o;
            return this.deviceId.equals((Object)that.deviceId);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + Objects.hash(this.deviceId);
            return result;
        }
    }

    private class GroupStoreKeyMapListener
    implements MapEventListener<GroupStoreKeyMapKey, StoredGroupEntry> {
        private GroupStoreKeyMapListener() {
        }

        public void event(MapEvent<GroupStoreKeyMapKey, StoredGroupEntry> mapEvent) {
            GroupEvent groupEvent = null;
            GroupStoreKeyMapKey key = (GroupStoreKeyMapKey)mapEvent.key();
            StoredGroupEntry group = (StoredGroupEntry)Versioned.valueOrNull((Versioned)mapEvent.newValue());
            if (key == null && group == null) {
                DistributedGroupStore.this.log.error("GroupStoreKeyMapListener: Received event {} with null entry", (Object)mapEvent.type());
                return;
            }
            if (group == null && (group = (StoredGroupEntry)DistributedGroupStore.this.getGroupIdTable(key.deviceId()).values().stream().filter(storedGroup -> storedGroup.appCookie().equals(key.appCookie)).findFirst().orElse(null)) == null) {
                DistributedGroupStore.this.log.error("GroupStoreKeyMapListener: Received event {} with null entry... can not process", (Object)mapEvent.type());
                return;
            }
            DistributedGroupStore.this.log.trace("received groupid map event {} for id {} in device {}", new Object[]{mapEvent.type(), group.id(), key != null ? key.deviceId() : null});
            if (mapEvent.type() == MapEvent.Type.INSERT || mapEvent.type() == MapEvent.Type.UPDATE) {
                DistributedGroupStore.this.getGroupIdTable(group.deviceId()).put(group.id(), group);
                StoredGroupEntry value = (StoredGroupEntry)Versioned.valueOrNull((Versioned)mapEvent.newValue());
                if (value.state() == Group.GroupState.ADDED) {
                    if (value.isGroupStateAddedFirstTime()) {
                        groupEvent = new GroupEvent(GroupEvent.Type.GROUP_ADDED, (Group)value);
                        DistributedGroupStore.this.log.trace("Received first time GROUP_ADDED state update for id {} in device {}", (Object)group.id(), (Object)group.deviceId());
                    } else {
                        groupEvent = new GroupEvent(GroupEvent.Type.GROUP_UPDATED, (Group)value);
                        DistributedGroupStore.this.log.trace("Received following GROUP_ADDED state update for id {} in device {}", (Object)group.id(), (Object)group.deviceId());
                    }
                }
            } else if (mapEvent.type() == MapEvent.Type.REMOVE) {
                groupEvent = new GroupEvent(GroupEvent.Type.GROUP_REMOVED, (Group)group);
                DistributedGroupStore.this.getGroupIdTable(group.deviceId()).remove(group.id(), group);
            }
            if (groupEvent != null) {
                DistributedGroupStore.this.notifyDelegate((Event)groupEvent);
            }
        }
    }
}

