/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceCodec;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.Codecs;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.EmptyDiscreteResources;
import org.onosproject.store.resource.impl.EncodedDiscreteResources;

final class EncodableDiscreteResources
implements DiscreteResources {
    private static final Codecs CODECS = Codecs.getInstance();
    private final DiscreteResource parent;
    private final Map<Class<?>, EncodedDiscreteResources> map;

    private static Class<?> getClass(DiscreteResource resource) {
        return resource.valueAs(Object.class).map(Object::getClass).get();
    }

    static DiscreteResources of(Set<DiscreteResource> resources) {
        if (resources.isEmpty()) {
            return DiscreteResources.empty();
        }
        DiscreteResource parent = (DiscreteResource)resources.iterator().next().parent().get();
        return EncodableDiscreteResources.of(parent, resources);
    }

    static EncodableDiscreteResources of(DiscreteResource parent, Set<DiscreteResource> resources) {
        Map<Class, Set> grouped = resources.stream().collect(Collectors.groupingBy(x -> EncodableDiscreteResources.getClass(x), Collectors.toCollection(LinkedHashSet::new)));
        LinkedHashMap values = new LinkedHashMap();
        for (Map.Entry<Class, Set> entry : grouped.entrySet()) {
            DiscreteResourceCodec<?> codec = CODECS.getCodec(entry.getKey());
            values.put(entry.getKey(), EncodedDiscreteResources.of(entry.getValue(), codec));
        }
        return new EncodableDiscreteResources(parent, values);
    }

    private static DiscreteResources of(DiscreteResource parent, Map<Class<?>, EncodedDiscreteResources> map) {
        if (EncodableDiscreteResources.isEmpty(map)) {
            return DiscreteResources.empty();
        }
        return new EncodableDiscreteResources(parent, map);
    }

    private static boolean isEmpty(Map<Class<?>, EncodedDiscreteResources> map) {
        return map.values().stream().allMatch(EncodedDiscreteResources::isEmpty);
    }

    EncodableDiscreteResources(DiscreteResource parent, Map<Class<?>, EncodedDiscreteResources> map) {
        this.parent = parent;
        this.map = map;
    }

    @Override
    public Optional<DiscreteResource> lookup(DiscreteResourceId id) {
        if (!id.parent().filter(arg_0 -> ((DiscreteResourceId)this.parent.id()).equals(arg_0)).isPresent()) {
            return Optional.empty();
        }
        DiscreteResource resource = Resources.discrete((DiscreteResourceId)id).resource();
        Class<?> cls = EncodableDiscreteResources.getClass(resource);
        return Optional.ofNullable(this.map.get(cls)).filter(x -> x.contains(resource)).map(x -> resource);
    }

    @Override
    public DiscreteResources difference(DiscreteResources other) {
        if (other instanceof EncodableDiscreteResources) {
            EncodableDiscreteResources cast = (EncodableDiscreteResources)other;
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry<Class<?>, EncodedDiscreteResources> e : this.map.entrySet()) {
                Class<?> key = e.getKey();
                EncodedDiscreteResources thisValues = e.getValue();
                EncodedDiscreteResources otherValues = cast.map.get(key);
                if (otherValues == null) {
                    newMap.put(key, thisValues);
                    continue;
                }
                EncodedDiscreteResources diff = thisValues.difference(otherValues);
                if (diff.isEmpty()) continue;
                newMap.put(key, diff);
            }
            return EncodableDiscreteResources.of(this.parent, newMap);
        }
        if (other instanceof EmptyDiscreteResources) {
            return this;
        }
        return DiscreteResources.of((Set<DiscreteResource>)Sets.difference(this.values(), other.values()));
    }

    @Override
    public boolean isEmpty() {
        return EncodableDiscreteResources.isEmpty(this.map);
    }

    @Override
    public boolean containsAny(Set<DiscreteResource> other) {
        return other.stream().filter(x -> this.map.containsKey(EncodableDiscreteResources.getClass(x))).anyMatch(x -> this.map.get(EncodableDiscreteResources.getClass(x)).contains((DiscreteResource)x));
    }

    @Override
    public DiscreteResources add(DiscreteResources other) {
        if (other instanceof EncodableDiscreteResources) {
            EncodableDiscreteResources cast = (EncodableDiscreteResources)other;
            LinkedHashMap newMap = Stream.concat(this.map.entrySet().stream(), cast.map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, EncodedDiscreteResources::add, LinkedHashMap::new));
            return EncodableDiscreteResources.of(this.parent, newMap);
        }
        if (other instanceof EmptyDiscreteResources) {
            return this;
        }
        return DiscreteResources.of((Set<DiscreteResource>)Sets.union(this.values(), other.values()));
    }

    @Override
    public Set<DiscreteResource> values() {
        return this.map.values().stream().flatMap(x -> x.values(this.parent.id()).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public <T> Set<DiscreteResource> valuesOf(Class<T> cls) {
        return Optional.ofNullable(this.map.get(cls)).map(x -> x.values(this.parent.id())).orElse((Set)ImmutableSet.of());
    }

    DiscreteResource parent() {
        return this.parent;
    }

    Map<Class<?>, EncodedDiscreteResources> rawValues() {
        return this.map;
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.map);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EncodableDiscreteResources other = (EncodableDiscreteResources)obj;
        return Objects.equals(this.parent, other.parent) && Objects.equals(this.map, other.map);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values()).toString();
    }
}

