/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.mcast.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastEvent;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.McastRouteInfo;
import org.onosproject.net.mcast.McastStore;
import org.onosproject.net.mcast.McastStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.mcast.impl.MulticastData;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedMcastStore
extends AbstractStore<McastEvent, McastStoreDelegate>
implements McastStore {
    private static final String MCASTRIB = "onos-mcast-rib-table";
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private Map<McastRoute, MulticastData> mcastRoutes;
    private ConsistentMap<McastRoute, MulticastData> mcastRib;
    private MapEventListener<McastRoute, MulticastData> mcastRouteListener = new McastRouteListener();
    private ScheduledExecutorService executor;

    @Activate
    public void activate() {
        this.mcastRib = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(MCASTRIB)).withSerializer(Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{AtomicReference.class, MulticastData.class, McastRoute.class, McastRoute.Type.class}).build()))).build();
        this.mcastRoutes = this.mcastRib.asJavaMap();
        this.mcastRib.addListener(this.mcastRouteListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.mcastRib.removeListener(this.mcastRouteListener);
        this.log.info("Stopped");
    }

    public void storeRoute(McastRoute route, McastStore.Type operation) {
        switch (operation) {
            case ADD: {
                this.mcastRoutes.putIfAbsent(route, MulticastData.empty());
                break;
            }
            case REMOVE: {
                this.mcastRoutes.remove(route);
                break;
            }
            default: {
                this.log.warn("Unknown mcast operation type: {}", (Object)operation);
            }
        }
    }

    public void storeSource(McastRoute route, ConnectPoint source) {
        MulticastData data = this.mcastRoutes.compute(route, (k, v) -> {
            if (v == null) {
                return new MulticastData(source);
            }
            v.setSource(source);
            return v;
        });
    }

    public void storeSink(McastRoute route, ConnectPoint sink, McastStore.Type operation) {
        MulticastData data = this.mcastRoutes.compute(route, (k, v) -> {
            switch (operation) {
                case ADD: {
                    if (v == null) {
                        v = MulticastData.empty();
                    }
                    v.appendSink(sink);
                    break;
                }
                case REMOVE: {
                    if (v == null) break;
                    v.removeSink(sink);
                    break;
                }
                default: {
                    this.log.warn("Unknown mcast operation type: {}", (Object)operation);
                }
            }
            return v;
        });
    }

    public ConnectPoint sourceFor(McastRoute route) {
        return this.mcastRoutes.getOrDefault(route, MulticastData.empty()).source();
    }

    public Set<ConnectPoint> sinksFor(McastRoute route) {
        return this.mcastRoutes.getOrDefault(route, MulticastData.empty()).sinks();
    }

    public Set<McastRoute> getRoutes() {
        return this.mcastRoutes.keySet();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class McastRouteListener
    implements MapEventListener<McastRoute, MulticastData> {
        private McastRouteListener() {
        }

        public void event(MapEvent<McastRoute, MulticastData> event) {
            McastRoute route = (McastRoute)event.key();
            MulticastData newData = Optional.ofNullable(event.newValue()).map(Versioned::value).orElse(null);
            MulticastData oldData = Optional.ofNullable(event.oldValue()).map(Versioned::value).orElse(null);
            switch (event.type()) {
                case INSERT: {
                    Preconditions.checkNotNull((Object)newData);
                    if (newData.source() != null) {
                        DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SOURCE_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route, newData.sinks(), (ConnectPoint)newData.source())));
                        break;
                    }
                    if (!newData.sinks().isEmpty()) {
                        newData.sinks().forEach(sink -> DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SINK_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route, (ConnectPoint)sink, (ConnectPoint)newData.source()))));
                        break;
                    }
                    DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.ROUTE_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route)));
                    break;
                }
                case UPDATE: {
                    Preconditions.checkNotNull((Object)newData);
                    Preconditions.checkNotNull((Object)oldData);
                    if (!Objects.equal((Object)oldData.source(), (Object)newData.source())) {
                        if (oldData.source() != null && newData.source() != null) {
                            DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SOURCE_UPDATED, McastRouteInfo.mcastRouteInfo((McastRoute)route, newData.sinks(), (ConnectPoint)newData.source()), McastRouteInfo.mcastRouteInfo((McastRoute)route, oldData.sinks(), (ConnectPoint)oldData.source())));
                            break;
                        }
                        if (oldData.source() == null && newData.source() != null) {
                            DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SOURCE_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route, newData.sinks(), (ConnectPoint)newData.source())));
                            break;
                        }
                        DistributedMcastStore.this.log.warn("Unhandled scenario {} - new {} - old {}", (Object)event.type());
                        break;
                    }
                    Sets.difference(newData.sinks(), oldData.sinks()).forEach(sink -> DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SINK_ADDED, McastRouteInfo.mcastRouteInfo((McastRoute)route, (ConnectPoint)sink, (ConnectPoint)newData.source()))));
                    Sets.difference(oldData.sinks(), newData.sinks()).forEach(sink -> DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.SINK_REMOVED, McastRouteInfo.mcastRouteInfo((McastRoute)route, (ConnectPoint)sink, (ConnectPoint)newData.source()))));
                    break;
                }
                case REMOVE: {
                    Preconditions.checkNotNull((Object)oldData);
                    DistributedMcastStore.this.notifyDelegate((Event)new McastEvent(McastEvent.Type.ROUTE_REMOVED, McastRouteInfo.mcastRouteInfo((McastRoute)route, oldData.sinks(), (ConnectPoint)oldData.source())));
                    break;
                }
                default: {
                    DistributedMcastStore.this.log.warn("Unknown mcast operation type: {}", (Object)event.type());
                }
            }
        }
    }
}

