/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import java.util.HashMap;
import java.util.Map;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceCodec;
import org.onosproject.store.resource.impl.MplsLabelCodec;
import org.onosproject.store.resource.impl.PortNumberCodec;
import org.onosproject.store.resource.impl.VlanIdCodec;

final class Codecs {
    private static final Codecs INSTANCE = new Codecs();
    private final Map<Class<?>, DiscreteResourceCodec<?>> codecs = new HashMap();

    static Codecs getInstance() {
        return INSTANCE;
    }

    private Codecs() {
        this.init();
    }

    private void init() {
        this.codecs.put(PortNumber.class, new PortNumberCodec());
        this.codecs.put(VlanId.class, new VlanIdCodec());
        this.codecs.put(MplsLabel.class, new MplsLabelCodec());
    }

    boolean isEncodable(DiscreteResource resource) {
        return resource.valueAs(Object.class).map(Object::getClass).map(this.codecs::containsKey).orElse(Boolean.FALSE);
    }

    DiscreteResourceCodec<?> getCodec(Class<?> cls) {
        return this.codecs.get(cls);
    }
}

