/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.device.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.ChassisId;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipTermService;
import org.onosproject.net.Annotations;
import org.onosproject.net.AnnotationsUtil;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortStatistics;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceStore;
import org.onosproject.net.device.DeviceStoreDelegate;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.device.impl.DeviceKey;
import org.onosproject.store.device.impl.GossipDeviceStoreMessageSubjects;
import org.onosproject.store.device.impl.PortKey;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.custom.DistributedStoreSerializers;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class ECDeviceStore
extends AbstractStore<DeviceEvent, DeviceStoreDelegate>
implements DeviceStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DEVICE_NOT_FOUND = "Device with ID %s not found";
    private final Map<DeviceId, Device> devices = Maps.newConcurrentMap();
    private final Map<DeviceId, Map<PortNumber, Port>> devicePorts = Maps.newConcurrentMap();
    Set<DeviceId> pendingAvailableChangeUpdates = Sets.newConcurrentHashSet();
    private EventuallyConsistentMap<DeviceKey, DeviceDescription> deviceDescriptions;
    private EventuallyConsistentMap<PortKey, PortDescription> portDescriptions;
    private EventuallyConsistentMap<DeviceId, Map<PortNumber, PortStatistics>> devicePortStats;
    private EventuallyConsistentMap<DeviceId, Map<PortNumber, PortStatistics>> devicePortDeltaStats;
    private DistributedSet<DeviceId> availableDevices;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipTermService mastershipTermService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceClockService deviceClockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private NodeId localNodeId;
    private EventuallyConsistentMapListener<DeviceKey, DeviceDescription> deviceUpdateListener = new InternalDeviceChangeEventListener();
    private EventuallyConsistentMapListener<PortKey, PortDescription> portUpdateListener = new InternalPortChangeEventListener();
    private final EventuallyConsistentMapListener<DeviceId, Map<PortNumber, PortStatistics>> portStatsListener = new InternalPortStatsListener();
    private final SetEventListener<DeviceId> deviceStatusTracker = new InternalDeviceStatusTracker();
    protected static final Serializer SERIALIZER = Serializer.using((KryoNamespace)KryoNamespace.newBuilder().register(DistributedStoreSerializers.STORE_COMMON).nextId(510).build("ECDevice"));
    protected static final KryoNamespace.Builder SERIALIZER_BUILDER = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{DeviceKey.class}).register(new Class[]{PortKey.class}).register(new Class[]{DeviceKey.class}).register(new Class[]{PortKey.class}).register(new Class[]{MastershipBasedTimestamp.class});

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.deviceDescriptions = this.storageService.eventuallyConsistentMapBuilder().withName("onos-device-descriptions").withSerializer(SERIALIZER_BUILDER).withTimestampProvider((k, v) -> {
            try {
                return this.deviceClockService.getTimestamp(k.deviceId());
            }
            catch (IllegalStateException e) {
                return null;
            }
        }).build();
        this.portDescriptions = this.storageService.eventuallyConsistentMapBuilder().withName("onos-port-descriptions").withSerializer(SERIALIZER_BUILDER).withTimestampProvider((k, v) -> {
            try {
                return this.deviceClockService.getTimestamp(k.deviceId());
            }
            catch (IllegalStateException e) {
                return null;
            }
        }).build();
        this.devicePortStats = this.storageService.eventuallyConsistentMapBuilder().withName("onos-port-stats").withSerializer(SERIALIZER_BUILDER).withAntiEntropyPeriod(5L, TimeUnit.SECONDS).withTimestampProvider((k, v) -> new WallClockTimestamp()).withTombstonesDisabled().build();
        this.devicePortDeltaStats = this.storageService.eventuallyConsistentMapBuilder().withName("onos-port-stats-delta").withSerializer(SERIALIZER_BUILDER).withAntiEntropyPeriod(5L, TimeUnit.SECONDS).withTimestampProvider((k, v) -> new WallClockTimestamp()).withTombstonesDisabled().build();
        this.availableDevices = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("onos-online-devices")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).withRelaxedReadConsistency()).build()).asDistributedSet();
        this.deviceDescriptions.addListener(this.deviceUpdateListener);
        this.portDescriptions.addListener(this.portUpdateListener);
        this.devicePortStats.addListener(this.portStatsListener);
        this.availableDevices.addListener(this.deviceStatusTracker);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.devicePortStats.removeListener(this.portStatsListener);
        this.deviceDescriptions.removeListener(this.deviceUpdateListener);
        this.portDescriptions.removeListener(this.portUpdateListener);
        this.availableDevices.removeListener(this.deviceStatusTracker);
        this.devicePortStats.destroy();
        this.devicePortDeltaStats.destroy();
        this.deviceDescriptions.destroy();
        this.portDescriptions.destroy();
        this.devices.clear();
        this.devicePorts.clear();
        this.log.info("Stopped");
    }

    public Iterable<Device> getDevices() {
        return this.devices.values();
    }

    public int getDeviceCount() {
        return this.devices.size();
    }

    public int getAvailableDeviceCount() {
        return this.availableDevices.size();
    }

    public Device getDevice(DeviceId deviceId) {
        return this.devices.get(deviceId);
    }

    public DeviceEvent createOrUpdateDevice(ProviderId providerId, DeviceId deviceId, DeviceDescription deviceDescription) {
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        if (this.localNodeId.equals((Object)master)) {
            this.deviceDescriptions.put((Object)new DeviceKey(providerId, deviceId), (Object)deviceDescription);
            return this.refreshDeviceCache(providerId, deviceId);
        }
        return null;
    }

    private DeviceEvent refreshDeviceCache(ProviderId providerId, DeviceId deviceId) {
        AtomicReference eventType = new AtomicReference();
        Device device = this.devices.compute(deviceId, (k, existingDevice) -> {
            Device newDevice = this.composeDevice(deviceId);
            if (existingDevice == null) {
                eventType.set(DeviceEvent.Type.DEVICE_ADDED);
            } else {
                boolean annotationsChanged;
                boolean propertiesChanged = !Objects.equals(existingDevice.hwVersion(), newDevice.hwVersion()) || !Objects.equals(existingDevice.swVersion(), newDevice.swVersion()) || !Objects.equals(existingDevice.providerId(), newDevice.providerId());
                boolean bl = annotationsChanged = !AnnotationsUtil.isEqual((Annotations)existingDevice.annotations(), (Annotations)newDevice.annotations());
                if (providerId.isAncillary() && annotationsChanged || !providerId.isAncillary() && (propertiesChanged || annotationsChanged)) {
                    boolean replaced = this.devices.replace(deviceId, (Device)existingDevice, newDevice);
                    Verify.verify((boolean)replaced, (String)"Replacing devices cache failed. PID:%s [expected:%s, found:%s, new=%s]", (Object[])new Object[]{providerId, existingDevice, this.devices.get(deviceId), newDevice});
                    eventType.set(DeviceEvent.Type.DEVICE_UPDATED);
                }
            }
            return newDevice;
        });
        if (eventType.get() != null && !providerId.isAncillary()) {
            this.markOnline(deviceId);
        }
        return eventType.get() != null ? new DeviceEvent((DeviceEvent.Type)eventType.get(), device) : null;
    }

    private Set<ProviderId> getAllProviders(DeviceId deviceId) {
        return this.deviceDescriptions.keySet().stream().filter(deviceKey -> deviceKey.deviceId().equals((Object)deviceId)).map(deviceKey -> deviceKey.providerId()).collect(Collectors.toSet());
    }

    private ProviderId getPrimaryProviderId(DeviceId deviceId) {
        Set<ProviderId> allProviderIds = this.getAllProviders(deviceId);
        return allProviderIds.stream().filter(p -> !p.isAncillary()).findFirst().orElse((ProviderId)Iterables.getFirst(allProviderIds, null));
    }

    private Device composeDevice(DeviceId deviceId) {
        ProviderId primaryProviderId = this.getPrimaryProviderId(deviceId);
        DeviceDescription primaryDeviceDescription = (DeviceDescription)this.deviceDescriptions.get((Object)new DeviceKey(primaryProviderId, deviceId));
        Device.Type type = primaryDeviceDescription.type();
        String manufacturer = primaryDeviceDescription.manufacturer();
        String hwVersion = primaryDeviceDescription.hwVersion();
        String swVersion = primaryDeviceDescription.swVersion();
        String serialNumber = primaryDeviceDescription.serialNumber();
        ChassisId chassisId = primaryDeviceDescription.chassisId();
        DefaultAnnotations annotations = this.mergeAnnotations(deviceId);
        return new DefaultDevice(primaryProviderId, deviceId, type, manufacturer, hwVersion, swVersion, serialNumber, chassisId, new Annotations[]{annotations});
    }

    private DeviceEvent purgeDeviceCache(DeviceId deviceId) {
        Device removedDevice = this.devices.remove(deviceId);
        if (removedDevice != null) {
            this.getAllProviders(deviceId).forEach(p -> {
                DeviceDescription cfr_ignored_0 = (DeviceDescription)this.deviceDescriptions.remove((Object)new DeviceKey((ProviderId)p, deviceId));
            });
            return new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, removedDevice);
        }
        return null;
    }

    public DeviceEvent markOnline(DeviceId deviceId) {
        if (this.devices.containsKey(deviceId) && this.availableDevices.add((Object)deviceId)) {
            return new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, this.devices.get(deviceId), null);
        }
        this.log.warn("Device {} does not exist in store", (Object)deviceId);
        return null;
    }

    public DeviceEvent markOffline(DeviceId deviceId) {
        this.availableDevices.remove((Object)deviceId);
        return null;
    }

    public List<DeviceEvent> updatePorts(ProviderId providerId, DeviceId deviceId, List<PortDescription> descriptions) {
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        List<DeviceEvent> deviceEvents = null;
        if (!this.localNodeId.equals((Object)master)) {
            return Collections.emptyList();
        }
        descriptions.forEach(description -> {
            PortKey portKey = new PortKey(providerId, deviceId, description.portNumber());
            this.portDescriptions.put((Object)portKey, description);
        });
        deviceEvents = this.refreshDevicePortCache(providerId, deviceId, Optional.empty());
        return deviceEvents == null ? Collections.emptyList() : deviceEvents;
    }

    private List<DeviceEvent> refreshDevicePortCache(ProviderId providerId, DeviceId deviceId, Optional<PortNumber> portNumber) {
        Device device = this.devices.get(deviceId);
        Preconditions.checkArgument((device != null ? 1 : 0) != 0, (String)DEVICE_NOT_FOUND, (Object)deviceId);
        ArrayList events = Lists.newArrayList();
        Map ports = this.devicePorts.computeIfAbsent(deviceId, key -> Maps.newConcurrentMap());
        ArrayList descriptions = Lists.newArrayList();
        this.portDescriptions.entrySet().forEach(e -> {
            PortKey key = (PortKey)e.getKey();
            PortDescription value = (PortDescription)e.getValue();
            if (key.deviceId().equals((Object)deviceId) && key.providerId().equals((Object)providerId)) {
                if (portNumber.isPresent()) {
                    if (((PortNumber)portNumber.get()).equals((Object)key.portNumber())) {
                        descriptions.add(value);
                    }
                } else {
                    descriptions.add(value);
                }
            }
        });
        for (PortDescription description : descriptions) {
            PortNumber number = description.portNumber();
            ports.compute(number, (k, existingPort) -> {
                Port newPort = this.composePort(device, number);
                if (existingPort == null) {
                    events.add(new DeviceEvent(DeviceEvent.Type.PORT_ADDED, device, newPort));
                } else if (existingPort.isEnabled() != newPort.isEnabled() || existingPort.type() != newPort.type() || existingPort.portSpeed() != newPort.portSpeed() || !AnnotationsUtil.isEqual((Annotations)existingPort.annotations(), (Annotations)newPort.annotations())) {
                    events.add(new DeviceEvent(DeviceEvent.Type.PORT_UPDATED, device, newPort));
                }
                return newPort;
            });
        }
        return events;
    }

    private Port composePort(Device device, PortNumber number) {
        HashMap descriptions = Maps.newHashMap();
        this.portDescriptions.entrySet().forEach(entry -> {
            PortKey portKey = (PortKey)entry.getKey();
            if (portKey.deviceId().equals((Object)device.id()) && portKey.portNumber().equals((Object)number)) {
                descriptions.put(portKey.providerId(), (PortDescription)entry.getValue());
            }
        });
        ProviderId primary = this.getPrimaryProviderId(device.id());
        PortDescription primaryDescription = (PortDescription)descriptions.get(primary);
        boolean isEnabled = false;
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        if (primaryDescription != null) {
            isEnabled = primaryDescription.isEnabled();
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)primaryDescription.annotations());
        }
        DefaultPort updated = null;
        for (Map.Entry e : descriptions.entrySet()) {
            if (((ProviderId)e.getKey()).equals((Object)primary)) continue;
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)((PortDescription)e.getValue()).annotations());
            updated = this.buildTypedPort(device, number, isEnabled, (PortDescription)e.getValue(), (Annotations)annotations);
        }
        if (primaryDescription == null) {
            return updated == null ? new DefaultPort((Element)device, number, false, new Annotations[]{annotations}) : updated;
        }
        return updated == null ? this.buildTypedPort(device, number, isEnabled, primaryDescription, (Annotations)annotations) : updated;
    }

    private Port buildTypedPort(Device device, PortNumber number, boolean isEnabled, PortDescription description, Annotations annotations) {
        return new DefaultPort((Element)device, number, isEnabled, description.type(), description.portSpeed(), new Annotations[]{annotations});
    }

    public DeviceEvent updatePortStatus(ProviderId providerId, DeviceId deviceId, PortDescription portDescription) {
        this.portDescriptions.put((Object)new PortKey(providerId, deviceId, portDescription.portNumber()), (Object)portDescription);
        List<DeviceEvent> events = this.refreshDevicePortCache(providerId, deviceId, Optional.of(portDescription.portNumber()));
        return (DeviceEvent)Iterables.getFirst(events, null);
    }

    public List<Port> getPorts(DeviceId deviceId) {
        return ImmutableList.copyOf(this.devicePorts.getOrDefault(deviceId, Maps.newHashMap()).values());
    }

    public Stream<PortDescription> getPortDescriptions(ProviderId pid, DeviceId deviceId) {
        return this.portDescriptions.entrySet().stream().filter(e -> ((PortKey)e.getKey()).providerId().equals((Object)pid)).map(Map.Entry::getValue);
    }

    public Port getPort(DeviceId deviceId, PortNumber portNumber) {
        return this.devicePorts.getOrDefault(deviceId, Maps.newHashMap()).get(portNumber);
    }

    public PortDescription getPortDescription(ProviderId pid, DeviceId deviceId, PortNumber portNumber) {
        return (PortDescription)this.portDescriptions.get((Object)new PortKey(pid, deviceId, portNumber));
    }

    public DeviceEvent updatePortStatistics(ProviderId providerId, DeviceId deviceId, Collection<PortStatistics> newStatsCollection) {
        Map prvStatsMap = (Map)this.devicePortStats.get((Object)deviceId);
        HashMap newStatsMap = Maps.newHashMap();
        HashMap deltaStatsMap = Maps.newHashMap();
        if (prvStatsMap != null) {
            for (PortStatistics newStats : newStatsCollection) {
                PortNumber port = PortNumber.portNumber((long)newStats.port());
                PortStatistics prvStats = (PortStatistics)prvStatsMap.get(port);
                DefaultPortStatistics.Builder builder = DefaultPortStatistics.builder();
                DefaultPortStatistics deltaStats = builder.build();
                if (prvStats != null) {
                    deltaStats = this.calcDeltaStats(deviceId, prvStats, newStats);
                }
                deltaStatsMap.put(port, deltaStats);
                newStatsMap.put(port, newStats);
            }
        } else {
            for (PortStatistics newStats : newStatsCollection) {
                PortNumber port = PortNumber.portNumber((long)newStats.port());
                newStatsMap.put(port, newStats);
            }
        }
        this.devicePortDeltaStats.put((Object)deviceId, (Object)deltaStatsMap);
        this.devicePortStats.put((Object)deviceId, (Object)newStatsMap);
        return null;
    }

    public PortStatistics calcDeltaStats(DeviceId deviceId, PortStatistics prvStats, PortStatistics newStats) {
        long deltaStatsSec;
        long deltaStatsNano;
        if (newStats.durationNano() < prvStats.durationNano()) {
            deltaStatsNano = newStats.durationNano() - prvStats.durationNano() + TimeUnit.SECONDS.toNanos(1L);
            deltaStatsSec = newStats.durationSec() - prvStats.durationSec() - 1L;
        } else {
            deltaStatsNano = newStats.durationNano() - prvStats.durationNano();
            deltaStatsSec = newStats.durationSec() - prvStats.durationSec();
        }
        DefaultPortStatistics.Builder builder = DefaultPortStatistics.builder();
        DefaultPortStatistics deltaStats = builder.setDeviceId(deviceId).setPort(newStats.port()).setPacketsReceived(newStats.packetsReceived() - prvStats.packetsReceived()).setPacketsSent(newStats.packetsSent() - prvStats.packetsSent()).setBytesReceived(newStats.bytesReceived() - prvStats.bytesReceived()).setBytesSent(newStats.bytesSent() - prvStats.bytesSent()).setPacketsRxDropped(newStats.packetsRxDropped() - prvStats.packetsRxDropped()).setPacketsTxDropped(newStats.packetsTxDropped() - prvStats.packetsTxDropped()).setPacketsRxErrors(newStats.packetsRxErrors() - prvStats.packetsRxErrors()).setPacketsTxErrors(newStats.packetsTxErrors() - prvStats.packetsTxErrors()).setDurationSec(deltaStatsSec).setDurationNano(deltaStatsNano).build();
        return deltaStats;
    }

    public List<PortStatistics> getPortStatistics(DeviceId deviceId) {
        Map portStats = (Map)this.devicePortStats.get((Object)deviceId);
        if (portStats == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(portStats.values());
    }

    public PortStatistics getStatisticsForPort(DeviceId deviceId, PortNumber portNumber) {
        Map portStatsMap = (Map)this.devicePortStats.get((Object)deviceId);
        if (portStatsMap == null) {
            return null;
        }
        PortStatistics portStats = (PortStatistics)portStatsMap.get(portNumber);
        return portStats;
    }

    public List<PortStatistics> getPortDeltaStatistics(DeviceId deviceId) {
        Map portStats = (Map)this.devicePortDeltaStats.get((Object)deviceId);
        if (portStats == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(portStats.values());
    }

    public PortStatistics getDeltaStatisticsForPort(DeviceId deviceId, PortNumber portNumber) {
        Map portStatsMap = (Map)this.devicePortDeltaStats.get((Object)deviceId);
        if (portStatsMap == null) {
            return null;
        }
        PortStatistics portStats = (PortStatistics)portStatsMap.get(portNumber);
        return portStats;
    }

    public boolean isAvailable(DeviceId deviceId) {
        return this.availableDevices.contains((Object)deviceId);
    }

    public Iterable<Device> getAvailableDevices() {
        return Iterables.filter((Iterable)Iterables.transform(this.availableDevices, this.devices::get), d -> d != null);
    }

    public DeviceEvent removeDevice(DeviceId deviceId) {
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        boolean relinquishAtEnd = false;
        if (master == null) {
            MastershipRole myRole = this.mastershipService.getLocalRole(deviceId);
            if (myRole != MastershipRole.NONE) {
                relinquishAtEnd = true;
            }
            this.log.debug("Temporarily requesting role for {} to remove", (Object)deviceId);
            MastershipRole role = (MastershipRole)Futures.getUnchecked((Future)this.mastershipService.requestRoleFor(deviceId));
            if (role == MastershipRole.MASTER) {
                master = this.localNodeId;
            }
        }
        if (!this.localNodeId.equals((Object)master)) {
            this.log.debug("{} has control of {}, forwarding remove request", (Object)master, (Object)deviceId);
            this.clusterCommunicator.unicast((Object)deviceId, GossipDeviceStoreMessageSubjects.DEVICE_REMOVE_REQ, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), master).whenComplete((r, e) -> {
                if (e != null) {
                    this.log.error("Failed to forward {} remove request to its master", (Object)deviceId, e);
                }
            });
            return null;
        }
        DeviceEvent event = null;
        DeviceKey deviceKey = new DeviceKey(this.getPrimaryProviderId(deviceId), deviceId);
        DeviceDescription removedDeviceDescription = (DeviceDescription)this.deviceDescriptions.remove((Object)deviceKey);
        if (removedDeviceDescription != null) {
            event = this.purgeDeviceCache(deviceId);
        }
        if (relinquishAtEnd) {
            this.log.debug("Relinquishing temporary role acquired for {}", (Object)deviceId);
            this.mastershipService.relinquishMastership(deviceId);
        }
        return event;
    }

    private DefaultAnnotations mergeAnnotations(DeviceId deviceId) {
        ProviderId primaryProviderId = this.getPrimaryProviderId(deviceId);
        DeviceDescription primaryDeviceDescription = (DeviceDescription)this.deviceDescriptions.get((Object)new DeviceKey(primaryProviderId, deviceId));
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)primaryDeviceDescription.annotations());
        for (ProviderId providerId : this.getAllProviders(deviceId)) {
            if (providerId.equals((Object)primaryProviderId)) continue;
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)((DeviceDescription)this.deviceDescriptions.get((Object)new DeviceKey(providerId, deviceId))).annotations());
        }
        return annotations;
    }

    private class InternalPortStatsListener
    implements EventuallyConsistentMapListener<DeviceId, Map<PortNumber, PortStatistics>> {
        private InternalPortStatsListener() {
        }

        public void event(EventuallyConsistentMapEvent<DeviceId, Map<PortNumber, PortStatistics>> event) {
            Device device;
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT && (device = (Device)ECDeviceStore.this.devices.get(event.key())) != null) {
                ECDeviceStore.this.notifyDelegate((Event)new DeviceEvent(DeviceEvent.Type.PORT_STATS_UPDATED, device));
            }
        }
    }

    private class InternalPortChangeEventListener
    implements EventuallyConsistentMapListener<PortKey, PortDescription> {
        private InternalPortChangeEventListener() {
        }

        public void event(EventuallyConsistentMapEvent<PortKey, PortDescription> event) {
            DeviceId deviceId = ((PortKey)event.key()).deviceId();
            ProviderId providerId = ((PortKey)event.key()).providerId();
            PortNumber portNumber = ((PortKey)event.key()).portNumber();
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                if (ECDeviceStore.this.devices.containsKey(deviceId)) {
                    List events = ECDeviceStore.this.refreshDevicePortCache(providerId, deviceId, Optional.of(portNumber));
                    for (DeviceEvent deviceEvent : events) {
                        ECDeviceStore.this.notifyDelegate((Event)deviceEvent);
                    }
                }
            } else if (event.type() == EventuallyConsistentMapEvent.Type.REMOVE) {
                ECDeviceStore.this.log.warn("Unexpected port removed event");
            }
        }
    }

    private class InternalDeviceChangeEventListener
    implements EventuallyConsistentMapListener<DeviceKey, DeviceDescription> {
        private InternalDeviceChangeEventListener() {
        }

        public void event(EventuallyConsistentMapEvent<DeviceKey, DeviceDescription> event) {
            DeviceId deviceId = ((DeviceKey)event.key()).deviceId();
            ProviderId providerId = ((DeviceKey)event.key()).providerId();
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                ECDeviceStore.this.notifyDelegate((Event)ECDeviceStore.this.refreshDeviceCache(providerId, deviceId));
                if (ECDeviceStore.this.pendingAvailableChangeUpdates.remove(deviceId)) {
                    ECDeviceStore.this.notifyDelegate((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, (Device)ECDeviceStore.this.devices.get(deviceId)));
                }
            } else if (event.type() == EventuallyConsistentMapEvent.Type.REMOVE) {
                ECDeviceStore.this.notifyDelegate((Event)ECDeviceStore.this.purgeDeviceCache(deviceId));
            }
        }
    }

    private class InternalDeviceStatusTracker
    implements SetEventListener<DeviceId> {
        private InternalDeviceStatusTracker() {
        }

        public void event(SetEvent<DeviceId> event) {
            DeviceId deviceId = (DeviceId)event.entry();
            Device device = (Device)ECDeviceStore.this.devices.get(deviceId);
            if (device != null) {
                ECDeviceStore.this.notifyDelegate((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, device));
            } else {
                ECDeviceStore.this.pendingAvailableChangeUpdates.add(deviceId);
            }
        }
    }
}

