/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.key.impl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.Event;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyEvent;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.DeviceKeyStore;
import org.onosproject.net.key.DeviceKeyStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedDeviceKeyStore
extends AbstractStore<DeviceKeyEvent, DeviceKeyStoreDelegate>
implements DeviceKeyStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<DeviceKeyId, DeviceKey> deviceKeys;
    private Map<DeviceKeyId, DeviceKey> deviceKeysMap;
    private final MapEventListener<DeviceKeyId, DeviceKey> listener = new InternalMapListener();

    @Activate
    public void activate() {
        this.deviceKeys = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{DeviceKey.class, DeviceKeyId.class, DeviceKey.Type.class}))).withName("onos-device-keys")).withRelaxedReadConsistency()).build();
        this.deviceKeys.addListener(this.listener);
        this.deviceKeysMap = this.deviceKeys.asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceKeys.removeListener(this.listener);
        this.log.info("Stopped");
    }

    public void createOrUpdateDeviceKey(DeviceKey deviceKey) {
        this.deviceKeys.put((Object)deviceKey.deviceKeyId(), (Object)deviceKey);
    }

    public void deleteDeviceKey(DeviceKeyId deviceKeyId) {
        this.deviceKeys.remove((Object)deviceKeyId);
    }

    public Collection<DeviceKey> getDeviceKeys() {
        return this.deviceKeysMap.values();
    }

    public DeviceKey getDeviceKey(DeviceKeyId deviceKeyId) {
        return this.deviceKeysMap.get(deviceKeyId);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalMapListener
    implements MapEventListener<DeviceKeyId, DeviceKey> {
        private InternalMapListener() {
        }

        public void event(MapEvent<DeviceKeyId, DeviceKey> event) {
            DeviceKey deviceKey = null;
            DeviceKeyEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    type = DeviceKeyEvent.Type.DEVICE_KEY_ADDED;
                    deviceKey = (DeviceKey)Preconditions.checkNotNull((Object)((DeviceKey)event.newValue().value()));
                    break;
                }
                case UPDATE: {
                    type = DeviceKeyEvent.Type.DEVICE_KEY_UPDATED;
                    deviceKey = (DeviceKey)Preconditions.checkNotNull((Object)((DeviceKey)event.newValue().value()));
                    break;
                }
                case REMOVE: {
                    type = DeviceKeyEvent.Type.DEVICE_KEY_REMOVED;
                    deviceKey = (DeviceKey)Preconditions.checkNotNull((Object)((DeviceKey)event.oldValue().value()));
                    break;
                }
                default: {
                    DistributedDeviceKeyStore.this.log.error("Unsupported event type: " + event.type());
                }
            }
            DistributedDeviceKeyStore.this.notifyDelegate((Event)new DeviceKeyEvent(type, deviceKey));
        }
    }
}

