/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import java.util.Optional;
import java.util.Set;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumerId;
import org.onosproject.store.resource.impl.ConsistentResourceStore;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.TransactionalResourceSubStore;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionalDiscreteResourceSubStore
implements TransactionalResourceSubStore<DiscreteResourceId, DiscreteResource> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TransactionalMap<DiscreteResourceId, DiscreteResources> childMap;
    private final TransactionalMap<DiscreteResourceId, ResourceConsumerId> consumers;

    TransactionalDiscreteResourceSubStore(TransactionContext tx) {
        this.childMap = tx.getTransactionalMap("onos-resource-discrete-children", ConsistentResourceStore.SERIALIZER);
        this.consumers = tx.getTransactionalMap("onos-discrete-consumers", ConsistentResourceStore.SERIALIZER);
    }

    @Override
    public Optional<DiscreteResource> lookup(DiscreteResourceId id) {
        if (!id.parent().isPresent()) {
            return Optional.of(Resource.ROOT);
        }
        DiscreteResources values = (DiscreteResources)this.childMap.get((Object)((DiscreteResourceId)id.parent().get()));
        if (values == null) {
            return Optional.empty();
        }
        return values.lookup(id);
    }

    @Override
    public boolean register(DiscreteResourceId parent, Set<DiscreteResource> resources) {
        if (resources.isEmpty()) {
            return true;
        }
        DiscreteResources requested = DiscreteResources.of(resources);
        DiscreteResources oldValues = (DiscreteResources)this.childMap.putIfAbsent((Object)parent, (Object)requested);
        if (oldValues == null) {
            return true;
        }
        DiscreteResources addedValues = requested.difference(oldValues);
        if (addedValues.isEmpty()) {
            return true;
        }
        DiscreteResources newValues = oldValues.add(addedValues);
        return this.childMap.replace((Object)parent, (Object)oldValues, (Object)newValues);
    }

    @Override
    public boolean unregister(DiscreteResourceId parent, Set<DiscreteResource> resources) {
        if (resources.isEmpty()) {
            return true;
        }
        boolean allocated = resources.stream().anyMatch(x -> this.isAllocated(x.id()));
        if (allocated) {
            this.log.warn("Failed to unregister {}: allocation exists", (Object)parent);
            return false;
        }
        DiscreteResources oldValues = (DiscreteResources)this.childMap.putIfAbsent((Object)parent, (Object)DiscreteResources.empty());
        if (oldValues == null) {
            this.log.trace("No-Op removing values. key {} did not exist", (Object)parent);
            return true;
        }
        if (!oldValues.containsAny(resources)) {
            this.log.trace("No-Op removing values. key {} did not contain {}", (Object)parent, resources);
            return true;
        }
        DiscreteResources requested = DiscreteResources.of(resources);
        DiscreteResources newValues = oldValues.difference(requested);
        return this.childMap.replace((Object)parent, (Object)oldValues, (Object)newValues);
    }

    @Override
    public boolean isAllocated(DiscreteResourceId id) {
        return this.consumers.get((Object)id) != null;
    }

    @Override
    public boolean allocate(ResourceConsumerId consumerId, DiscreteResource resource) {
        Optional<DiscreteResource> lookedUp = this.lookup(resource.id());
        if (!lookedUp.isPresent()) {
            return false;
        }
        ResourceConsumerId oldValue = (ResourceConsumerId)this.consumers.put((Object)resource.id(), (Object)consumerId);
        return oldValue == null;
    }

    @Override
    public boolean release(ResourceConsumerId consumerId, DiscreteResource resource) {
        return this.consumers.remove((Object)resource.id(), (Object)consumerId);
    }
}

