/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.store.LogicalTimestamp;
import org.onosproject.store.flow.impl.BucketId;
import org.onosproject.store.flow.impl.FlowBucketDigest;
import org.onosproject.store.flow.impl.LogicalClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowBucket {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowBucket.class);
    private final BucketId bucketId;
    private volatile long term;
    private volatile LogicalTimestamp timestamp;
    private final Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>> flowBucket;

    FlowBucket(BucketId bucketId) {
        this(bucketId, 0L, new LogicalTimestamp(0L), Maps.newConcurrentMap());
    }

    private FlowBucket(BucketId bucketId, long term, LogicalTimestamp timestamp, Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>> flowBucket) {
        this.bucketId = bucketId;
        this.term = term;
        this.timestamp = timestamp;
        this.flowBucket = flowBucket;
    }

    public BucketId bucketId() {
        return this.bucketId;
    }

    public long term() {
        return this.term;
    }

    public LogicalTimestamp timestamp() {
        return this.timestamp;
    }

    public FlowBucketDigest getDigest() {
        return new FlowBucketDigest(this.bucketId().bucket(), this.term(), this.timestamp());
    }

    public Map<FlowId, Map<StoredFlowEntry, StoredFlowEntry>> getFlowBucket() {
        return this.flowBucket;
    }

    public Map<StoredFlowEntry, StoredFlowEntry> getFlowEntries(FlowId flowId) {
        Map flowEntries = this.flowBucket.get(flowId);
        return flowEntries != null ? flowEntries : this.flowBucket.computeIfAbsent(flowId, id -> Maps.newConcurrentMap());
    }

    public int count() {
        return this.flowBucket.values().stream().mapToInt(entry -> entry.values().size()).sum();
    }

    FlowBucket copy() {
        return new FlowBucket(this.bucketId, this.term, this.timestamp, this.flowBucket.entrySet().stream().map(e -> Maps.immutableEntry((Object)((FlowId)e.getKey()), (Object)Maps.newHashMap((Map)((Map)e.getValue())))).collect(Collectors.toMap(e -> (FlowId)e.getKey(), e -> (HashMap)e.getValue())));
    }

    private void recordUpdate(long term, LogicalTimestamp timestamp) {
        this.term = term;
        this.timestamp = timestamp;
    }

    public void add(FlowEntry rule, long term, LogicalClock clock) {
        Map flowEntries = this.flowBucket.get(rule.id());
        if (flowEntries == null) {
            flowEntries = this.flowBucket.computeIfAbsent(rule.id(), id -> Maps.newConcurrentMap());
        }
        flowEntries.put((StoredFlowEntry)((StoredFlowEntry)rule), (StoredFlowEntry)((StoredFlowEntry)rule));
        this.recordUpdate(term, clock.getTimestamp());
    }

    public void update(FlowEntry rule, long term, LogicalClock clock) {
        Map flowEntries = this.flowBucket.get(rule.id());
        if (flowEntries == null) {
            flowEntries = this.flowBucket.computeIfAbsent(rule.id(), id -> Maps.newConcurrentMap());
        }
        flowEntries.computeIfPresent((StoredFlowEntry)rule, (k, stored) -> {
            if (rule instanceof DefaultFlowEntry) {
                DefaultFlowEntry updated = (DefaultFlowEntry)rule;
                if (stored instanceof DefaultFlowEntry) {
                    DefaultFlowEntry storedEntry = (DefaultFlowEntry)stored;
                    if (updated.created() >= storedEntry.created()) {
                        this.recordUpdate(term, clock.getTimestamp());
                        return updated;
                    }
                    LOGGER.debug("Trying to update more recent flow entry {} (stored: {})", (Object)updated, stored);
                    return stored;
                }
            }
            return stored;
        });
    }

    public <T> T update(FlowRule rule, Function<StoredFlowEntry, T> function, long term, LogicalClock clock) {
        Map flowEntries = this.flowBucket.get(rule.id());
        if (flowEntries == null) {
            flowEntries = this.flowBucket.computeIfAbsent(rule.id(), id -> Maps.newConcurrentMap());
        }
        AtomicReference resultRef = new AtomicReference();
        flowEntries.computeIfPresent(new DefaultFlowEntry(rule), (k, stored) -> {
            Object result;
            if (stored != null && (result = function.apply((StoredFlowEntry)stored)) != null) {
                this.recordUpdate(term, clock.getTimestamp());
                resultRef.set(result);
            }
            return stored;
        });
        return (T)resultRef.get();
    }

    public FlowEntry remove(FlowEntry rule, long term, LogicalClock clock) {
        AtomicReference removedRule = new AtomicReference();
        this.flowBucket.computeIfPresent(rule.id(), (flowId, flowEntries) -> {
            flowEntries.computeIfPresent((StoredFlowEntry)rule, (k, stored) -> {
                if (rule instanceof DefaultFlowEntry) {
                    DefaultFlowEntry toRemove = (DefaultFlowEntry)rule;
                    if (stored instanceof DefaultFlowEntry) {
                        DefaultFlowEntry storedEntry = (DefaultFlowEntry)stored;
                        if (toRemove.created() < storedEntry.created()) {
                            LOGGER.debug("Trying to remove more recent flow entry {} (stored: {})", (Object)toRemove, stored);
                            return stored;
                        }
                    }
                }
                removedRule.set(stored);
                return null;
            });
            return flowEntries.isEmpty() ? null : flowEntries;
        });
        if (removedRule.get() != null) {
            this.recordUpdate(term, clock.getTimestamp());
            return (FlowEntry)removedRule.get();
        }
        return null;
    }

    public void purge() {
        this.flowBucket.clear();
    }

    public void clear() {
        this.term = 0L;
        this.timestamp = new LogicalTimestamp(0L);
        this.flowBucket.clear();
    }
}

