/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.base.Preconditions;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipInfo;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.store.flow.ReplicaInfo;
import org.onosproject.store.flow.ReplicaInfoEvent;
import org.onosproject.store.flow.ReplicaInfoEventListener;
import org.onosproject.store.flow.ReplicaInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ReplicaInfoManager
implements ReplicaInfoService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MastershipListener mastershipListener = new InternalMastershipListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    protected final ListenerRegistry<ReplicaInfoEvent, ReplicaInfoEventListener> listenerRegistry = new ListenerRegistry();

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(ReplicaInfoEvent.class, this.listenerRegistry);
        this.mastershipService.addListener((EventListener)this.mastershipListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(ReplicaInfoEvent.class);
        this.mastershipService.removeListener((EventListener)this.mastershipListener);
        this.log.info("Stopped");
    }

    @Override
    public ReplicaInfo getReplicaInfoFor(DeviceId deviceId) {
        return ReplicaInfoManager.buildFromRoleInfo(this.mastershipService.getMastershipFor(deviceId));
    }

    @Override
    public void addListener(ReplicaInfoEventListener listener) {
        this.listenerRegistry.addListener((EventListener)((ReplicaInfoEventListener)Preconditions.checkNotNull((Object)listener)));
    }

    @Override
    public void removeListener(ReplicaInfoEventListener listener) {
        this.listenerRegistry.removeListener((EventListener)((ReplicaInfoEventListener)Preconditions.checkNotNull((Object)listener)));
    }

    private static ReplicaInfo buildFromRoleInfo(MastershipInfo mastership) {
        return new ReplicaInfo(mastership.term(), mastership.master().orElse(null), mastership.backups());
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    final class InternalMastershipListener
    implements MastershipListener {
        InternalMastershipListener() {
        }

        public void event(MastershipEvent event) {
            ReplicaInfo replicaInfo = ReplicaInfoManager.buildFromRoleInfo(event.mastershipInfo());
            switch ((MastershipEvent.Type)event.type()) {
                case MASTER_CHANGED: {
                    ReplicaInfoManager.this.eventDispatcher.post((Event)new ReplicaInfoEvent(ReplicaInfoEvent.Type.MASTER_CHANGED, (DeviceId)event.subject(), replicaInfo));
                    break;
                }
                case BACKUPS_CHANGED: {
                    ReplicaInfoManager.this.eventDispatcher.post((Event)new ReplicaInfoEvent(ReplicaInfoEvent.Type.BACKUPS_CHANGED, (DeviceId)event.subject(), replicaInfo));
                    break;
                }
            }
        }
    }
}

