/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Objects;
import org.onosproject.store.Timestamp;

public final class MastershipBasedTimestamp
implements Timestamp {
    private final long termNumber;
    private final long sequenceNumber;

    protected MastershipBasedTimestamp() {
        this.termNumber = -1L;
        this.sequenceNumber = -1L;
    }

    public MastershipBasedTimestamp(long termNumber, long sequenceNumber) {
        this.termNumber = termNumber;
        this.sequenceNumber = sequenceNumber;
    }

    public int compareTo(Timestamp o) {
        Preconditions.checkArgument((boolean)(o instanceof MastershipBasedTimestamp), (String)"Must be MastershipBasedTimestamp", (Object)o);
        MastershipBasedTimestamp that = (MastershipBasedTimestamp)o;
        return ComparisonChain.start().compare(this.termNumber, that.termNumber).compare(this.sequenceNumber, that.sequenceNumber).result();
    }

    public int hashCode() {
        return Objects.hash(this.termNumber, this.sequenceNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MastershipBasedTimestamp)) {
            return false;
        }
        MastershipBasedTimestamp that = (MastershipBasedTimestamp)obj;
        return Objects.equals(this.termNumber, that.termNumber) && Objects.equals(this.sequenceNumber, that.sequenceNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("termNumber", this.termNumber).add("sequenceNumber", this.sequenceNumber).toString();
    }

    public long termNumber() {
        return this.termNumber;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }
}

