/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.pi.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiPipeconfId;
import org.onosproject.net.pi.service.PiPipeconfDeviceMappingEvent;
import org.onosproject.net.pi.service.PiPipeconfMappingStore;
import org.onosproject.net.pi.service.PiPipeconfMappingStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedDevicePipeconfMappingStore
extends AbstractStore<PiPipeconfDeviceMappingEvent, PiPipeconfMappingStoreDelegate>
implements PiPipeconfMappingStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    protected ConsistentMap<DeviceId, PiPipeconfId> deviceToPipeconf;
    protected final MapEventListener<DeviceId, PiPipeconfId> pipeconfListener = new InternalPiPipeconfListener();
    protected SetMultimap<PiPipeconfId, DeviceId> pipeconfToDevices = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    @Activate
    public void activate() {
        this.deviceToPipeconf = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pipeconf-table")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build();
        this.deviceToPipeconf.addListener(this.pipeconfListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceToPipeconf.removeListener(this.pipeconfListener);
        this.deviceToPipeconf = null;
        this.pipeconfToDevices = null;
        this.log.info("Stopped");
    }

    public PiPipeconfId getPipeconfId(DeviceId deviceId) {
        if (!this.deviceToPipeconf.containsKey((Object)deviceId)) {
            return null;
        }
        return (PiPipeconfId)this.deviceToPipeconf.get((Object)deviceId).value();
    }

    public Set<DeviceId> getDevices(PiPipeconfId pipeconfId) {
        return ImmutableSet.copyOf((Collection)this.pipeconfToDevices.get((Object)pipeconfId));
    }

    public void createOrUpdateBinding(DeviceId deviceId, PiPipeconfId pipeconfId) {
        this.deviceToPipeconf.put((Object)deviceId, (Object)pipeconfId);
    }

    public void removeBinding(DeviceId deviceId) {
        this.deviceToPipeconf.remove((Object)deviceId);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalPiPipeconfListener
    implements MapEventListener<DeviceId, PiPipeconfId> {
        private InternalPiPipeconfListener() {
        }

        public void event(MapEvent<DeviceId, PiPipeconfId> mapEvent) {
            PiPipeconfDeviceMappingEvent.Type eventType = null;
            DeviceId deviceId = (DeviceId)mapEvent.key();
            PiPipeconfId newPipeconfId = mapEvent.newValue() != null ? (PiPipeconfId)mapEvent.newValue().value() : null;
            PiPipeconfId oldPipeconfId = mapEvent.oldValue() != null ? (PiPipeconfId)mapEvent.oldValue().value() : null;
            switch (mapEvent.type()) {
                case INSERT: 
                case UPDATE: {
                    if (newPipeconfId == null) break;
                    if (!newPipeconfId.equals((Object)oldPipeconfId)) {
                        eventType = PiPipeconfDeviceMappingEvent.Type.CREATED;
                    }
                    DistributedDevicePipeconfMappingStore.this.pipeconfToDevices.put((Object)newPipeconfId, (Object)deviceId);
                    break;
                }
                case REMOVE: {
                    if (oldPipeconfId == null) break;
                    eventType = PiPipeconfDeviceMappingEvent.Type.REMOVED;
                    DistributedDevicePipeconfMappingStore.this.pipeconfToDevices.remove((Object)oldPipeconfId, (Object)deviceId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong event type " + mapEvent.type());
                }
            }
            if (eventType != null) {
                DistributedDevicePipeconfMappingStore.this.notifyDelegate((Event)new PiPipeconfDeviceMappingEvent(eventType, deviceId));
            }
        }
    }
}

