/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cfg;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cfg.ComponentConfigEvent;
import org.onosproject.cfg.ComponentConfigStore;
import org.onosproject.cfg.ComponentConfigStoreDelegate;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class GossipComponentConfigStore
extends AbstractStore<ComponentConfigEvent, ComponentConfigStoreDelegate>
implements ComponentConfigStore {
    private static final String SEP = "#";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private EventuallyConsistentMap<String, String> properties;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogicalClockService clockService;

    @Activate
    public void activate() {
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API);
        this.properties = this.storageService.eventuallyConsistentMapBuilder().withName("cfg").withSerializer(serializer).withClockService((k, v) -> this.clockService.getTimestamp()).build();
        this.properties.addListener((EventuallyConsistentMapListener)new InternalPropertiesListener());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.properties.destroy();
        this.log.info("Stopped");
    }

    public void setProperty(String componentName, String name, String value) {
        this.properties.put((Object)this.key(componentName, name), (Object)value);
    }

    public void unsetProperty(String componentName, String name) {
        this.properties.remove((Object)this.key(componentName, name));
    }

    private String key(String componentName, String name) {
        return componentName + SEP + name;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClockService(LogicalClockService logicalClockService) {
        this.clockService = logicalClockService;
    }

    protected void unbindClockService(LogicalClockService logicalClockService) {
        if (this.clockService == logicalClockService) {
            this.clockService = null;
        }
    }

    private final class InternalPropertiesListener
    implements EventuallyConsistentMapListener<String, String> {
        private InternalPropertiesListener() {
        }

        public void event(EventuallyConsistentMapEvent<String, String> event) {
            String[] keys = ((String)event.key()).split(GossipComponentConfigStore.SEP);
            String value = (String)event.value();
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                ((ComponentConfigStoreDelegate)GossipComponentConfigStore.this.delegate).notify((Event)new ComponentConfigEvent(ComponentConfigEvent.Type.PROPERTY_SET, keys[0], keys[1], value));
            } else if (event.type() == EventuallyConsistentMapEvent.Type.REMOVE) {
                ((ComponentConfigStoreDelegate)GossipComponentConfigStore.this.delegate).notify((Event)new ComponentConfigEvent(ComponentConfigEvent.Type.PROPERTY_UNSET, keys[0], keys[1], null));
            }
        }
    }
}

