/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.kuujo.copycat.CopycatConfig;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.cluster.internal.coordinator.ClusterCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.log.BufferedLog;
import net.kuujo.copycat.log.FileLog;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.protocol.Protocol;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;
import net.kuujo.copycat.util.serializer.Serializer;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.core.IdGenerator;
import org.onosproject.store.cluster.impl.ClusterDefinitionManager;
import org.onosproject.store.cluster.impl.NodeInfo;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.consistent.impl.CopycatCommunicationProtocol;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DatabaseConfig;
import org.onosproject.store.consistent.impl.DatabaseDefinition;
import org.onosproject.store.consistent.impl.DatabaseDefinitionStore;
import org.onosproject.store.consistent.impl.DatabaseSerializer;
import org.onosproject.store.consistent.impl.DefaultAtomicCounterBuilder;
import org.onosproject.store.consistent.impl.DefaultConsistentMapBuilder;
import org.onosproject.store.consistent.impl.DefaultSetBuilder;
import org.onosproject.store.consistent.impl.DefaultTransactionContextBuilder;
import org.onosproject.store.consistent.impl.PartitionedDatabase;
import org.onosproject.store.consistent.impl.TransactionManager;
import org.onosproject.store.ecmap.EventuallyConsistentMapBuilderImpl;
import org.onosproject.store.service.AtomicCounterBuilder;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.EventuallyConsistentMapBuilder;
import org.onosproject.store.service.MapInfo;
import org.onosproject.store.service.PartitionInfo;
import org.onosproject.store.service.SetBuilder;
import org.onosproject.store.service.StorageAdminService;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Transaction;
import org.onosproject.store.service.TransactionContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class DatabaseManager
implements StorageService,
StorageAdminService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int COPYCAT_TCP_PORT = 9876;
    public static final String PARTITION_DEFINITION_FILE = "../config/tablets.json";
    public static final String BASE_PARTITION_NAME = "p0";
    private static final int RAFT_ELECTION_TIMEOUT_MILLIS = 3000;
    private static final int DATABASE_OPERATION_TIMEOUT_MILLIS = 5000;
    private ClusterCoordinator coordinator;
    private PartitionedDatabase partitionedDatabase;
    private Database inMemoryDatabase;
    private TransactionManager transactionManager;
    private final IdGenerator transactionIdGenerator = () -> RandomUtils.nextLong();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;

    protected String nodeToUri(NodeInfo node) {
        return String.format("onos://%s:%d", node.getIp(), node.getTcpPort());
    }

    @Activate
    public void activate() {
        Map<String, Set<NodeInfo>> partitionMap;
        File databaseDefFile = new File(PARTITION_DEFINITION_FILE);
        this.log.info("Loading database definition: {}", (Object)databaseDefFile.getAbsolutePath());
        try {
            DatabaseDefinitionStore databaseDefStore = new DatabaseDefinitionStore(databaseDefFile);
            if (!databaseDefFile.exists()) {
                this.createDefaultDatabaseDefinition(databaseDefStore);
            }
            partitionMap = databaseDefStore.read().getPartitions();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load database config", e);
        }
        String[] activeNodeUris = (String[])partitionMap.values().stream().reduce((s1, s2) -> Sets.union((Set)s1, (Set)s2)).get().stream().map(this::nodeToUri).toArray(String[]::new);
        String localNodeUri = this.nodeToUri(NodeInfo.of(this.clusterService.getLocalNode()));
        CopycatCommunicationProtocol protocol = new CopycatCommunicationProtocol(this.clusterService, this.clusterCommunicator);
        ClusterConfig clusterConfig = new ClusterConfig().withProtocol((Protocol)protocol).withElectionTimeout(this.electionTimeoutMillis(activeNodeUris)).withHeartbeatInterval(this.heartbeatTimeoutMillis(activeNodeUris)).withMembers(activeNodeUris).withLocalMember(localNodeUri);
        CopycatConfig copycatConfig = new CopycatConfig().withName("onos").withClusterConfig(clusterConfig).withDefaultSerializer((Serializer)new DatabaseSerializer()).withDefaultExecutor((Executor)Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("copycat-coordinator-%d")));
        this.coordinator = new DefaultClusterCoordinator(copycatConfig.resolve());
        DatabaseConfig inMemoryDatabaseConfig = this.newDatabaseConfig(BASE_PARTITION_NAME, this.newInMemoryLog(), activeNodeUris);
        this.inMemoryDatabase = (Database)this.coordinator.getResource(inMemoryDatabaseConfig.getName(), inMemoryDatabaseConfig.resolve(clusterConfig).withSerializer(copycatConfig.getDefaultSerializer()).withDefaultExecutor(copycatConfig.getDefaultExecutor()));
        List<Database> partitions = partitionMap.entrySet().stream().map(entry -> {
            String[] replicas = (String[])((Set)entry.getValue()).stream().map(this::nodeToUri).toArray(String[]::new);
            return this.newDatabaseConfig((String)entry.getKey(), this.newPersistentLog(), replicas);
        }).map(config -> {
            Database db = (Database)this.coordinator.getResource(config.getName(), config.resolve(clusterConfig).withSerializer(copycatConfig.getDefaultSerializer()).withDefaultExecutor(copycatConfig.getDefaultExecutor()));
            return db;
        }).collect(Collectors.toList());
        this.partitionedDatabase = new PartitionedDatabase("onos-store", partitions);
        CompletionStage status = this.coordinator.open().thenCompose(v -> CompletableFuture.allOf(this.inMemoryDatabase.open(), this.partitionedDatabase.open()).whenComplete((db, error) -> {
            if (error != null) {
                this.log.error("Failed to initialize database.", error);
            } else {
                this.log.info("Successfully initialized database.");
            }
        }));
        Futures.getUnchecked((Future)((Object)status));
        this.transactionManager = new TransactionManager(this.partitionedDatabase);
        this.log.info("Started");
    }

    private void createDefaultDatabaseDefinition(DatabaseDefinitionStore store) {
        String ip = ClusterDefinitionManager.getSiteLocalAddress();
        NodeInfo node = NodeInfo.from(ip, ip, 9876);
        try {
            store.write(DatabaseDefinition.from((Set<NodeInfo>)ImmutableSet.of((Object)node)));
        }
        catch (IOException e) {
            this.log.warn("Unable to write default cluster definition", (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate() {
        ((CompletableFuture)CompletableFuture.allOf(this.inMemoryDatabase.close(), this.partitionedDatabase.close()).thenCompose(v -> this.coordinator.close())).whenComplete((result, error) -> {
            if (error != null) {
                this.log.warn("Failed to cleanly close databases.", error);
            } else {
                this.log.info("Successfully closed databases.");
            }
        });
        this.log.info("Stopped");
    }

    public TransactionContextBuilder transactionContextBuilder() {
        return new DefaultTransactionContextBuilder(this.inMemoryDatabase, this.partitionedDatabase, this.transactionIdGenerator.getNewId());
    }

    public List<PartitionInfo> getPartitionInfo() {
        return Lists.asList((Object)this.inMemoryDatabase, (Object[])this.partitionedDatabase.getPartitions().toArray(new Database[0])).stream().map(DatabaseManager::toPartitionInfo).collect(Collectors.toList());
    }

    private Log newPersistentLog() {
        String logDir = System.getProperty("karaf.data", "./data");
        return new FileLog().withDirectory(logDir).withSegmentSize(0x40000000).withFlushOnWrite(true).withSegmentInterval(Long.MAX_VALUE);
    }

    private Log newInMemoryLog() {
        return new BufferedLog().withFlushOnWrite(false).withFlushInterval(Long.MAX_VALUE).withSegmentSize(0xA00000).withSegmentInterval(Long.MAX_VALUE);
    }

    private DatabaseConfig newDatabaseConfig(String name, Log log, String[] replicas) {
        return (DatabaseConfig)((DatabaseConfig)((DatabaseConfig)((DatabaseConfig)((DatabaseConfig)new DatabaseConfig().withName(name).withElectionTimeout(this.electionTimeoutMillis(replicas))).withHeartbeatInterval(this.heartbeatTimeoutMillis(replicas))).withConsistency(Consistency.STRONG).withLog(log)).withDefaultSerializer((Serializer)new DatabaseSerializer())).withReplicas(replicas);
    }

    private long electionTimeoutMillis(String[] replicas) {
        return replicas.length == 1 ? 10L : 3000L;
    }

    private long heartbeatTimeoutMillis(String[] replicas) {
        return this.electionTimeoutMillis(replicas) / 2L;
    }

    private static PartitionInfo toPartitionInfo(Database database) {
        return new PartitionInfo(database.name(), database.cluster().term(), database.cluster().members().stream().filter(member -> Member.Type.ACTIVE.equals((Object)member.type())).map(Member::uri).sorted().collect(Collectors.toList()), database.cluster().leader() != null ? database.cluster().leader().uri() : null);
    }

    public <K, V> EventuallyConsistentMapBuilder<K, V> eventuallyConsistentMapBuilder() {
        return new EventuallyConsistentMapBuilderImpl(this.clusterService, this.clusterCommunicator);
    }

    public <K, V> ConsistentMapBuilder<K, V> consistentMapBuilder() {
        return new DefaultConsistentMapBuilder(this.inMemoryDatabase, this.partitionedDatabase);
    }

    public <E> SetBuilder<E> setBuilder() {
        return new DefaultSetBuilder(this.partitionedDatabase);
    }

    public AtomicCounterBuilder atomicCounterBuilder() {
        return new DefaultAtomicCounterBuilder(this.inMemoryDatabase, this.partitionedDatabase);
    }

    public List<MapInfo> getMapInfo() {
        ArrayList maps = Lists.newArrayList();
        maps.addAll(this.getMapInfo(this.inMemoryDatabase));
        maps.addAll(this.getMapInfo(this.partitionedDatabase));
        return maps;
    }

    private List<MapInfo> getMapInfo(Database database) {
        return DatabaseManager.complete(database.tableNames()).stream().map(name -> new MapInfo(name, DatabaseManager.complete(database.size((String)name)).intValue())).filter(info -> info.size() > 0).collect(Collectors.toList());
    }

    public Map<String, Long> getCounters() {
        HashMap counters = Maps.newHashMap();
        counters.putAll(DatabaseManager.complete(this.inMemoryDatabase.counters()));
        counters.putAll(DatabaseManager.complete(this.partitionedDatabase.counters()));
        return counters;
    }

    public Map<String, Long> getPartitionedDatabaseCounters() {
        HashMap counters = Maps.newHashMap();
        counters.putAll(DatabaseManager.complete(this.partitionedDatabase.counters()));
        return counters;
    }

    public Map<String, Long> getInMemoryDatabaseCounters() {
        HashMap counters = Maps.newHashMap();
        counters.putAll(DatabaseManager.complete(this.inMemoryDatabase.counters()));
        return counters;
    }

    public Collection<Transaction> getTransactions() {
        return DatabaseManager.complete(this.transactionManager.getTransactions());
    }

    private static <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsistentMapException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new ConsistentMapException.Timeout();
        }
        catch (ExecutionException e) {
            throw new ConsistentMapException(e.getCause());
        }
    }

    public void redriveTransactions() {
        this.getTransactions().stream().forEach(this.transactionManager::execute);
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }
}

