/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.util.HexString;
import org.onlab.util.Tools;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.Result;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;

public class DefaultAsyncConsistentMap<K, V>
implements AsyncConsistentMap<K, V> {
    private final String name;
    private final Database database;
    private final Serializer serializer;
    private final boolean readOnly;
    private static final String ERROR_NULL_KEY = "Key cannot be null";
    private static final String ERROR_NULL_VALUE = "Null values are not allowed";
    private final LoadingCache<K, String> keyCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<K, String>(){

        public String load(K key) {
            return HexString.toHexString((byte[])DefaultAsyncConsistentMap.this.serializer.encode(key));
        }
    });

    protected K dK(String key) {
        return (K)this.serializer.decode(HexString.fromHexString((String)key));
    }

    public DefaultAsyncConsistentMap(String name, Database database, Serializer serializer, boolean readOnly) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"map name cannot be null");
        this.database = (Database)Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.readOnly = readOnly;
    }

    public CompletableFuture<Integer> size() {
        return this.database.size(this.name);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.database.isEmpty(this.name);
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        return this.database.containsKey(this.name, this.keyCache.getUnchecked(key));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        return this.database.containsValue(this.name, this.serializer.encode(value));
    }

    public CompletableFuture<Versioned<V>> get(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        return this.database.get(this.name, this.keyCache.getUnchecked(key)).thenApply(v -> v != null ? new Versioned(this.serializer.decode((byte[])v.value()), v.version(), v.creationTime()) : null);
    }

    public CompletableFuture<Versioned<V>> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIf(key, Objects::isNull, (k, v) -> mappingFunction.apply((Object)k));
    }

    public CompletableFuture<Versioned<V>> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, Objects::nonNull, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, v -> true, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(condition, (Object)"predicate function cannot be null");
        Preconditions.checkNotNull(remappingFunction, (Object)"Remapping function cannot be null");
        return this.get(key).thenCompose(r1 -> {
            Object existingValue;
            Object object2 = existingValue = r1 == null ? null : r1.value();
            if (!condition.test((V)existingValue)) {
                return CompletableFuture.completedFuture(r1);
            }
            AtomicReference computedValue = new AtomicReference();
            try {
                computedValue.set(remappingFunction.apply((K)key, (V)existingValue));
            }
            catch (Exception e) {
                return Tools.exceptionalFuture((Throwable)e);
            }
            if (computedValue.get() == null) {
                if (r1 != null) {
                    return this.remove(key, r1.version()).thenApply(result -> {
                        if (result.booleanValue()) {
                            return null;
                        }
                        throw new ConsistentMapException.ConcurrentModification();
                    });
                }
                return CompletableFuture.completedFuture(null);
            }
            if (r1 != null) {
                return this.replaceAndGet(key, r1.version(), computedValue.get()).thenApply(v -> {
                    if (v.isPresent()) {
                        return (Versioned)v.get();
                    }
                    throw new ConsistentMapException.ConcurrentModification();
                });
            }
            return this.putIfAbsentAndGet(key, computedValue.get()).thenApply(result -> {
                if (!result.isPresent()) {
                    throw new ConsistentMapException.ConcurrentModification();
                }
                return (Versioned)result.get();
            });
        });
    }

    public CompletableFuture<Versioned<V>> put(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        this.checkIfUnmodifiable();
        return ((CompletableFuture)this.database.put(this.name, this.keyCache.getUnchecked(key), this.serializer.encode(value)).thenApply(this::unwrapResult)).thenApply(v -> v != null ? new Versioned(this.serializer.decode((byte[])v.value()), v.version(), v.creationTime()) : null);
    }

    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        this.checkIfUnmodifiable();
        return ((CompletableFuture)this.database.putAndGet(this.name, this.keyCache.getUnchecked(key), this.serializer.encode(value)).thenApply(this::unwrapResult)).thenApply(v -> {
            Versioned rawNewValue = (Versioned)v.newValue();
            return new Versioned(this.serializer.decode((byte[])rawNewValue.value()), rawNewValue.version(), rawNewValue.creationTime());
        });
    }

    public CompletableFuture<Optional<Versioned<V>>> putIfAbsentAndGet(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        this.checkIfUnmodifiable();
        return ((CompletableFuture)this.database.putIfAbsentAndGet(this.name, this.keyCache.getUnchecked(key), this.serializer.encode(value)).thenApply(this::unwrapResult)).thenApply(v -> {
            if (v.updated()) {
                Versioned rawNewValue = (Versioned)v.newValue();
                return Optional.of(new Versioned(this.serializer.decode((byte[])rawNewValue.value()), rawNewValue.version(), rawNewValue.creationTime()));
            }
            return Optional.empty();
        });
    }

    public CompletableFuture<Versioned<V>> remove(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        this.checkIfUnmodifiable();
        return ((CompletableFuture)this.database.remove(this.name, this.keyCache.getUnchecked(key)).thenApply(this::unwrapResult)).thenApply(v -> v != null ? new Versioned(this.serializer.decode((byte[])v.value()), v.version(), v.creationTime()) : null);
    }

    public CompletableFuture<Void> clear() {
        this.checkIfUnmodifiable();
        return this.database.clear(this.name).thenApply(this::unwrapResult);
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.database.keySet(this.name).thenApply(s -> s.stream().map(this::dK).collect(Collectors.toSet()));
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        return this.database.values(this.name).thenApply(c -> c.stream().map(v -> new Versioned(this.serializer.decode((byte[])v.value()), v.version(), v.creationTime())).collect(Collectors.toList()));
    }

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
        return this.database.entrySet(this.name).thenApply(s -> s.stream().map(this::fromRawEntry).collect(Collectors.toSet()));
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        this.checkIfUnmodifiable();
        return ((CompletableFuture)this.database.putIfAbsent(this.name, this.keyCache.getUnchecked(key), this.serializer.encode(value)).thenApply(this::unwrapResult)).thenApply(v -> v != null ? new Versioned(this.serializer.decode((byte[])v.value()), v.version(), v.creationTime()) : null);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        this.checkIfUnmodifiable();
        return this.database.remove(this.name, this.keyCache.getUnchecked(key), this.serializer.encode(value)).thenApply(this::unwrapResult);
    }

    public CompletableFuture<Boolean> remove(K key, long version) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        this.checkIfUnmodifiable();
        return this.database.remove(this.name, this.keyCache.getUnchecked(key), version).thenApply(this::unwrapResult);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(newValue, (Object)ERROR_NULL_VALUE);
        this.checkIfUnmodifiable();
        byte[] existing = oldValue != null ? this.serializer.encode(oldValue) : null;
        return this.database.replace(this.name, this.keyCache.getUnchecked(key), existing, this.serializer.encode(newValue)).thenApply(this::unwrapResult);
    }

    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return this.replaceAndGet(key, oldVersion, newValue).thenApply(Optional::isPresent);
    }

    public CompletableFuture<Optional<Versioned<V>>> replaceAndGet(K key, long oldVersion, V newValue) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(newValue, (Object)ERROR_NULL_VALUE);
        this.checkIfUnmodifiable();
        return ((CompletableFuture)this.database.replaceAndGet(this.name, this.keyCache.getUnchecked(key), oldVersion, this.serializer.encode(newValue)).thenApply(this::unwrapResult)).thenApply(v -> {
            if (v.updated()) {
                Versioned rawNewValue = (Versioned)v.newValue();
                return Optional.of(new Versioned(this.serializer.decode((byte[])rawNewValue.value()), rawNewValue.version(), rawNewValue.creationTime()));
            }
            return Optional.empty();
        });
    }

    private Map.Entry<K, Versioned<V>> fromRawEntry(Map.Entry<String, Versioned<byte[]>> e) {
        return Pair.of(this.dK(e.getKey()), (Object)new Versioned(this.serializer.decode((byte[])e.getValue().value()), e.getValue().version(), e.getValue().creationTime()));
    }

    private <T> T unwrapResult(Result<T> result) {
        if (result.status() == Result.Status.LOCKED) {
            throw new ConsistentMapException.ConcurrentModification();
        }
        if (result.success()) {
            return result.value();
        }
        throw new IllegalStateException("Must not be here");
    }

    private void checkIfUnmodifiable() {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
    }
}

