/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultAsyncConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;

public class DefaultConsistentMap<K, V>
implements ConsistentMap<K, V> {
    private static final int OPERATION_TIMEOUT_MILLIS = 5000;
    private final AsyncConsistentMap<K, V> asyncMap;

    public DefaultConsistentMap(String name, Database database, Serializer serializer, boolean readOnly) {
        this.asyncMap = new DefaultAsyncConsistentMap(name, database, serializer, readOnly);
    }

    public int size() {
        return (Integer)DefaultConsistentMap.complete(this.asyncMap.size());
    }

    public boolean isEmpty() {
        return (Boolean)DefaultConsistentMap.complete(this.asyncMap.isEmpty());
    }

    public boolean containsKey(K key) {
        return (Boolean)DefaultConsistentMap.complete(this.asyncMap.containsKey(key));
    }

    public boolean containsValue(V value) {
        return (Boolean)DefaultConsistentMap.complete(this.asyncMap.containsValue(value));
    }

    public Versioned<V> get(K key) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.get(key));
    }

    public Versioned<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.computeIfAbsent(key, mappingFunction));
    }

    public Versioned<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.computeIfPresent(key, remappingFunction));
    }

    public Versioned<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.compute(key, remappingFunction));
    }

    public Versioned<V> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.computeIf(key, condition, remappingFunction));
    }

    public Versioned<V> put(K key, V value) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.put(key, value));
    }

    public Versioned<V> putAndGet(K key, V value) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.putAndGet(key, value));
    }

    public Optional<Versioned<V>> putIfAbsentAndGet(K key, V value) {
        return (Optional)DefaultConsistentMap.complete(this.asyncMap.putIfAbsentAndGet(key, value));
    }

    public Versioned<V> remove(K key) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.remove(key));
    }

    public void clear() {
        DefaultConsistentMap.complete(this.asyncMap.clear());
    }

    public Set<K> keySet() {
        return (Set)DefaultConsistentMap.complete(this.asyncMap.keySet());
    }

    public Collection<Versioned<V>> values() {
        return (Collection)DefaultConsistentMap.complete(this.asyncMap.values());
    }

    public Set<Map.Entry<K, Versioned<V>>> entrySet() {
        return (Set)DefaultConsistentMap.complete(this.asyncMap.entrySet());
    }

    public Versioned<V> putIfAbsent(K key, V value) {
        return (Versioned)DefaultConsistentMap.complete(this.asyncMap.putIfAbsent(key, value));
    }

    public boolean remove(K key, V value) {
        return (Boolean)DefaultConsistentMap.complete(this.asyncMap.remove(key, value));
    }

    public boolean remove(K key, long version) {
        return (Boolean)DefaultConsistentMap.complete(this.asyncMap.remove(key, version));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return (Boolean)DefaultConsistentMap.complete(this.asyncMap.replace(key, oldValue, newValue));
    }

    public boolean replace(K key, long oldVersion, V newValue) {
        return (Boolean)DefaultConsistentMap.complete(this.asyncMap.replace(key, oldVersion, newValue));
    }

    public Optional<Versioned<V>> replaceAndGet(K key, long oldVersion, V newValue) {
        return (Optional)DefaultConsistentMap.complete(this.asyncMap.replaceAndGet(key, oldVersion, newValue));
    }

    private static <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsistentMapException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new ConsistentMapException.Timeout();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConsistentMapException) {
                throw (ConsistentMapException)e.getCause();
            }
            throw new ConsistentMapException(e.getCause());
        }
    }
}

