/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultAsyncConsistentMap;
import org.onosproject.store.consistent.impl.DefaultConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;

public class DefaultConsistentMapBuilder<K, V>
implements ConsistentMapBuilder<K, V> {
    private Serializer serializer;
    private String name;
    private boolean partitionsEnabled = true;
    private boolean readOnly = false;
    private final Database partitionedDatabase;
    private final Database inMemoryDatabase;

    public DefaultConsistentMapBuilder(Database inMemoryDatabase, Database partitionedDatabase) {
        this.inMemoryDatabase = inMemoryDatabase;
        this.partitionedDatabase = partitionedDatabase;
    }

    public ConsistentMapBuilder<K, V> withName(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0);
        this.name = name;
        return this;
    }

    public ConsistentMapBuilder<K, V> withSerializer(Serializer serializer) {
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0);
        this.serializer = serializer;
        return this;
    }

    public ConsistentMapBuilder<K, V> withPartitionsDisabled() {
        this.partitionsEnabled = false;
        return this;
    }

    public ConsistentMapBuilder<K, V> withUpdatesDisabled() {
        this.readOnly = true;
        return this;
    }

    private boolean validInputs() {
        return this.name != null && this.serializer != null;
    }

    public ConsistentMap<K, V> build() {
        Preconditions.checkState((boolean)this.validInputs());
        return new DefaultConsistentMap(this.name, this.partitionsEnabled ? this.partitionedDatabase : this.inMemoryDatabase, this.serializer, this.readOnly);
    }

    public AsyncConsistentMap<K, V> buildAsyncMap() {
        Preconditions.checkState((boolean)this.validInputs());
        return new DefaultAsyncConsistentMap(this.name, this.partitionsEnabled ? this.partitionedDatabase : this.inMemoryDatabase, this.serializer, this.readOnly);
    }
}

