/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultConsistentMap;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;

public class DefaultDistributedSet<E>
implements Set<E> {
    private final ConsistentMap<E, Boolean> backingMap;

    public DefaultDistributedSet(String name, Database database, Serializer serializer, boolean readOnly) {
        this.backingMap = new DefaultConsistentMap<E, Boolean>(name, database, serializer, readOnly);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingMap.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.backingMap.keySet().stream().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backingMap.keySet().stream().toArray((int size) -> a);
    }

    @Override
    public boolean add(E e) {
        return this.backingMap.putIfAbsent(e, (Object)true) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.backingMap.remove(o, (Object)true);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return c.stream().map(this::add).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet retainSet = Sets.newHashSet(c);
        return this.backingMap.keySet().stream().filter(k -> !retainSet.contains(k)).map(this::remove).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        HashSet removeSet = Sets.newHashSet(c);
        return this.backingMap.keySet().stream().filter(removeSet::contains).map(this::remove).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }
}

